/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.compat.jei.categories;

import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.compat.jei.Plugin;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.FurnitureRecipeCategory;
import com.mrcrayfish.furniture.refurbished.core.ModBlocks;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class FryingPanCookingCategory
extends FurnitureRecipeCategory<ProcessingRecipe> {
    public static final RecipeType<ProcessingRecipe> TYPE = RecipeType.create((String)"refurbished_furniture", (String)"frying_pan_cooking", ProcessingRecipe.class);
    private final ItemStack campfireStack = new ItemStack((ItemLike)Items.f_42781_);
    private final IGuiHelper helper;
    private final IDrawable background;
    private final IDrawable icon;
    private IDrawable arrow;

    public FryingPanCookingCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(Plugin.TEXTURES, 0, 72, 124, 82);
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.FRYING_PAN.get()));
    }

    public RecipeType<ProcessingRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Utils.translation("jei_category", "frying_pan_cooking", new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ProcessingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 27, 6).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 102, 36).addItemStack(Plugin.getResult(recipe));
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 74, 8).addItemStack(new ItemStack((ItemLike)ModItems.SPATULA.get()));
        this.arrow = this.helper.createAnimatedDrawable(this.helper.createDrawable(Plugin.TEXTURES, 93, 0, 24, 17), recipe.getTime(), IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void draw(ProcessingRecipe recipe, IRecipeSlotsView view, GuiGraphics graphics, double mouseX, double mouseY) {
        this.arrow.draw(graphics, 71, 36);
        this.drawSeconds(graphics, 83, 55, recipe.getTime());
        if (recipe.m_6671_() == net.minecraft.world.item.crafting.RecipeType.f_44111_) {
            graphics.m_280509_(102, 5, 118, 21, 0x33000000);
            graphics.m_280203_(this.campfireStack, 102, 5);
        }
    }

    public List<Component> getTooltipStrings(ProcessingRecipe recipe, IRecipeSlotsView view, double mouseX, double mouseY) {
        if (ScreenHelper.isMouseWithinBounds(mouseX, mouseY, 14, 22, 42, 13)) {
            return Plugin.getItemTooltip((ItemLike)ModBlocks.FRYING_PAN.get());
        }
        if (ScreenHelper.isMouseWithinBounds(mouseX, mouseY, 5, 26, 60, 48)) {
            return Plugin.getItemTooltip((ItemLike)ModBlocks.STOVE_LIGHT.get());
        }
        if (ScreenHelper.isMouseWithinBounds(mouseX, mouseY, 103, 5, 16, 16)) {
            return List.of(Utils.translation("gui", "jei_campfire_info", new Object[0]));
        }
        return super.getTooltipStrings((Object)recipe, view, mouseX, mouseY);
    }
}

