/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureAttachedFaceBlock;
import com.mrcrayfish.furniture.refurbished.block.MetalType;
import com.mrcrayfish.furniture.refurbished.blockentity.LightswitchBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.data.DropWithName;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LightswitchBlock
extends FurnitureAttachedFaceBlock
implements EntityBlock,
BlockTagSupplier,
DropWithName {
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    protected final MetalType type;

    public LightswitchBlock(MetalType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public MetalType getMetalType() {
        return this.type;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape wallShape = Block.m_49796_((double)14.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)11.0);
        VoxelShape ceilingShape = Block.m_49796_((double)4.0, (double)14.0, (double)5.0, (double)12.0, (double)16.0, (double)11.0);
        VoxelShape floorShape = Block.m_49796_((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)2.0, (double)11.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> {
            Direction facing = (Direction)state.m_61143_((Property)f_54117_);
            AttachFace face = (AttachFace)state.m_61143_((Property)f_53179_);
            return switch (face) {
                default -> throw new IncompatibleClassChangeError();
                case AttachFace.FLOOR -> VoxelShapeHelper.rotateHorizontally(floorShape, facing.m_122424_());
                case AttachFace.WALL -> VoxelShapeHelper.rotateHorizontally(wallShape, facing.m_122424_());
                case AttachFace.CEILING -> VoxelShapeHelper.rotateHorizontally(ceilingShape, facing.m_122424_());
            };
        })));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        boolean enabled = (Boolean)state.m_61143_((Property)ENABLED) == false;
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(enabled)), 3);
        Vec3 sound = this.getPositionForSound(state, pos);
        level.m_6263_(null, sound.f_82479_, sound.f_82480_, sound.f_82481_, (SoundEvent)ModSounds.BLOCK_LIGHTSWITCH_FLICK.get(), SoundSource.BLOCKS, 0.7f, enabled ? 1.0f : 0.8f);
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private Vec3 getPositionForSound(BlockState state, BlockPos pos) {
        Vec3 center = pos.m_252807_();
        AttachFace face = (AttachFace)state.m_61143_((Property)f_53179_);
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> center.m_82492_(0.0, 0.5, 0.0);
            case AttachFace.CEILING -> center.m_82520_(0.0, 0.5, 0.0);
            case AttachFace.WALL -> {
                Direction dir = ((Direction)state.m_61143_((Property)f_54117_)).m_122424_();
                yield center.m_82520_((double)dir.m_122429_() * 0.5, 0.0, (double)dir.m_122431_() * 0.5);
            }
        };
    }

    @Override
    public boolean m_7278_(BlockState state) {
        return true;
    }

    @Override
    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)ENABLED) != false ? 1 : 0;
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ENABLED});
        builder.m_61104_(new Property[]{POWERED});
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof LightswitchBlockEntity) {
            LightswitchBlockEntity light = (LightswitchBlockEntity)blockEntity;
            light.setCustomName(stack.m_41786_());
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LightswitchBlockEntity(pos, state);
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144282_);
    }
}

