/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.refurbished.core.ModTags;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DeskBlock
extends FurnitureHorizontalBlock
implements BlockTagSupplier {
    private final WoodType type;

    public DeskBlock(WoodType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public WoodType getWoodType() {
        return this.type;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape topShape = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape backLeftLegShape = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0);
        VoxelShape backRightLegShape = Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0);
        VoxelShape frontLeftLegShape = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)14.0, (double)2.0);
        VoxelShape frontRightLegShape = Block.m_49796_((double)1.0, (double)0.0, (double)14.0, (double)3.0, (double)14.0, (double)16.0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            boolean left = (Boolean)state.m_61143_((Property)LEFT);
            boolean right = (Boolean)state.m_61143_((Property)RIGHT);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(topShape);
            if (!left) {
                shapes.add(VoxelShapeHelper.rotateHorizontally(backRightLegShape, direction));
                shapes.add(VoxelShapeHelper.rotateHorizontally(frontRightLegShape, direction));
            }
            if (!right) {
                shapes.add(VoxelShapeHelper.rotateHorizontally(backLeftLegShape, direction));
                shapes.add(VoxelShapeHelper.rotateHorizontally(frontLeftLegShape, direction));
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combine(shapes));
        }
        return builder.build();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        Direction facing = (Direction)state.m_61143_((Property)DIRECTION);
        boolean left = this.isConnectable(level, pos, facing.m_122427_(), facing);
        boolean right = this.isConnectable(level, pos, facing.m_122428_(), facing);
        return (BlockState)((BlockState)state.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(left))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(right));
    }

    public boolean isConnectable(LevelAccessor level, BlockPos pos, Direction checkDirection, Direction tableDirection) {
        BlockState state = level.m_8055_(pos.m_121945_(checkDirection));
        return state.m_60734_() instanceof DeskBlock && state.m_61143_((Property)DIRECTION) == tableDirection;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LEFT});
        builder.m_61104_(new Property[]{RIGHT});
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144280_, ModTags.Blocks.TUCKABLE);
    }
}

