/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.forge;

import com.mojang.brigadier.CommandDispatcher;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.forge.NumismaticsClientImpl;
import dev.ithundxr.createnumismatics.multiloader.Env;
import dev.ithundxr.createnumismatics.registry.commands.arguments.EnumArgument;
import dev.ithundxr.createnumismatics.registry.forge.NumismaticsCreativeModeTabsImpl;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.Registries;
import net.minecraftforge.common.util.MavenVersionStringHelper;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.maven.artifact.versioning.ArtifactVersion;

@Mod(value="numismatics")
@Mod.EventBusSubscriber
public class NumismaticsImpl {
    static IEventBus eventBus;
    private static final Set<BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean>> commandConsumers;

    public NumismaticsImpl() {
        eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        NumismaticsCreativeModeTabsImpl.register(eventBus);
        Numismatics.init();
        Env.CLIENT.runIfCurrent(() -> () -> NumismaticsClientImpl.init());
        eventBus.addListener(NumismaticsImpl::registerArgumentTypes);
        eventBus.addListener(NumismaticsImpl::onCommonSetup);
    }

    private static void registerArgumentTypes(RegisterEvent event) {
        event.register(Registries.f_256982_, Numismatics.asResource("enum"), () -> ArgumentTypeInfos.registerByClass(EnumArgument.class, new EnumArgument.Info()));
    }

    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(Numismatics::postRegistrationInit);
    }

    public static String findVersion() {
        String versionString = "UNKNOWN";
        List infoList = ModList.get().getModFileById("numismatics").getMods();
        if (infoList.size() > 1) {
            Numismatics.LOGGER.error("Multiple mods for MOD_ID: numismatics");
        }
        for (IModInfo info : infoList) {
            if (!info.getModId().equals("numismatics")) continue;
            versionString = MavenVersionStringHelper.artifactVersionToString((ArtifactVersion)info.getVersion());
            break;
        }
        return versionString;
    }

    public static void finalizeRegistrate() {
        Numismatics.registrate().registerEventListeners(eventBus);
    }

    public static void registerCommands(BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean> consumer) {
        commandConsumers.add(consumer);
    }

    @SubscribeEvent
    public static void onCommandRegistration(RegisterCommandsEvent event) {
        Commands.CommandSelection selection = event.getCommandSelection();
        boolean dedicated = selection == Commands.CommandSelection.ALL || selection == Commands.CommandSelection.DEDICATED;
        commandConsumers.forEach(consumer -> consumer.accept(event.getDispatcher(), dedicated));
    }

    static {
        commandConsumers = new HashSet<BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean>>();
    }
}

