/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.coins;

import com.google.common.collect.ImmutableMap;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.coins.DiscreteCoinBag;
import dev.ithundxr.createnumismatics.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoinItem
extends Item {
    public final Coin coin;

    protected CoinItem(Item.Properties properties, Coin coin) {
        super(properties);
        this.coin = coin;
    }

    public static NonNullFunction<Item.Properties, CoinItem> create(Coin coin) {
        return properties -> new CoinItem((Item.Properties)properties, coin);
    }

    public static boolean extract(Player player, InteractionHand hand, Coin coin, boolean onlyHand) {
        return CoinItem.extract(player, hand, coin, false, onlyHand);
    }

    public static boolean extract(Player player, InteractionHand hand, Map<Coin, Integer> coins, boolean onlyHand) {
        return CoinItem.extract(player, hand, coins, false, onlyHand);
    }

    public static boolean extract(Player player, InteractionHand hand, Coin coin, boolean simulate, boolean onlyHand) {
        return CoinItem.extract(player, hand, (Map<Coin, Integer>)ImmutableMap.of((Object)((Object)coin), (Object)1), simulate, onlyHand);
    }

    public static boolean extract(Player player, InteractionHand hand, Map<Coin, Integer> coins, boolean simulate, boolean onlyHand) {
        if (!simulate && !CoinItem.extract(player, hand, coins, true, onlyHand)) {
            return false;
        }
        DiscreteCoinBag coinBag = DiscreteCoinBag.of(coins);
        ArrayList<ItemStack> inventoryList = new ArrayList<ItemStack>();
        if (onlyHand) {
            inventoryList.add(player.m_21120_(hand));
        } else {
            inventoryList.addAll((Collection<ItemStack>)player.m_150109_().f_35974_);
        }
        return CoinItem.extract(inventoryList, coinBag, simulate);
    }

    public static boolean extract(Container container, Map<Coin, Integer> coins, boolean simulate) {
        if (!simulate && !CoinItem.extract(container, coins, true)) {
            return false;
        }
        DiscreteCoinBag coinBag = DiscreteCoinBag.of(coins);
        ArrayList<ItemStack> inventoryList = new ArrayList<ItemStack>();
        for (int i = 0; i < container.m_6643_(); ++i) {
            inventoryList.add(container.m_8020_(i));
        }
        return CoinItem.extract(inventoryList, coinBag, simulate);
    }

    public static boolean extract(List<ItemStack> inventoryList, Map<Coin, Integer> coins, boolean simulate) {
        return CoinItem.extract(inventoryList, DiscreteCoinBag.of(coins), simulate);
    }

    private static boolean extract(List<ItemStack> inventoryList, DiscreteCoinBag coinBag, boolean simulate) {
        for (ItemStack stack : inventoryList) {
            if (coinBag.isEmpty()) {
                return true;
            }
            Item item = stack.m_41720_();
            if (!(item instanceof CoinItem)) continue;
            CoinItem coinItem = (CoinItem)item;
            Coin coin = coinItem.coin;
            int needed = coinBag.getDiscrete(coin);
            if (needed == 0) continue;
            int available = stack.m_41613_();
            int extracted = Math.min(needed, available);
            coinBag.subtract(coin, extracted);
            if (simulate) continue;
            stack.m_41764_(stack.m_41613_() - extracted);
        }
        return coinBag.isEmpty();
    }

    public static ItemStack setDisplayedCount(ItemStack stack, int amt) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("DisplayedCount", amt);
        stack.m_41751_(tag);
        return stack;
    }

    public static ItemStack clearDisplayedCount(ItemStack stack) {
        stack.m_41749_("DisplayedCount");
        return stack;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        int displayedCount;
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        Coin descriptor = this.coin.getDescription();
        if (descriptor == Coin.SPUR) {
            tooltipComponents.add((Component)Component.m_237110_((String)"item.numismatics.coin.tooltip.value.basic", (Object[])new Object[]{this.coin.value}));
        } else {
            int relativeValue = this.coin.value / descriptor.value;
            tooltipComponents.add((Component)Component.m_237110_((String)"item.numismatics.coin.tooltip.value", (Object[])new Object[]{relativeValue, descriptor.getName(relativeValue), this.coin.value}));
        }
        if (stack.m_41783_() != null && (displayedCount = stack.m_41783_().m_128451_("DisplayedCount")) > 0) {
            tooltipComponents.add((Component)Component.m_237110_((String)"item.numismatics.coin.tooltip.count", (Object[])new Object[]{TextUtils.formatInt(displayedCount), this.coin.getName(displayedCount)}).m_130940_(ChatFormatting.GOLD));
        }
    }
}

