/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.backend;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.gui.AllIcons;
import dev.ithundxr.createnumismatics.registry.NumismaticsIcons;
import dev.ithundxr.createnumismatics.registry.NumismaticsItems;
import dev.ithundxr.createnumismatics.util.TextUtils;
import java.util.List;
import java.util.Locale;
import net.createmod.catnip.data.Couple;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public enum Coin implements INamedIconOptions
{
    SPUR(1, Rarity.COMMON, NumismaticsIcons.I_COIN_SPUR, "\uf011"),
    BEVEL(8, Rarity.COMMON, NumismaticsIcons.I_COIN_BEVEL, "\uf012"),
    SPROCKET(16, Rarity.COMMON, NumismaticsIcons.I_COIN_SPROCKET, "\uf013"),
    COG(64, Rarity.UNCOMMON, NumismaticsIcons.I_COIN_COG, "\uf014"),
    CROWN(512, Rarity.RARE, NumismaticsIcons.I_COIN_CROWN, "\uf015"),
    SUN(4096, Rarity.EPIC, NumismaticsIcons.I_COIN_SUN, "\uf016");

    public final int value;
    public final Rarity rarity;
    public final NumismaticsIcons icon;
    public final String fontChar;

    private Coin(int value, Rarity rarity, NumismaticsIcons icon, String fontChar) {
        this.value = value;
        this.rarity = rarity;
        this.icon = icon;
        this.icon.setCoin();
        this.fontChar = fontChar;
    }

    public static List<Component> labeledComponents() {
        Object[] tmp = new Component[Coin.values().length];
        for (Coin coin : Coin.values()) {
            tmp[coin.ordinal()] = Component.m_237113_((String)(coin.fontChar + " " + Component.m_237115_((String)coin.getTranslationKey()).getString()));
        }
        return ImmutableList.copyOf((Object[])tmp);
    }

    public int toSpurs(int amount) {
        return amount * this.value;
    }

    public Couple<Integer> convert(int amount) {
        if (this == SPUR) {
            return Couple.create((Object)amount, (Object)0);
        }
        int remainder = amount % this.value;
        int converted = (amount - remainder) / this.value;
        return Couple.create((Object)converted, (Object)remainder);
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String getTranslatedName() {
        return Component.m_237115_((String)this.getTranslationKey()).getString().toLowerCase(Locale.ROOT);
    }

    public String getName(int amount) {
        return this.getTranslatedName() + (amount != 1 ? "s" : "");
    }

    public String getDisplayName() {
        return TextUtils.titleCaseConversion(this.getName());
    }

    public AllIcons getIcon() {
        return this.icon;
    }

    public String getTranslationKey() {
        return "item.numismatics." + this.getName();
    }

    public Coin getDescription() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SPUR, BEVEL, SPROCKET -> SPUR;
            case COG, CROWN, SUN -> COG;
        };
    }

    public ItemStack asStack() {
        return this.asStack(1);
    }

    public ItemStack asStack(int amount) {
        return NumismaticsItems.getCoin(this).asStack(amount);
    }

    public static Coin closest(int value) {
        Coin closest = SPUR;
        for (Coin coin : Coin.values()) {
            if (Math.abs(coin.value - value) > Math.abs(closest.value - value)) continue;
            closest = coin;
        }
        return closest;
    }
}

