/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.entity;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.satisfy.meadow.core.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;

public enum WoolySheepVar implements StringRepresentable
{
    FLECKED(0, "flecked_sheep", new float[]{1.0f, 1.0f, 1.0f}),
    PATCHED(1, "patched_sheep", new float[]{0.8f, 0.8f, 0.8f}),
    ROCKY(2, "rocky_sheep", new float[]{0.6f, 0.6f, 0.6f}),
    INKY(3, "inky_sheep", new float[]{0.2f, 0.2f, 0.2f}),
    FUZZY(4, "fuzzy_sheep", new float[]{0.9f, 0.7f, 0.5f}),
    LONG_NOSED(5, "long_nosed_sheep", new float[]{0.7f, 0.5f, 0.3f});

    public static final Codec<WoolySheepVar> CODEC;
    private static final IntFunction<WoolySheepVar> BY_ID;
    private final int id;
    private final String name;
    private final float[] textureDiffuseColors;
    private static final Map<WoolySheepVar, TagKey<Biome>> SPAWNS;

    private WoolySheepVar(int id, String name, float[] textureDiffuseColors) {
        this.id = id;
        this.name = name;
        this.textureDiffuseColors = textureDiffuseColors;
    }

    public int getId() {
        return this.id;
    }

    public static WoolySheepVar byId(int i) {
        return BY_ID.apply(i);
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    public static WoolySheepVar getRandomVariant(LevelAccessor levelAccessor, BlockPos blockPos, boolean spawnEgg) {
        Holder holder = levelAccessor.m_204166_(blockPos);
        RandomSource random = levelAccessor.m_213780_();
        List<WoolySheepVar> possibleVars = WoolySheepVar.getShearableSheepVariantsInBiome((Holder<Biome>)holder);
        int size = possibleVars.size();
        if (size == 0 || spawnEgg) {
            if (spawnEgg) {
                return (WoolySheepVar)((Object)Util.m_214670_((Object[])WoolySheepVar.values(), (RandomSource)random));
            }
            if (holder.m_203656_(TagRegistry.IS_MEADOW)) {
                return FLECKED;
            }
            ArrayList<WoolySheepVar> list = new ArrayList<WoolySheepVar>(List.of(WoolySheepVar.values()));
            return (WoolySheepVar)((Object)Util.m_214621_(list, (RandomSource)random));
        }
        return possibleVars.get(random.m_188503_(size));
    }

    private static List<WoolySheepVar> getShearableSheepVariantsInBiome(Holder<Biome> biome) {
        return SPAWNS.keySet().stream().filter(variant -> biome.m_203656_(SPAWNS.get(variant))).collect(Collectors.toList());
    }

    public float[] getTextureDiffuseColors() {
        return this.textureDiffuseColors;
    }

    static {
        CODEC = StringRepresentable.m_216439_(WoolySheepVar::values);
        BY_ID = ByIdMap.m_262839_(WoolySheepVar::getId, (Object[])WoolySheepVar.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        SPAWNS = (Map)Util.m_137469_(new HashMap(), map -> {
            map.put(FLECKED, TagRegistry.IS_MEADOW);
            map.put(PATCHED, BiomeTags.f_207611_);
            map.put(ROCKY, TagRegistry.SPAWNS_ROCKY_SHEEP);
            map.put(INKY, BiomeTags.f_215816_);
            map.put(FUZZY, BiomeTags.f_207611_);
            map.put(LONG_NOSED, BiomeTags.f_207606_);
        });
    }
}

