/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.block.FacingBlock;
import org.jetbrains.annotations.NotNull;

public class FoodBlock
extends FacingBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)3);
    private final MobEffectInstance effect;
    private final int nutrition;
    private final float saturationMod;

    public FoodBlock(BlockBehaviour.Properties settings, MobEffectInstance effect, int nutrition, float saturationMod) {
        super(settings);
        this.effect = effect;
        this.nutrition = nutrition;
        this.saturationMod = saturationMod;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BITES, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BITES});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (world.f_46443_) {
            if (this.tryEat((LevelAccessor)world, pos, state, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.tryEat((LevelAccessor)world, pos, state, player);
    }

    private InteractionResult tryEat(LevelAccessor world, BlockPos pos, BlockState state, Player player) {
        if (world instanceof Level) {
            Level level = (Level)world;
            for (int count = 0; count < 10; ++count) {
                double d0 = level.f_46441_.m_188583_() * 0.02;
                double d1 = level.f_46441_.m_188583_() * 0.02;
                double d2 = level.f_46441_.m_188583_() * 0.02;
                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, d0, d1, d2);
            }
        }
        world.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_36324_().m_38707_(this.nutrition, this.saturationMod);
        if (this.effect != null) {
            player.m_7292_(new MobEffectInstance(this.effect));
        }
        int i = (Integer)state.m_61143_((Property)BITES);
        world.m_142346_((Entity)player, GameEvent.f_157806_, pos);
        if (i < 3) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            if (world instanceof Level) {
                Level level = (Level)world;
                for (int count = 0; count < 30; ++count) {
                    double d0 = level.f_46441_.m_188583_() * 0.02;
                    double d1 = level.f_46441_.m_188583_() * 0.02;
                    double d2 = level.f_46441_.m_188583_() * 0.02;
                    level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, d0, d1, d2);
                }
            }
            world.m_7471_(pos, false);
            world.m_142346_((Entity)player, GameEvent.f_157794_, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        VoxelShape shape = world.m_8055_(pos.m_7495_()).m_60808_((BlockGetter)world, pos.m_7495_());
        Direction direction = Direction.UP;
        return Block.m_49918_((VoxelShape)shape, (Direction)direction);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }
}

