/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.block.FacingBlock;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class FireLog
extends FacingBlock {
    public static final IntegerProperty STAGE = IntegerProperty.m_61631_((String)"stage", (int)0, (int)3);
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        VoxelShape baseShape = FireLog.makeDefaultShape();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, baseShape));
        }
    });

    public FireLog(BlockBehaviour.Properties setting) {
        super(setting);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        int stage = (Integer)state.m_61143_((Property)STAGE);
        VoxelShape shape = switch (stage) {
            case 1 -> this.makeSmallShape();
            case 2 -> this.makeMidShape();
            case 3 -> this.makeBigShape();
            default -> this.makeAxeShape();
        };
        return GeneralUtil.rotateShape(Direction.NORTH, facing, shape);
    }

    private static VoxelShape makeDefaultShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        int stage = (Integer)state.m_61143_((Property)STAGE);
        if (player.m_6144_() && stack.m_41619_() && stage > 1) {
            player.m_36356_(new ItemStack((ItemLike)ObjectRegistry.FIRE_LOG.get()));
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(--stage)));
            world.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_(this.m_5456_()) && stage < 3) {
            ++stage;
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage)));
            world.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (stage == 0) {
            world.m_7471_(pos, true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{STAGE});
    }

    private VoxelShape makeAxeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.078125, (double)0.0, (double)0.125, (double)0.328125, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.546875, (double)0.0, (double)0.0625, (double)0.796875, (double)0.25, (double)0.4375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.546875, (double)0.0, (double)0.5625, (double)0.796875, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private VoxelShape makeSmallShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0, (double)0.1875, (double)0.625, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.0, (double)0.125, (double)0.875, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.5625, (double)0.25, (double)0.0625, (double)0.8125, (double)0.5, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.25, (double)0.125, (double)0.5625, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.5, (double)0.1875, (double)0.6875, (double)0.75, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.375, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private VoxelShape makeMidShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.1875, (double)0.5, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.5, (double)0.0, (double)0.0625, (double)0.75, (double)0.25, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.0, (double)0.125, (double)1.0, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.125, (double)0.25, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.25, (double)0.1875, (double)0.625, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.25, (double)0.125, (double)0.875, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.5625, (double)0.5, (double)0.0625, (double)0.8125, (double)0.75, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.5, (double)0.125, (double)0.5625, (double)0.75, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.75, (double)0.1875, (double)0.6875, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.25, (double)0.125, (double)0.375, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private VoxelShape makeBigShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.1875, (double)0.5, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.5, (double)0.0, (double)0.0625, (double)0.75, (double)0.25, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.0, (double)0.125, (double)1.0, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.125, (double)0.25, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.5, (double)0.25, (double)0.1875, (double)0.75, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.25, (double)0.125, (double)1.0, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.5, (double)0.0625, (double)1.0, (double)0.75, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.5, (double)0.5, (double)0.125, (double)0.75, (double)0.75, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.75, (double)0.125, (double)1.0, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.25, (double)0.125, (double)0.5, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.1875, (double)0.25, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.5, (double)0.125, (double)0.25, (double)0.75, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.5, (double)0.1875, (double)0.5, (double)0.75, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.1875, (double)0.25, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.5, (double)0.75, (double)0.0625, (double)0.75, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.75, (double)0.1875, (double)0.5, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }
}

