/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.buzzier_bees.core;

import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.buzzier_bees.client.model.GrizzlyBearModel;
import com.teamabnormals.buzzier_bees.client.render.entity.GrizzlyBearRenderer;
import com.teamabnormals.buzzier_bees.client.render.entity.MoobloomRenderer;
import com.teamabnormals.buzzier_bees.core.BBConfig;
import com.teamabnormals.buzzier_bees.core.data.server.BBAdvancementProvider;
import com.teamabnormals.buzzier_bees.core.data.server.BBDatapackBuiltinEntriesProvider;
import com.teamabnormals.buzzier_bees.core.data.server.modifiers.BBAdvancementModifierProvider;
import com.teamabnormals.buzzier_bees.core.data.server.modifiers.BBLootModifierProvider;
import com.teamabnormals.buzzier_bees.core.data.server.tags.BBBannerPatternTagsProvider;
import com.teamabnormals.buzzier_bees.core.data.server.tags.BBBiomeTagsProvider;
import com.teamabnormals.buzzier_bees.core.data.server.tags.BBBlockTagsProvider;
import com.teamabnormals.buzzier_bees.core.data.server.tags.BBEntityTypeTagsProvider;
import com.teamabnormals.buzzier_bees.core.data.server.tags.BBItemTagsProvider;
import com.teamabnormals.buzzier_bees.core.data.server.tags.BBPaintingVariantTagsProvider;
import com.teamabnormals.buzzier_bees.core.other.BBClientCompat;
import com.teamabnormals.buzzier_bees.core.other.BBCompat;
import com.teamabnormals.buzzier_bees.core.other.BBModelLayers;
import com.teamabnormals.buzzier_bees.core.registry.BBBannerPatterns;
import com.teamabnormals.buzzier_bees.core.registry.BBBlocks;
import com.teamabnormals.buzzier_bees.core.registry.BBEntityTypes;
import com.teamabnormals.buzzier_bees.core.registry.BBItems;
import com.teamabnormals.buzzier_bees.core.registry.BBMobEffects;
import com.teamabnormals.buzzier_bees.core.registry.BBPaintingVariants;
import com.teamabnormals.buzzier_bees.core.registry.BBParticleTypes;
import com.teamabnormals.gallery.core.data.client.GalleryAssetsRemolderProvider;
import com.teamabnormals.gallery.core.data.client.GalleryItemModelProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.model.CowModel;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="buzzier_bees")
public class BuzzierBees {
    public static final String MOD_ID = "buzzier_bees";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("buzzier_bees");

    public BuzzierBees() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        BBPaintingVariants.PAINTING_VARIANTS.register(bus);
        BBParticleTypes.PARTICLE_TYPES.register(bus);
        BBMobEffects.POTIONS.register(bus);
        BBMobEffects.MOB_EFFECTS.register(bus);
        BBBannerPatterns.BANNER_PATTERNS.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            BBBlocks.setupTabEditors();
            BBItems.setupTabEditors();
            bus.addListener(this::registerLayerDefinitions);
            bus.addListener(this::registerRenderers);
        });
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BBConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BBCompat.registerCompat();
            BBMobEffects.registerRecipes();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(BBClientCompat::registerClientCompat);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        BBBlockTagsProvider blockTags = new BBBlockTagsProvider(output, provider, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new BBItemTagsProvider(output, provider, blockTags.m_274426_(), helper));
        generator.addProvider(server, (DataProvider)new BBEntityTypeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new BBBiomeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new BBBannerPatternTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new BBPaintingVariantTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)BBAdvancementProvider.create(output, provider, helper));
        generator.addProvider(server, (DataProvider)new BBLootModifierProvider(output, provider));
        generator.addProvider(server, (DataProvider)new BBAdvancementModifierProvider(output, provider));
        generator.addProvider(server, (DataProvider)new BBDatapackBuiltinEntriesProvider(output, provider));
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new GalleryItemModelProvider(MOD_ID, output, helper));
        generator.addProvider(client, (DataProvider)new GalleryAssetsRemolderProvider(MOD_ID, output, provider));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BBModelLayers.GRIZZLY_BEAR, GrizzlyBearModel::createBodyLayer);
        event.registerLayerDefinition(BBModelLayers.MOOBLOOM, CowModel::m_170516_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)BBEntityTypes.MOOBLOOM.get(), MoobloomRenderer::new);
        event.registerEntityRenderer((EntityType)BBEntityTypes.GRIZZLY_BEAR.get(), GrizzlyBearRenderer::new);
    }
}

