/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.box.BoxesVoxelShape;

public class ABBs
implements Iterable<ABB> {
    private List<ABB> boxes = new ArrayList<ABB>();

    public static void cutOut(List<ABB> result, ABB bb, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!bb.intersects(minX, minY, minZ, maxX, maxY, maxZ)) {
            return;
        }
        block15: for (int x = 0; x < 3; ++x) {
            double startX;
            double endX = switch (x) {
                case 0 -> {
                    if (bb.minX >= minX) continue block15;
                    startX = bb.minX;
                    yield minX;
                }
                case 1 -> {
                    startX = Math.max(bb.minX, minX);
                    yield Math.min(bb.maxX, maxX);
                }
                case 2 -> {
                    if (bb.maxX < maxX) continue block15;
                    startX = maxX;
                    yield bb.maxX;
                }
                default -> throw new UnsupportedOperationException();
            };
            block16: for (int y = 0; y < 3; ++y) {
                double startY;
                double endY = switch (y) {
                    case 0 -> {
                        if (bb.minY >= minY) continue block16;
                        startY = bb.minY;
                        yield minY;
                    }
                    case 1 -> {
                        startY = Math.max(bb.minY, minY);
                        yield Math.min(bb.maxY, maxY);
                    }
                    case 2 -> {
                        if (bb.maxY < maxY) continue block16;
                        startY = maxY;
                        yield bb.maxY;
                    }
                    default -> throw new UnsupportedOperationException();
                };
                block17: for (int z = 0; z < 3; ++z) {
                    double startZ;
                    double endZ = switch (z) {
                        case 0 -> {
                            if (bb.minZ >= minZ) continue block17;
                            startZ = bb.minZ;
                            yield minZ;
                        }
                        case 1 -> {
                            startZ = Math.max(bb.minZ, minZ);
                            yield Math.min(bb.maxZ, maxZ);
                        }
                        case 2 -> {
                            if (bb.maxZ < maxZ) continue block17;
                            startZ = maxZ;
                            yield bb.maxZ;
                        }
                        default -> throw new UnsupportedOperationException();
                    };
                    if (x == 1 && y == 1 && z == 1) continue;
                    result.add(new ABB(startX, startY, startZ, endX, endY, endZ));
                }
            }
        }
    }

    public ABBs(VoxelShape shape) {
        this.addShape(shape);
    }

    public ABBs(AABB bb) {
        this.boxes.add(new ABB(bb));
    }

    public ABBs(ABB bb) {
        this.boxes.add(bb.copy());
    }

    public void addShape(VoxelShape shape) {
        if (shape instanceof BoxesVoxelShape) {
            BoxesVoxelShape bs = (BoxesVoxelShape)shape;
            for (ABB bb : bs.boxes) {
                this.boxes.add(new ABB(bb));
            }
        } else {
            for (AABB bb : shape.m_83299_()) {
                this.boxes.add(new ABB(bb));
            }
        }
    }

    public void cutOutVanilla(Iterable<AABB> bbs) {
        for (AABB bb : bbs) {
            this.cutOut(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_);
        }
    }

    public void cutOut(Iterable<ABB> bbs) {
        for (ABB bb : bbs) {
            this.cutOut(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
        }
    }

    public void cutOut(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        ArrayList<ABB> newBoxes = new ArrayList<ABB>(this.boxes);
        for (ABB bb : this.boxes) {
            ABBs.cutOut(newBoxes, bb, minX, minY, minZ, maxX, maxY, maxZ);
        }
        this.boxes = newBoxes;
        this.optimize();
    }

    public void intersectionVanilla(Iterable<AABB> bbs) {
        for (AABB bb : bbs) {
            this.cutOut(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_);
        }
    }

    public void intersection(Iterable<ABB> bbs) {
        List<ABB> oldBoxes = this.boxes;
        this.boxes = new ArrayList<ABB>();
        for (ABB bb : oldBoxes) {
            for (ABB bb2 : bbs) {
                if (!bb.intersects(bb2)) continue;
                this.addNonOverlapping(new ABB(Math.max(bb.minX, bb2.minX), Math.max(bb.minY, bb2.minY), Math.max(bb.minZ, bb2.minZ), Math.min(bb.maxX, bb2.maxX), Math.min(bb.maxY, bb2.maxY), Math.min(bb.maxZ, bb2.maxZ)));
            }
        }
    }

    public boolean isEmpty() {
        return this.boxes.isEmpty();
    }

    public List<ABB> getBoxes() {
        return this.boxes;
    }

    public void addNonOverlappingVanilla(Iterable<AABB> bbs) {
        for (AABB bb : bbs) {
            this.addNonOverlapping(new ABB(bb));
        }
    }

    public void addNonOverlapping(Iterable<ABB> bbs) {
        for (ABB bb : bbs) {
            this.addNonOverlapping(bb);
        }
    }

    public void addNonOverlapping(ABB bb) {
        ArrayList<ABB> toAdd = new ArrayList<ABB>();
        toAdd.add(bb);
        ArrayList<ABB> newlyCut = new ArrayList<ABB>();
        for (ABB cutter : this.boxes) {
            newlyCut.clear();
            for (ABB cutted : toAdd) {
                ABBs.cutOut(newlyCut, cutted, cutter.minX, cutter.minY, cutter.minZ, cutter.maxX, cutter.maxY, cutter.maxZ);
            }
            ArrayList<ABB> temp = newlyCut;
            newlyCut = toAdd;
            toAdd = temp;
        }
        this.boxes.addAll(toAdd);
    }

    public void optimize() {
        boolean modified = true;
        while (modified) {
            modified = false;
            for (int i = 0; i < this.boxes.size(); ++i) {
                int j = 0;
                while (j < this.boxes.size()) {
                    ABB box;
                    if (i != j && (box = this.boxes.get(i).combine(this.boxes.get(j))) != null) {
                        this.boxes.set(i, box);
                        this.boxes.remove(j);
                        modified = true;
                        if (i <= j) continue;
                        --i;
                        continue;
                    }
                    ++j;
                }
            }
        }
    }

    @Override
    public Iterator<ABB> iterator() {
        return this.boxes.iterator();
    }
}

