/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarycreatures.registry.BlockRegistry;

public class DoomFireBlock
extends BaseFireBlock {
    public static final int MAX_AGE = 15;
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;

    public DoomFireBlock(BlockBehaviour.Properties properties) {
        super(properties, 2.0f);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void m_213897_(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource rand) {
        level.m_186460_(pos, (Block)this, DoomFireBlock.getFireTickDelay(level.f_46441_));
        if (level.m_46469_().m_46207_(GameRules.f_46131_)) {
            int j;
            int i;
            if (!blockState.m_60710_((LevelReader)level, pos)) {
                level.m_7471_(pos, false);
            }
            if ((i = ((Integer)blockState.m_61143_((Property)AGE)).intValue()) != (j = Math.min(15, i + rand.m_188503_(3) / 2))) {
                blockState = (BlockState)blockState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(j));
                level.m_7731_(pos, blockState, 4);
            }
            if (i == 15 && rand.m_188503_(4) == 0) {
                level.m_7471_(pos, false);
            }
        }
    }

    private static int getFireTickDelay(RandomSource rand) {
        return 30 + rand.m_188503_(10);
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos pos, BlockState newBlockState, boolean p_49283_) {
        super.m_6807_(blockState, level, pos, newBlockState, p_49283_);
        level.m_186460_(pos, (Block)this, DoomFireBlock.getFireTickDelay(level.f_46441_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public boolean m_7898_(@NotNull BlockState blockState, @NotNull LevelReader level, @NotNull BlockPos blockPos) {
        return DoomFireBlock.checkDoomFireSurvive(level.m_8055_(blockPos.m_7495_()), level, blockPos.m_7495_());
    }

    public static boolean checkDoomFireSurvive(BlockState blockState, LevelReader world, BlockPos blockPos) {
        return DoomFireBlock.canSurviveOnBlock(blockState) && blockState.m_60783_((BlockGetter)world, blockPos.m_7495_(), Direction.UP);
    }

    public static boolean canSurviveOnBlock(BlockState blockState) {
        return !blockState.m_60713_(Blocks.f_50016_) && !blockState.m_60713_(Blocks.f_50083_) && !blockState.m_60713_(Blocks.f_50084_) && !blockState.m_60713_((Block)BlockRegistry.DOOM_FIRE_BLOCK.get()) && !blockState.m_60713_(Blocks.f_49990_);
    }

    protected boolean m_7599_(BlockState blockState) {
        return true;
    }
}

