/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.emberstextapi.immersivemessages.util;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

public final class RenderUtil {
    private RenderUtil() {
    }

    public static void fillGradient(GuiGraphics graphics, int x1, int y1, int x2, int y2, int top, int bottom) {
        graphics.m_280024_(x1, y1, x2, y2, top, bottom);
    }

    public static void drawBackground(GuiGraphics graphics, int x, int y, int width, int height, int background, int borderStart, int borderEnd) {
        int xMaxL = x - 3;
        int xMinL = x - 4;
        int xMinR = x + width + 3;
        int xMaxR = x + width + 4;
        int yMaxT = y - 4;
        int yMinT = y - 5;
        int yMaxB = y + height + 4;
        int yMinB = y + height + 3;
        graphics.m_280024_(xMaxL, yMinT, xMinR, yMaxT, background, background);
        graphics.m_280024_(xMaxL, yMinB, xMinR, yMaxB, background, background);
        graphics.m_280024_(xMaxL, yMaxT, xMinR, yMinB, background, background);
        graphics.m_280024_(xMinL, yMaxT, xMaxL, yMinB, background, background);
        graphics.m_280024_(xMinR, yMaxT, xMaxR, yMinB, background, background);
        int topWidth = xMinR - xMaxL;
        for (int i = 0; i < topWidth; ++i) {
            float t = topWidth <= 1 ? 0.0f : (float)i / (float)(topWidth - 1);
            int col = RenderUtil.lerpColour(borderStart, borderEnd, t);
            graphics.m_280509_(xMaxL + i, yMaxT, xMaxL + i + 1, yMaxT + 1, col);
            graphics.m_280509_(xMinR - 1 - i, yMinB - 1, xMinR - i, yMinB, col);
        }
        int sideHeight = yMinB - yMaxT - 2;
        for (int i = 0; i < sideHeight; ++i) {
            float t = sideHeight <= 1 ? 0.0f : (float)i / (float)(sideHeight - 1);
            int rightCol = RenderUtil.lerpColour(borderEnd, borderStart, t);
            graphics.m_280509_(xMinR - 1, yMaxT + 1 + i, xMinR, yMaxT + 2 + i, rightCol);
            int leftCol = RenderUtil.lerpColour(borderStart, borderEnd, t);
            graphics.m_280509_(xMaxL, yMaxT + 1 + i, xMaxL + 1, yMaxT + 2 + i, leftCol);
        }
    }

    private static int lerpColour(int a, int b, float t) {
        int ar = a >> 16 & 0xFF;
        int ag = a >> 8 & 0xFF;
        int ab = a & 0xFF;
        int aa = a >> 24 & 0xFF;
        int br = b >> 16 & 0xFF;
        int bg = b >> 8 & 0xFF;
        int bb = b & 0xFF;
        int ba = b >> 24 & 0xFF;
        int r = (int)((float)ar + (float)(br - ar) * t);
        int g = (int)((float)ag + (float)(bg - ag) * t);
        int bl = (int)((float)ab + (float)(bb - ab) * t);
        int aOut = (int)((float)aa + (float)(ba - aa) * t);
        return (aOut & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | bl & 0xFF;
    }

    public static void drawBackgroundGradient(GuiGraphics graphics, int x, int y, int width, int height, int[] gradient, int borderTop, int borderBottom) {
        int xMaxL = x - 3;
        int xMinL = x - 4;
        int xMinR = x + width + 3;
        int xMaxR = x + width + 4;
        int yMaxT = y - 4;
        int yMinT = y - 5;
        int yMaxB = y + height + 4;
        int yMinB = y + height + 3;
        int darkerTop = RenderUtil.lerpColour(-16777216, borderTop, 0.5f);
        int darkerBottom = RenderUtil.lerpColour(-16777216, borderBottom, 0.5f);
        RenderUtil.fillHorizontalGradient(graphics, xMaxL, yMinT, xMinR, yMaxT, gradient);
        RenderUtil.fillHorizontalGradient(graphics, xMaxL, yMinB, xMinR, yMaxB, gradient);
        RenderUtil.fillHorizontalGradient(graphics, xMaxL, yMaxT, xMinR, yMinB, gradient);
        RenderUtil.fillHorizontalGradient(graphics, xMinL, yMaxT, xMaxL, yMinB, gradient);
        RenderUtil.fillHorizontalGradient(graphics, xMinR, yMaxT, xMaxR, yMinB, gradient);
        int topWidth = xMinR - xMaxL;
        for (int i = 0; i < topWidth; ++i) {
            float t = topWidth <= 1 ? 0.0f : (float)i / (float)(topWidth - 1);
            int col = RenderUtil.lerpColour(borderTop, borderBottom, t);
            graphics.m_280509_(xMaxL + i, yMaxT, xMaxL + i + 1, yMaxT + 1, col);
            graphics.m_280509_(xMinR - 1 - i, yMinB - 1, xMinR - i, yMinB, col);
        }
        int sideHeight = yMinB - yMaxT - 2;
        for (int i = 0; i < sideHeight; ++i) {
            float t = sideHeight <= 1 ? 0.0f : (float)i / (float)(sideHeight - 1);
            int rightCol = RenderUtil.lerpColour(borderBottom, borderTop, t);
            graphics.m_280509_(xMinR - 1, yMaxT + 1 + i, xMinR, yMaxT + 2 + i, rightCol);
            int leftCol = RenderUtil.lerpColour(borderTop, borderBottom, t);
            graphics.m_280509_(xMaxL, yMaxT + 1 + i, xMaxL + 1, yMaxT + 2 + i, leftCol);
        }
        int outerTopWidth = xMaxR - xMinL;
        for (int i = 0; i < outerTopWidth; ++i) {
            float tInner = topWidth <= 1 ? 0.0f : (float)Mth.m_14045_((int)(i - 1), (int)0, (int)(topWidth - 1)) / (float)(topWidth - 1);
            int innerCol = RenderUtil.lerpColour(borderTop, borderBottom, tInner);
            int col = RenderUtil.lerpColour(-16777216, innerCol, 0.5f);
            graphics.m_280509_(xMinL + i, yMinT, xMinL + i + 1, yMinT + 1, col);
            graphics.m_280509_(xMaxR - 1 - i, yMaxB - 1, xMaxR - i, yMaxB, col);
        }
        int outerSideHeight = yMaxB - yMinT - 2;
        for (int i = 0; i < outerSideHeight; ++i) {
            float tInner = sideHeight <= 1 ? 0.0f : (float)Mth.m_14045_((int)(i - 1), (int)0, (int)(sideHeight - 1)) / (float)(sideHeight - 1);
            int rightInner = RenderUtil.lerpColour(borderBottom, borderTop, tInner);
            int rightCol = RenderUtil.lerpColour(-16777216, rightInner, 0.5f);
            graphics.m_280509_(xMaxR - 1, yMinT + 1 + i, xMaxR, yMinT + 2 + i, rightCol);
            int leftInner = RenderUtil.lerpColour(borderTop, borderBottom, tInner);
            int leftCol = RenderUtil.lerpColour(-16777216, leftInner, 0.5f);
            graphics.m_280509_(xMinL, yMinT + 1 + i, xMinL + 1, yMinT + 2 + i, leftCol);
        }
    }

    private static void fillHorizontalGradient(GuiGraphics graphics, int x1, int y1, int x2, int y2, int[] gradient) {
        int w = x2 - x1;
        for (int i = 0; i < w; ++i) {
            float t = w <= 1 ? 0.0f : (float)i / (float)(w - 1);
            int color = RenderUtil.sampleGradient(gradient, t);
            graphics.m_280509_(x1 + i, y1, x1 + i + 1, y2, color);
        }
    }

    private static int sampleGradient(int[] gradient, float t) {
        int segments = gradient.length - 1;
        float scaled = t * (float)segments;
        int idx = Mth.m_14045_((int)((int)Math.floor(scaled)), (int)0, (int)(segments - 1));
        float local = scaled - (float)idx;
        return RenderUtil.lerpArgb(gradient[idx], gradient[idx + 1], local);
    }

    private static int lerpArgb(int start, int end, float t) {
        int sa = start >> 24 & 0xFF;
        int sr = start >> 16 & 0xFF;
        int sg = start >> 8 & 0xFF;
        int sb = start & 0xFF;
        int ea = end >> 24 & 0xFF;
        int er = end >> 16 & 0xFF;
        int eg = end >> 8 & 0xFF;
        int eb = end & 0xFF;
        int a = (int)Mth.m_14179_((float)t, (float)sa, (float)ea);
        int r = (int)Mth.m_14179_((float)t, (float)sr, (float)er);
        int g = (int)Mth.m_14179_((float)t, (float)sg, (float)eg);
        int b = (int)Mth.m_14179_((float)t, (float)sb, (float)eb);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

