/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.save_global_blueprint;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.nio.file.Files;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.init.ModGameRules;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.save_global_blueprint.StoC_SaveGlobalBlueprint;
import nimble.portable_blueprints.robautile.Operazioni;

public class CtoS_SaveGlobalBlueprint {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final String nome;

    public CtoS_SaveGlobalBlueprint() {
        this.nome = "";
    }

    public CtoS_SaveGlobalBlueprint(String nome) {
        this.nome = nome;
    }

    public CtoS_SaveGlobalBlueprint(FriendlyByteBuf buffer) {
        this.nome = buffer.m_130277_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.nome);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = player.m_284548_();
            if (level.m_46469_().m_46207_(ModGameRules.AllowGlobalBlueprints)) {
                String nomeBlueprint = this.nome.contains(";") ? this.nome.split(";")[0] : this.nome;
                String nomeDiRename = this.nome.contains(";") ? this.nome.split(";")[1] : this.nome;
                File blueprintFile = null;
                for (File f : Blueprint.getFileForBlueprints(level, player.m_20148_()).listFiles()) {
                    if (!f.getName().equals(nomeBlueprint + ".bp")) continue;
                    blueprintFile = f;
                    break;
                }
                if (blueprintFile != null) {
                    File finalBlueprintFile = blueprintFile;
                    new Thread(() -> {
                        try {
                            String bd_string_datas = new String(Files.readAllBytes(finalBlueprintFile.toPath()));
                            String id_richiesta = UUID.randomUUID().toString();
                            PacketHandler.sendToPlayer(new StoC_SaveGlobalBlueprint("[INIZIO DATI BLUEPRINT <id>" + id_richiesta + "</id><nome>" + nomeDiRename + "</nome>"), player);
                            PacketHandler.sendToPlayer(new StoC_SaveGlobalBlueprint("[NOME DEL FILE:" + nomeDiRename), player);
                            for (String val : Operazioni.splitStringByLength(bd_string_datas, 10000)) {
                                PacketHandler.sendToPlayer(new StoC_SaveGlobalBlueprint("[" + id_richiesta + "]" + val), player);
                                Thread.sleep(10L);
                            }
                            PacketHandler.sendToPlayer(new StoC_SaveGlobalBlueprint("[FINE DATI BLUEPRINT DI ID: " + id_richiesta + "]"), player);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }).start();
                }
            }
        });
        return true;
    }
}

