/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.init.ModItems;

@Mod.EventBusSubscriber(modid="portable_blueprints", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BlueprintServerCommand {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"blueprintserver").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"free").executes(ctx -> {
            BlueprintServerCommand.setServerBlueprint(((CommandSourceStack)ctx.getSource()).m_81372_(), true, ((CommandSourceStack)ctx.getSource()).m_230896_());
            return 1;
        }))).then(Commands.m_82127_((String)"permission").executes(ctx -> {
            BlueprintServerCommand.setServerBlueprint(((CommandSourceStack)ctx.getSource()).m_81372_(), false, ((CommandSourceStack)ctx.getSource()).m_230896_());
            return 1;
        })))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"param", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            for (String perm : BlueprintServerCommand.blueprintEsistenti(((CommandSourceStack)ctx.getSource()).m_81372_())) {
                builder.suggest(perm);
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            String param = StringArgumentType.getString((CommandContext)ctx, (String)"param");
            BlueprintServerCommand.removeServerBlueprint(((CommandSourceStack)ctx.getSource()).m_81372_(), ((CommandSourceStack)ctx.getSource()).m_230896_(), param);
            return 1;
        })))).then(Commands.m_82127_((String)"permission").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"blueprint", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            for (String perm : BlueprintServerCommand.blueprintEsistenti(((CommandSourceStack)ctx.getSource()).m_81372_())) {
                builder.suggest(perm);
            }
            return builder.buildFuture();
        }).then(Commands.m_82129_((String)"allowed", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            String permission = StringArgumentType.getString((CommandContext)ctx, (String)"blueprint");
            boolean allowed = BoolArgumentType.getBool((CommandContext)ctx, (String)"allowed");
            BlueprintServerCommand.setPlayerPermissionForServerBlueprint(((CommandSourceStack)ctx.getSource()).m_81372_(), ((CommandSourceStack)ctx.getSource()).m_230896_(), player, permission, allowed);
            return 1;
        }))))));
    }

    private static void setServerBlueprint(ServerLevel level, boolean isFree, ServerPlayer player) {
        if (player == null) {
            return;
        }
        if (player.m_21205_().m_41720_().equals(ModItems.BLUEPRINT.get())) {
            CompoundTag nbt = player.m_21205_().m_41784_();
            if (nbt.m_128441_("owner") && nbt.m_128441_("nome")) {
                if (nbt.m_128461_("nome").contains("[Global]")) {
                    if (player != null) {
                        player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.blueprintserver.set_global_error").m_130940_(ChatFormatting.RED), false);
                    }
                    return;
                }
                boolean successo = BlueprintServerCommand.addServerBlueprint(level, nbt.m_128461_("nome"), nbt.m_128461_("owner"));
                if (!successo) {
                    if (player != null) {
                        player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.blueprintserver.not_found").m_130940_(ChatFormatting.RED), false);
                    }
                    return;
                }
                BlueprintServerCommand.addBlueprintPermission(level, nbt.m_128461_("nome"), isFree);
                if (player != null) {
                    player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.blueprintserver.set_success").m_130940_(ChatFormatting.GREEN), false);
                }
            } else if (player != null) {
                player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.blueprintserver.not_valid_item").m_130940_(ChatFormatting.RED), false);
            }
        } else if (player != null) {
            player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.blueprintserver.no_item").m_130940_(ChatFormatting.RED), false);
        }
    }

    private static boolean addServerBlueprint(ServerLevel level, String nome, String owner) {
        File folderServerBlueprints = new File(Blueprint.getServerBlueprintFile(level), nome + ".bp");
        File original = null;
        for (File file : Blueprint.getFileForBlueprints(level, UUID.fromString(owner)).listFiles()) {
            if (!file.getName().equals(nome + ".bp")) continue;
            original = file;
            break;
        }
        if (original != null) {
            try {
                Files.copy(original.toPath(), folderServerBlueprints.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static void addBlueprintPermission(ServerLevel level, String nome, boolean isfree) {
        try {
            File permissionFile = Blueprint.getServerPremissionFile(level);
            Blueprint.BlueprintPermission bp = (Blueprint.BlueprintPermission)GSON.fromJson((Reader)new FileReader(permissionFile), Blueprint.BlueprintPermission.class);
            bp.addServerBlueprintPermission(nome, isfree);
            try (FileWriter writer = new FileWriter(permissionFile);){
                GSON.toJson((Object)bp, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void removeServerBlueprint(ServerLevel level, ServerPlayer player, String nome) {
        File blueprintFile = null;
        for (File file : Blueprint.getServerBlueprintFile(level).listFiles()) {
            if (!file.getName().equals(nome + ".bp")) continue;
            blueprintFile = file;
            break;
        }
        if (blueprintFile != null) {
            if (blueprintFile.delete()) {
                try {
                    File permissionFile = Blueprint.getServerPremissionFile(level);
                    Blueprint.BlueprintPermission bp = (Blueprint.BlueprintPermission)GSON.fromJson((Reader)new FileReader(permissionFile), Blueprint.BlueprintPermission.class);
                    bp.removeServerBlueprintPermission(nome);
                    try (FileWriter writer = new FileWriter(permissionFile);){
                        GSON.toJson((Object)bp, (Appendable)writer);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (player != null) {
                    player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.blueprintserver.delete_success").m_130940_(ChatFormatting.GREEN), false);
                }
            } else if (player != null) {
                player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.blueprintserver.delete_error").m_130940_(ChatFormatting.RED), false);
            }
        } else if (player != null) {
            player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.blueprintserver.not_found").m_130940_(ChatFormatting.RED), false);
        }
    }

    private static List<String> blueprintEsistenti(ServerLevel level) {
        ArrayList<String> nomi = new ArrayList<String>();
        for (File file : Blueprint.getServerBlueprintFile(level).listFiles()) {
            nomi.add(file.getName().replace(".bp", ""));
        }
        return nomi;
    }

    private static void setPlayerPermissionForServerBlueprint(ServerLevel level, ServerPlayer player, ServerPlayer target, String nome, boolean hasPermission) {
        block11: {
            try {
                File permissionFile = Blueprint.getServerPremissionFile(level);
                Blueprint.BlueprintPermission bp = (Blueprint.BlueprintPermission)GSON.fromJson((Reader)new FileReader(permissionFile), Blueprint.BlueprintPermission.class);
                bp.setPermissionForPlayer(target, nome, hasPermission);
                try (FileWriter writer = new FileWriter(permissionFile);){
                    GSON.toJson((Object)bp, (Appendable)writer);
                    if (player != null) {
                        player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.blueprintserver.set_player_permission_success").m_130940_(ChatFormatting.GREEN), false);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (player != null) {
                        player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.blueprintserver.set_player_permission_error").m_130940_(ChatFormatting.RED), false);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (player == null) break block11;
                player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.blueprintserver.set_player_permission_error").m_130940_(ChatFormatting.RED), false);
            }
        }
    }
}

