/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.compat.configured;

import com.anthonyhilyard.iceberg.config.IcebergConfigSpec;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.ValueEntry;
import com.mrcrayfish.configured.impl.forge.ForgeEnumValue;
import com.mrcrayfish.configured.impl.forge.ForgeListValue;
import com.mrcrayfish.configured.impl.forge.ForgeValue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;

public class IcebergFolderEntry
implements IConfigEntry {
    protected final List<String> path;
    protected final UnmodifiableConfig config;
    protected final IcebergConfigSpec spec;
    private final String customComment;
    protected List<IConfigEntry> entries;

    public IcebergFolderEntry(UnmodifiableConfig config, IcebergConfigSpec spec) {
        this(new ArrayList<String>(), config, spec);
    }

    public IcebergFolderEntry(List<String> path, UnmodifiableConfig config, IcebergConfigSpec spec) {
        this(path, config, spec, null);
    }

    public IcebergFolderEntry(List<String> path, UnmodifiableConfig config, IcebergConfigSpec spec, String customComment) {
        this.path = path;
        this.config = config;
        this.spec = spec;
        this.customComment = customComment;
    }

    public List<IConfigEntry> getChildren() {
        if (this.entries == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.config.valueMap().forEach((key, value) -> {
                ForgeConfigSpec.ConfigValue configValue;
                ForgeConfigSpec.ValueSpec valueSpec;
                ForgeConfigSpec.ValueSpec valueSpec2;
                if (value instanceof ForgeConfigSpec.ValueSpec && (valueSpec2 = (ForgeConfigSpec.ValueSpec)value).getDefault() instanceof UnmodifiableConfig) {
                    value = valueSpec2.getDefault();
                }
                if (value instanceof UnmodifiableConfig) {
                    ArrayList<String> path = new ArrayList<String>(this.path);
                    path.add((String)key);
                    builder.add((Object)new IcebergFolderEntry(path, (UnmodifiableConfig)value, this.spec));
                } else if (value instanceof ForgeConfigSpec.ConfigValue && (valueSpec = (ForgeConfigSpec.ValueSpec)this.spec.getRaw((configValue = (ForgeConfigSpec.ConfigValue)value).getPath())) != null) {
                    if (configValue.get() instanceof List) {
                        builder.add((Object)new ValueEntry((IConfigValue)new ForgeListValue(configValue, valueSpec)));
                    } else if (configValue.get() instanceof Enum) {
                        builder.add((Object)new ValueEntry((IConfigValue)new ForgeEnumValue((ForgeConfigSpec.EnumValue)configValue, valueSpec)));
                    } else if (configValue.get() instanceof UnmodifiableConfig) {
                        ArrayList<String> path = new ArrayList<String>(this.path);
                        path.add((String)key);
                        builder.add((Object)new IcebergFolderEntry(path, (UnmodifiableConfig)configValue.get(), this.spec, "This is a map configuration value, which is not currently supported by Configured. To edit this value, please modify the configuration file directly."));
                    } else {
                        builder.add((Object)new ValueEntry((IConfigValue)new ForgeValue(configValue, valueSpec)));
                    }
                }
            });
            this.entries = builder.build();
        }
        return this.entries;
    }

    public boolean isRoot() {
        return this.path.isEmpty();
    }

    public boolean isLeaf() {
        return false;
    }

    public IConfigValue<?> getValue() {
        return null;
    }

    public String getEntryName() {
        return (String)ForgeValue.lastValue(this.path, (Object)"Root");
    }

    @Nullable
    public Component getTooltip() {
        String tooltipKey;
        if (this.customComment != null) {
            return Component.m_237115_((String)this.customComment);
        }
        String translationKey = this.getTranslationKey();
        if (translationKey != null && I18n.m_118936_((String)(tooltipKey = translationKey + ".tooltip"))) {
            return Component.m_237115_((String)tooltipKey);
        }
        String comment = this.spec.getLevelComment(this.path);
        if (comment != null) {
            return Component.m_237113_((String)comment);
        }
        return null;
    }

    @Nullable
    public String getTranslationKey() {
        return this.spec.getLevelTranslationKey(this.path);
    }
}

