/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.compat.configured;

import com.anthonyhilyard.iceberg.compat.configured.IcebergConfigPlugin;
import com.anthonyhilyard.iceberg.config.IcebergConfigSpec;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.api.IModConfigProvider;
import com.mrcrayfish.configured.api.ModContext;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

public class IcebergConfigProvider
implements IModConfigProvider {
    public Set<IModConfig> getConfigurationsForMod(ModContext context) {
        HashSet<IModConfig> configs = new HashSet<IModConfig>();
        IcebergConfigProvider.addIcebergConfigsToMap(context, ModConfig.Type.CLIENT, configs::add);
        IcebergConfigProvider.addIcebergConfigsToMap(context, ModConfig.Type.COMMON, configs::add);
        IcebergConfigProvider.addIcebergConfigsToMap(context, ModConfig.Type.SERVER, configs::add);
        return configs;
    }

    private static void addIcebergConfigsToMap(ModContext context, ModConfig.Type type, Consumer<IModConfig> consumer) {
        for (ModConfig config : (Set)ConfigTracker.INSTANCE.configSets().get(type)) {
            if (!config.getModId().equals(context.modId()) || !(config.getSpec() instanceof IcebergConfigSpec)) continue;
            IcebergConfigPlugin plugin = new IcebergConfigPlugin(config);
            consumer.accept(plugin);
        }
    }
}

