/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.entity;

import java.util.ArrayList;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.entity.AbstractDynamiteEntity;
import ky.someone.mods.gag.entity.EntityTypeRegistry;
import ky.someone.mods.gag.item.ItemRegistry;
import ky.someone.mods.gag.network.FishsplosionPacket;
import ky.someone.mods.gag.platform.PlatformInvokers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FishingDynamiteEntity
extends AbstractDynamiteEntity {
    public static final TagKey<EntityType<?>> FISH_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)GAGUtil.id("fishing_dynamite_fish"));

    public FishingDynamiteEntity(EntityType<? extends FishingDynamiteEntity> type, Level level) {
        super(type, level);
    }

    public FishingDynamiteEntity(double x, double y, double z, Level level) {
        super((EntityType<? extends AbstractDynamiteEntity>)((EntityType)EntityTypeRegistry.FISHING_DYNAMITE.get()), x, y, z, level);
    }

    public FishingDynamiteEntity(LivingEntity owner, Level level) {
        super((EntityType<? extends AbstractDynamiteEntity>)((EntityType)EntityTypeRegistry.FISHING_DYNAMITE.get()), owner, level);
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 vec3 = this.m_20184_();
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123803_, this.m_20165_(-vec3.f_82479_) + this.f_19796_.m_188500_() * 0.6 - 0.3, this.m_20227_(-vec3.f_82480_) + this.f_19796_.m_188500_() * (double)this.m_20206_(), this.m_20246_(-vec3.f_82481_) + this.f_19796_.m_188500_() * 0.6 - 0.3, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        if (this.m_20069_()) {
            this.m_20256_(this.m_20184_().m_82490_(1.2));
        }
    }

    @Override
    public void detonate(Vec3 pos) {
        Fishsplosion explosion;
        Integer r = (Integer)GAGConfig.Dynamite.FISHING_RADIUS.get();
        Level level = this.m_9236_();
        if (!PlatformInvokers.explosionPre(level, explosion = new Fishsplosion(level, (Entity)this, pos.f_82479_, pos.f_82480_, pos.f_82481_, r.intValue()))) {
            explosion.m_46061_();
            explosion.m_46075_(false);
            for (Player player : level.m_6907_()) {
                if (!(player.m_20280_((Entity)this) < 4096.0)) continue;
                new FishsplosionPacket(explosion).sendTo((ServerPlayer)player);
            }
        }
    }

    protected Item m_7881_() {
        return (Item)ItemRegistry.FISHING_DYNAMITE.get();
    }

    public static class Fishsplosion
    extends Explosion {
        private int fishHit = 0;
        public final Vec3 pos = new Vec3(this.f_46013_, this.f_46014_, this.f_46015_);
        private final boolean isInWater;

        public Fishsplosion(Level level, @Nullable Entity entity, double x, double y, double z, float radius) {
            super(level, entity, null, null, x, y, z, radius, false, Explosion.BlockInteraction.KEEP);
            double eps = 0.028;
            this.isInWater = BlockPos.m_121921_((AABB)AABB.m_165882_((Vec3)this.pos, (double)eps, (double)eps, (double)eps)).anyMatch(pos -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_));
        }

        public void m_46061_() {
            if (!this.isInWater) {
                return;
            }
            AABB hitbox = AABB.m_82333_((Vec3)this.pos).m_82400_((double)this.f_46017_);
            for (LivingEntity entity : this.f_46012_.m_45976_(LivingEntity.class, hitbox)) {
                double distSqr = entity.m_20238_(this.pos);
                if (distSqr > (double)(this.f_46017_ * this.f_46017_) || !entity.m_20069_() || entity.m_6128_()) continue;
                GAGConfig.Dynamite.TargetFilter filter = (GAGConfig.Dynamite.TargetFilter)((Object)GAGConfig.Dynamite.FISHING_TARGET_FILTER.get());
                if (((Boolean)GAGConfig.Dynamite.FISHING_INSTAKILL_FISH.get()).booleanValue() && filter.isFish((Entity)entity)) {
                    ++this.fishHit;
                    entity.m_6469_(this.m_46077_(), Float.MAX_VALUE);
                    continue;
                }
                double relDist = Math.sqrt(distSqr) / (double)this.f_46017_;
                double seen = Fishsplosion.m_46064_((Vec3)this.pos, (Entity)entity);
                double damageFactor = (1.0 - relDist) * seen;
                float damage = (float)((double)((int)(damageFactor * damageFactor + damageFactor)) / 2.0 * 7.0 * (double)this.f_46017_ + 1.0);
                if (filter.isFish((Entity)entity)) {
                    ++this.fishHit;
                    entity.m_6469_(this.m_46077_(), damage * 2.0f);
                    continue;
                }
                if (!((Boolean)GAGConfig.Dynamite.FISHING_DAMAGE_ALL.get()).booleanValue()) continue;
                entity.m_6469_(this.m_46077_(), damage / 2.0f);
            }
        }

        public void m_46075_(boolean isClient) {
            if (isClient) {
                RandomSource random = this.f_46012_.f_46441_;
                if (this.isInWater) {
                    int particleCount = (int)(this.f_46017_ * 4.0f);
                    ArrayList<Vec3> points = new ArrayList<Vec3>();
                    for (int i = 0; i < particleCount; ++i) {
                        double angle = random.m_188500_() * Math.PI * 2.0;
                        double dist = random.m_188500_() * (double)this.f_46017_;
                        double x = this.pos.f_82479_ + Math.cos(angle) * dist;
                        double z = this.pos.f_82481_ + Math.sin(angle) * dist;
                        points.add(new Vec3(x, 0.0, z));
                    }
                    BlockPos cur = BlockPos.m_274446_((Position)this.pos).m_7494_();
                    while (this.f_46012_.m_46739_(cur) && !this.f_46012_.m_6425_(cur).m_76178_()) {
                        for (Vec3 p : points) {
                            this.f_46012_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, p.f_82479_, (double)cur.m_123342_() + 0.5, p.f_82481_, 0.0, 0.1, 0.0);
                        }
                        cur = cur.m_7494_();
                    }
                    for (int i = 0; i < particleCount * 4; ++i) {
                        double angle = random.m_188500_() * Math.PI * 2.0;
                        double dist = random.m_188500_() * (double)this.f_46017_;
                        double x = this.pos.f_82479_ + Math.cos(angle) * dist;
                        double y = (double)cur.m_123342_() + 0.5;
                        double z = this.pos.f_82481_ + Math.sin(angle) * dist;
                        this.f_46012_.m_7106_((ParticleOptions)ParticleTypes.f_123816_, x, y, z, 0.0, 0.05, 0.0);
                        this.f_46012_.m_7106_((ParticleOptions)ParticleTypes.f_123772_, x, y, z, 0.0, 0.2, 0.0);
                        this.f_46012_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, x, y, z, 0.0, 0.1, 0.0);
                    }
                    this.f_46012_.m_245747_(cur, SoundEvents.f_11913_, SoundSource.BLOCKS, 0.3f, 1.5f, false);
                } else {
                    for (int i = 0; i < 20; ++i) {
                        this.f_46012_.m_7106_((ParticleOptions)ParticleTypes.f_123816_, this.pos.f_82479_ + random.m_188583_(), this.pos.f_82480_ + (double)random.m_188501_(), this.pos.f_82481_ + random.m_188583_(), 0.0, 0.05, 0.0);
                    }
                    this.f_46012_.m_7785_(this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_, SoundEvents.f_11917_, SoundSource.BLOCKS, 0.6f, (1.0f + (random.m_188501_() - random.m_188501_()) * 0.2f) * 0.7f, false);
                }
            }
            if (this.isInWater) {
                this.f_46012_.m_6263_(null, this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, 0.6f, 1.0f);
                if (!isClient) {
                    Integer add = (Integer)GAGConfig.Dynamite.ADDITIONAL_FISHING_LOOT.get();
                    int fishDropped = this.fishHit;
                    ArrayList itemsToDrop = new ArrayList();
                    LootParams lootParams = new LootParams.Builder((ServerLevel)this.f_46012_).m_287286_(LootContextParams.f_81460_, (Object)this.pos).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81455_, (Object)this.f_46016_).m_287235_(LootContextParamSets.f_81414_);
                    LootTable lootTable = this.f_46012_.m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78723_);
                    for (int i = 0; i < add && !((double)fishDropped > 1.5 * (double)add.intValue()); ++i) {
                        double chance = 1.0 / (1.0 + Math.exp((double)fishDropped - 0.75 * (double)add.intValue()));
                        if (!(this.f_46012_.f_46441_.m_188500_() < chance)) continue;
                        lootTable.m_287228_(lootParams, itemsToDrop::add);
                        ++fishDropped;
                    }
                    for (ItemStack itemStack : itemsToDrop) {
                        this.f_46012_.m_7967_((Entity)new ItemEntity(this.f_46012_, this.f_46013_, this.f_46014_, this.f_46015_, itemStack));
                    }
                }
            }
        }
    }
}

