/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.util;

import com.mojang.datafixers.util.Pair;
import de.cadentem.quality_food.config.QualityConfig;
import de.cadentem.quality_food.core.Quality;
import de.cadentem.quality_food.data.QFEffectTags;
import de.cadentem.quality_food.util.QualityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.Nullable;

public class FoodUtils {
    @Nullable
    public static FoodProperties handleFoodProperties(ItemStack stack, @Nullable FoodProperties original) {
        if (original == null || !QualityUtils.hasQuality(stack)) {
            return original;
        }
        Quality quality = QualityUtils.getQuality(stack);
        int nutrition = (int)((double)original.m_38744_() * QualityConfig.getNutritionMultiplier(quality));
        float saturationModifier = original.m_38745_() * QualityConfig.getSaturationMultiplier(quality);
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.m_38760_(nutrition);
        builder.m_38758_(saturationModifier);
        if (original.m_38746_()) {
            builder.m_38757_();
        }
        if (original.m_38747_()) {
            builder.m_38765_();
        }
        if (original.m_38748_()) {
            builder.m_38766_();
        }
        List originalEffects = original.m_38749_();
        ITagManager tagManager = Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.tags());
        ITag blacklist = tagManager.getTag(QFEffectTags.BLACKLIST);
        originalEffects.forEach(originalData -> FoodUtils.modifyEffect((MobEffectInstance)originalData.getFirst(), quality, (ITag<MobEffect>)blacklist).ifPresent(instance -> {
            MobEffect effect = instance.m_19544_();
            float probability = ((Float)originalData.getSecond()).floatValue();
            if (!blacklist.contains((Object)effect)) {
                if (effect.m_19486_()) {
                    probability += QualityConfig.getProbabilityAddition(quality);
                } else if (effect.m_19483_() == MobEffectCategory.HARMFUL) {
                    probability -= QualityConfig.getProbabilityAddition(quality);
                }
            }
            if (probability > 0.0f) {
                builder.effect(() -> instance, Mth.m_14036_((float)probability, (float)0.0f, (float)1.0f));
            }
        }));
        List<Pair<Double, MobEffectInstance>> effects = FoodUtils.getEffects(stack);
        effects.forEach(data -> builder.effect(() -> ((Pair)data).getSecond(), ((Double)data.getFirst()).floatValue()));
        return builder.m_38767_();
    }

    public static Optional<MobEffectInstance> modifyEffect(MobEffectInstance instance, Quality quality) {
        ITagManager tagManager = Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.tags());
        ITag blacklist = tagManager.getTag(QFEffectTags.BLACKLIST);
        return FoodUtils.modifyEffect(instance, quality, (ITag<MobEffect>)blacklist);
    }

    public static Optional<MobEffectInstance> modifyEffect(MobEffectInstance instance, Quality quality, ITag<MobEffect> blacklist) {
        if (!QualityUtils.isValidQuality(quality)) {
            return Optional.of(instance);
        }
        MobEffect effect = instance.m_19544_();
        int duration = instance.m_19557_();
        int amplifier = instance.m_19564_();
        if (blacklist.isEmpty() || !blacklist.contains((Object)effect)) {
            if (effect.m_19486_()) {
                duration = (int)((double)duration * QualityConfig.getDurationMultiplier(quality));
                amplifier += QualityConfig.getAmplifierAddition(quality);
            } else if (effect.m_19483_() == MobEffectCategory.HARMFUL) {
                duration = (int)((double)duration / QualityConfig.getDurationMultiplier(quality));
                amplifier -= QualityConfig.getAmplifierAddition(quality);
            }
            if (amplifier >= 0 && duration > 0) {
                return Optional.of(new MobEffectInstance(effect, duration, Math.min(255, amplifier)));
            }
            return Optional.empty();
        }
        return Optional.of(instance);
    }

    public static List<Pair<Double, MobEffectInstance>> getEffects(@Nullable ItemStack stack) {
        if (stack == null) {
            return List.of();
        }
        ArrayList<Pair<Double, MobEffectInstance>> effects = new ArrayList<Pair<Double, MobEffectInstance>>();
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            ListTag effectList = tag.m_128469_("quality_food").m_128437_("effects", 10);
            for (int i = 0; i < effectList.size(); ++i) {
                CompoundTag effectTag = effectList.m_128728_(i);
                double probability = effectTag.m_128459_("chance");
                MobEffectInstance effect = MobEffectInstance.m_19560_((CompoundTag)effectTag);
                effects.add((Pair<Double, MobEffectInstance>)Pair.of((Object)probability, (Object)effect));
            }
        }
        return effects;
    }
}

