/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.network;

import de.cadentem.quality_food.client.ClientProxy;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record SyncCookingParticle(BlockPos position, double qualityBonus) {
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.position);
        buffer.writeDouble(this.qualityBonus);
    }

    public static SyncCookingParticle decode(FriendlyByteBuf buffer) {
        return new SyncCookingParticle(buffer.m_130135_(), buffer.readDouble());
    }

    public static void handle(SyncCookingParticle packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> ClientProxy.handleCookingParticles(packet.position(), packet.qualityBonus()));
        }
        context.setPacketHandled(true);
    }
}

