/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.config;

import de.cadentem.quality_food.QualityFood;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectConfig {
    public static final int ITEM = 0;
    public static final int EFFECT = 1;
    public static final int CHANCE = 2;
    public static final int DURATION = 3;
    public static final int AMPLIFIER = 4;
    public static final int PROBABILITY = 5;
    private final Effect effect;
    private Predicate<ItemStack> predicate;

    private EffectConfig(Effect effect) {
        this.effect = effect;
    }

    public static EffectConfig create(String configEntry) {
        String[] data = configEntry.split(";");
        ResourceLocation effectLocation = ResourceLocation.m_135820_((String)data[1]);
        if (!ForgeRegistries.MOB_EFFECTS.containsKey(effectLocation)) {
            QualityFood.LOG.warn("Could not find mob effect [{}]", (Object)data[1]);
            return null;
        }
        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation);
        double chance = Double.parseDouble(data[2]);
        int duration = Integer.parseInt(data[3]);
        int amplifier = Integer.parseInt(data[4]);
        double probability = Double.parseDouble(data[5]);
        EffectConfig config = new EffectConfig(new Effect(effect, chance, duration, amplifier, probability));
        if (data[0].startsWith("#")) {
            TagKey testItem = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ResourceLocation.m_135820_((String)data[0].substring(1)));
            config.predicate = stack -> stack.m_204117_(testItem);
        } else {
            Item testItem = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)data[0]));
            config.predicate = stack -> stack.m_41720_() == testItem;
        }
        return config;
    }

    public boolean test(ItemStack stack) {
        return this.predicate.test(stack);
    }

    public Effect getEffect() {
        return this.effect;
    }

    public record Effect(MobEffect effect, double chance, int duration, int amplifier, double probability) {
    }
}

