/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.compat.create;

import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import de.cadentem.quality_food.core.Quality;
import de.cadentem.quality_food.util.QualityUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class QualityItemAttributeType
implements ItemAttributeType {
    public static final DeferredRegister<ItemAttributeType> REGISTRY = DeferredRegister.create((ResourceKey)CreateBuiltInRegistries.ITEM_ATTRIBUTE_TYPE.m_123023_(), (String)"quality_food");
    public static final RegistryObject<ItemAttributeType> TYPE = REGISTRY.register("quality", QualityItemAttributeType::new);

    @NotNull
    public ItemAttribute createAttribute() {
        return new QualityItemAttribute(Quality.NONE);
    }

    public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
        if (QualityUtils.hasQuality(stack)) {
            return List.of(new QualityItemAttribute(QualityUtils.getQuality(stack)));
        }
        return List.of();
    }

    public static class QualityItemAttribute
    implements ItemAttribute {
        private static final String ID = "quality_food.quality";
        private Quality quality;

        public QualityItemAttribute(Quality quality) {
            this.quality = quality;
        }

        public boolean appliesTo(ItemStack stack, Level level) {
            return this.quality == QualityUtils.getQuality(stack);
        }

        public ItemAttributeType getType() {
            return (ItemAttributeType)TYPE.get();
        }

        public String getTranslationKey() {
            return ID;
        }

        public Object[] getTranslationParameters() {
            if (this.quality == null) {
                return new Object[]{ComponentContents.f_237124_};
            }
            String name = this.quality.getName();
            ChatFormatting color = switch (this.quality) {
                case Quality.IRON -> ChatFormatting.WHITE;
                case Quality.GOLD -> ChatFormatting.GOLD;
                case Quality.DIAMOND -> ChatFormatting.AQUA;
                default -> ChatFormatting.DARK_GRAY;
            };
            return new Object[]{Component.m_237113_((String)name).m_130940_(color)};
        }

        public void save(CompoundTag tag) {
            if (this.quality != null) {
                tag.m_128405_(ID, this.quality.ordinal());
            }
        }

        public void load(CompoundTag tag) {
            Quality quality = Quality.get(tag.m_128451_(ID));
            this.quality = quality.level() > 0 ? quality : Quality.NONE;
        }
    }
}

