/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.capability;

import de.cadentem.quality_food.capability.CapabilityHandler;
import de.cadentem.quality_food.capability.LevelData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class LevelDataProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final Map<Level, LazyOptional<LevelData>> CACHE = new HashMap<Level, LazyOptional<LevelData>>();
    private final LevelData data = new LevelData();
    private final LazyOptional<LevelData> instance = LazyOptional.of(() -> this.data);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        return capability == CapabilityHandler.LEVEL_DATA_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return ((LevelData)this.instance.orElseThrow(() -> new IllegalArgumentException("Capability instance was not present"))).serializeNBT();
    }

    public void deserializeNBT(CompoundTag tag) {
        ((LevelData)this.instance.orElseThrow(() -> new IllegalArgumentException("Capability instance was not present"))).deserializeNBT(tag);
    }

    public static LazyOptional<LevelData> getCapability(@Nullable LevelAccessor accessor) {
        if (!(accessor instanceof Level)) {
            return LazyOptional.empty();
        }
        Level level = (Level)accessor;
        LazyOptional capability = CACHE.get(level);
        if (capability == null && (capability = level.getCapability(CapabilityHandler.LEVEL_DATA_CAPABILITY)).isPresent()) {
            CACHE.put(level, (LazyOptional<LevelData>)capability);
        }
        return capability;
    }

    @Nullable
    public static LevelData getOrNull(@Nullable LevelAccessor accessor) {
        Optional resolved;
        LazyOptional<LevelData> optional = LevelDataProvider.getCapability(accessor);
        if (optional.isPresent() && (resolved = optional.resolve()).isPresent()) {
            return (LevelData)resolved.get();
        }
        return null;
    }

    @SubscribeEvent
    public static void removeCacheEntry(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            CACHE.remove(level);
        }
    }
}

