/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.capability;

import de.cadentem.quality_food.config.QualityConfig;
import de.cadentem.quality_food.core.Modification;
import de.cadentem.quality_food.core.Quality;
import de.cadentem.quality_food.util.QualityUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BlockData {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private final Set<Quality> cookedQualities = new HashSet<Quality>();
    private double qualityBonus;

    public void useQuality(ItemStack stack, @Nullable Player player) {
        Quality selected = null;
        for (Quality quality : this.cookedQualities) {
            if (selected != null && quality.level() >= selected.level()) continue;
            selected = quality;
        }
        if (selected != null) {
            QualityUtils.applyQuality(stack, selected);
        } else {
            selected = Quality.NONE;
        }
        for (Quality quality : Quality.values()) {
            if (quality.level() == 0) continue;
            double chance = RANDOM.m_188500_();
            chance = Modification.luck(player).apply(chance);
            chance = Modification.additive((float)this.qualityBonus).apply(chance);
            if (!(chance >= (double)(1.0f - QualityConfig.getChance(quality)))) continue;
            selected = quality;
        }
        QualityUtils.applyQuality(stack, selected, true);
        this.qualityBonus = 0.0;
        this.cookedQualities.clear();
    }

    public double getQuality() {
        return this.qualityBonus;
    }

    public void incrementQuality(double value) {
        this.qualityBonus += value;
    }

    public void addQualityType(Quality quality) {
        this.cookedQualities.add(quality);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("quality_bonus", this.qualityBonus);
        CompoundTag types = new CompoundTag();
        for (Quality quality : this.cookedQualities) {
            types.m_128405_(quality.getName(), quality.ordinal());
        }
        tag.m_128365_("types", (Tag)types);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.qualityBonus = tag.m_128459_("quality_bonus");
        this.cookedQualities.clear();
        CompoundTag types = tag.m_128469_("types");
        for (String name : types.m_128431_()) {
            this.cookedQualities.add(Quality.get(types.m_128451_(name)));
        }
    }
}

