/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.packet;

import com.ninni.species.server.entity.mob.update_2.Springling;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateSpringlingDataPacket {
    private final float change;
    private final boolean max;

    public UpdateSpringlingDataPacket(float change, boolean max) {
        this.change = change;
        this.max = max;
    }

    public static UpdateSpringlingDataPacket read(FriendlyByteBuf buf) {
        float change = buf.readFloat();
        boolean max = buf.readBoolean();
        return new UpdateSpringlingDataPacket(change, max);
    }

    public static void write(UpdateSpringlingDataPacket packet, FriendlyByteBuf buf) {
        buf.writeFloat(packet.change);
        buf.writeBoolean(packet.max);
    }

    public static void handle(UpdateSpringlingDataPacket packet, Supplier<NetworkEvent.Context> ctx) {
        Entity entity;
        ServerPlayer player = ctx.get().getSender();
        float change = packet.change;
        boolean max = packet.max;
        if (max && player != null && (entity = player.m_20202_()) instanceof Springling) {
            Springling springling = (Springling)entity;
            springling.setExtendedAmount(springling.getExtendedAmount() + change);
            springling.m_9236_().m_7605_((Entity)springling, (byte)4);
        }
        ctx.get().setPacketHandled(true);
    }
}

