/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.item;

import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.entity.mob.update_3.Spectre;
import com.ninni.species.server.item.util.HasImportantInteraction;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class WickedMaskItem
extends Item
implements Equipable,
HasImportantInteraction {
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource blockSource, ItemStack stack) {
            return WickedMaskItem.dispenseMask(blockSource, stack) ? stack : super.m_7498_(blockSource, stack);
        }
    };

    public static boolean dispenseMask(BlockSource blockSource, ItemStack stack) {
        BlockPos blockpos = blockSource.m_7961_().m_121945_((Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
        List list = blockSource.m_7727_().m_6443_(LivingEntity.class, new AABB(blockpos), EntitySelector.f_20408_.and(new EntitySelector.MobCanWearArmorEntitySelector(stack)));
        if (list.isEmpty()) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)list.get(0);
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)stack);
        ItemStack itemstack = stack.m_41620_(1);
        livingentity.m_8061_(equipmentslot, itemstack);
        if (livingentity instanceof Mob) {
            ((Mob)livingentity).m_21409_(equipmentslot, 2.0f);
            ((Mob)livingentity).m_21530_();
        }
        return true;
    }

    public WickedMaskItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        super.m_6883_(stack, level, entity, slot, selected);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!player.m_36341_()) {
            return this.m_269277_(this, level, player, hand);
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        Allay allay;
        if (!(!entity.m_6084_() || entity.m_9236_().f_46443_ || stack.m_41782_() && stack.m_41783_().m_128441_("id") || !player.m_36341_())) {
            CompoundTag tag = stack.m_41784_();
            String encodeId = entity.m_20078_();
            if (encodeId != null) {
                tag.m_128359_("id", encodeId);
                tag.m_128379_("OnGround", true);
                if (entity instanceof Spectre) {
                    Spectre spectre = (Spectre)entity;
                    tag.m_128359_("Type", Spectre.Type.SPECTRE.m_7912_());
                }
                if (entity.m_8077_() && !"jeb_".equals(entity.m_7755_().getString())) {
                    tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)entity.m_7770_()));
                }
                if (entity.m_20151_()) {
                    tag.m_128379_("CustomNameVisible", true);
                }
                if (!entity.m_19880_().isEmpty()) {
                    ListTag listtag = new ListTag();
                    for (String s : entity.m_19880_()) {
                        listtag.add((Object)StringTag.m_129297_((String)s));
                    }
                    tag.m_128365_("Tags", (Tag)listtag);
                }
                entity.m_7380_(tag);
                if (entity instanceof WitherBoss && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    SpeciesCriterion.WICKED_MASK_WITHER.trigger(serverPlayer);
                }
            }
            player.m_21008_(hand, stack);
            entity.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SpeciesSoundEvents.WICKED_MASK_LINK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (entity instanceof Allay && !(allay = (Allay)entity).m_218389_()) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6880_(stack, player, entity, hand);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("id")) {
            EntityType type = EntityType.m_20632_((String)tag.m_128461_("id")).orElse(null);
            if (type != null) {
                list.add((Component)type.m_20676_().m_6881_().m_130948_(Style.f_131099_.m_178520_(16763453)));
            }
        } else {
            list.add((Component)Component.m_237110_((String)"item.species.wicked_mask.desc.disguise.1", (Object[])new Object[]{Component.m_237115_((String)"key.sneak"), Component.m_237115_((String)"key.mouse.right")}).m_130940_(ChatFormatting.GRAY));
            list.add((Component)Component.m_237115_((String)"item.species.wicked_mask.desc.disguise.2").m_130940_(ChatFormatting.GRAY));
        }
        list.add((Component)Component.m_237113_((String)""));
        list.add((Component)Component.m_237115_((String)"item.modifiers.head").m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"item.species.wicked_mask.desc.apply").m_130948_(Style.f_131099_.m_178520_(15149707))));
    }

    public EquipmentSlot m_40402_() {
        return EquipmentSlot.HEAD;
    }

    public SoundEvent m_150681_() {
        return (SoundEvent)SpeciesSoundEvents.WICKED_MASK_EQUIP.get();
    }

    public boolean m_5812_(ItemStack stack) {
        return super.m_5812_(stack) || stack.m_41782_() && stack.m_41783_().m_128441_("id");
    }
}

