/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.entity.mob.update_3.Spectre;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class SpectraliburItem
extends Item {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public SpectraliburItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 8.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack mainHandItem = player.m_21205_();
        if (mainHandItem.m_150930_((Item)this) && mainHandItem.m_41782_() && mainHandItem.m_41783_().m_128441_("Souls") && mainHandItem.m_41783_().m_128451_("Souls") > 0) {
            player.m_6672_(hand);
            player.m_5496_((SoundEvent)SpeciesSoundEvents.SPECTRALIBUR_START_CHARGING.get(), 1.0f, 1.0f);
            return InteractionResultHolder.m_19096_((Object)mainHandItem);
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int time) {
        super.m_5929_(level, livingEntity, stack, time);
        if (time < stack.m_41779_() && time % 10 == 0 && stack.m_41782_() && stack.m_41783_().m_128441_("Souls") && stack.m_41783_().m_128451_("Souls") > 0) {
            stack.m_41783_().m_128405_("Souls", Math.max(stack.m_41783_().m_128451_("Souls") - 1, 0));
            stack.m_41783_().m_128405_("UsingSouls", stack.m_41783_().m_128451_("UsingSouls") + 1);
            livingEntity.m_5496_((SoundEvent)SpeciesSoundEvents.SPECTRALIBUR_USE_SOUL.get(), 1.0f, 0.75f + (float)stack.m_41783_().m_128451_("UsingSouls") * 0.1f);
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeUsed) {
        super.m_5551_(stack, level, livingEntity, timeUsed);
        this.spawnSpectres(stack, level, livingEntity);
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        super.onStopUsing(stack, entity, count);
        this.spawnSpectres(stack, entity.m_9236_(), entity);
    }

    public void spawnSpectres(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("UsingSouls") && stack.m_41783_().m_128451_("UsingSouls") > 0) {
            int usingSouls = stack.m_41783_().m_128451_("UsingSouls");
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (usingSouls == 1 || usingSouls == 3) {
                        Spectre.spawnSpectre(serverLevel, player, player.m_20097_().m_6630_(2), Spectre.Type.SPECTRE, true);
                    }
                    if (usingSouls == 2 || usingSouls == 3 || usingSouls == 4) {
                        Spectre.spawnSpectre(serverLevel, player, player.m_20097_().m_6630_(2), Spectre.Type.JOUSTING_SPECTRE, true);
                    }
                    if (usingSouls == 4) {
                        Spectre.spawnSpectre(serverLevel, player, player.m_20097_().m_6630_(2), Spectre.Type.JOUSTING_SPECTRE, true);
                    }
                    if (usingSouls == 5) {
                        Spectre.spawnSpectre(serverLevel, player, player.m_20097_().m_6630_(2), Spectre.Type.HULKING_SPECTRE, true);
                    }
                    Vec3 pos = livingEntity.m_20182_();
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.SPECTRALIBUR.get()), pos.f_82479_, pos.f_82480_ + 0.01, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                SpeciesCriterion.SUMMON_SPECTRE.trigger(serverPlayer);
            }
            livingEntity.m_5496_((SoundEvent)SpeciesSoundEvents.SPECTRALIBUR_RELEASE_SPECTRE.get(), 1.0f, 1.0f);
            if (stack.m_41783_().m_128451_("Souls") == 0) {
                stack.m_41749_("Souls");
            }
            stack.m_41749_("UsingSouls");
        }
    }

    public int m_8105_(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Souls") && stack.m_41783_().m_128451_("Souls") > 0) {
            return stack.m_41783_().m_128451_("Souls") * 10 + 10;
        }
        return 0;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot p_43274_) {
        return p_43274_ == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(p_43274_);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        return state.m_204336_(BlockTags.f_278398_) ? 1.5f : 1.0f;
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity livingEntity) {
        return true;
    }

    public boolean m_8096_(BlockState p_43298_) {
        return p_43298_.m_60713_(Blocks.f_50033_);
    }

    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.BLOCK;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, list, tooltipFlag);
        Style style = Style.f_131099_.m_178520_(4502737);
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Souls") && stack.m_41783_().m_128451_("Souls") > 0) {
            list.add((Component)Component.m_237113_((String)" "));
            int souls = stack.m_41783_().m_128451_("Souls");
            list.add((Component)Component.m_237115_((String)"item.species.spectralibur.desc.release").m_130940_(ChatFormatting.GRAY));
            if (souls > 1) {
                list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"item.species.spectralibur.desc.spectre.2", (Object[])new Object[]{souls}).m_130948_(style)));
            } else {
                list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"item.species.spectralibur.desc.spectre.1", (Object[])new Object[]{souls}).m_130948_(style)));
            }
            if (souls / 2 > 0) {
                if (souls >= 4) {
                    list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"item.species.spectralibur.desc.jousting_spectre.2", (Object[])new Object[]{souls / 2}).m_130948_(style)));
                } else {
                    list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"item.species.spectralibur.desc.jousting_spectre.1", (Object[])new Object[]{souls / 2}).m_130948_(style)));
                }
            }
            if (souls / 5 > 0) {
                if (souls >= 10) {
                    list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"item.species.spectralibur.desc.hulking_spectre.2", (Object[])new Object[]{souls / 5}).m_130948_(style)));
                } else {
                    list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"item.species.spectralibur.desc.hulking_spectre.1", (Object[])new Object[]{souls / 5}).m_130948_(style)));
                }
            }
        } else {
            list.add((Component)Component.m_237115_((String)"item.species.spectralibur.desc").m_130948_(style));
        }
    }
}

