/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_3;

import com.ninni.species.mixin_util.PlayerAccess;
import com.ninni.species.registry.SpeciesEntities;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.entity.mob.update_3.Coil;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class Harpoon
extends Projectile
implements IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<Boolean> ANCHORED = SynchedEntityData.m_135353_(Harpoon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Optional<BlockPos>> ANCHOR_POS = SynchedEntityData.m_135353_(Harpoon.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private float swingInputX = 0.0f;
    private float swingInputY = 0.0f;
    private float swingInputZ = 0.0f;
    private double targetLength = 5.0;
    private double releaseFactor = 1.5;
    public Vec3 ownerPosition = new Vec3(0.0, 0.0, 0.0);
    public Vec3 ownerPositionO = new Vec3(0.0, 0.0, 0.0);
    private boolean isZiplining;
    private Vec3 ziplineDirection;
    private Coil currentCoil;
    private double progressAlongCoil = 0.0;
    private int lastPullSoundTick = 0;

    public Harpoon(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    public Harpoon(Level world, Player owner) {
        super((EntityType)SpeciesEntities.HARPOON.get(), world);
        this.m_5602_((Entity)owner);
        this.m_6034_(owner.m_20185_(), owner.m_20186_() + (double)owner.m_20192_(), owner.m_20189_());
        this.targetLength = 5.0;
    }

    public void m_8119_() {
        super.m_8119_();
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ++this.lastPullSoundTick;
            this.updateOwnerPosition();
            boolean hasBlockAbove = this.checkBlockAbove();
            boolean canHoldKnot = this.checkCanHoldKnot();
            List coils = this.m_9236_().m_6443_(Coil.class, new AABB(this.m_20183_().m_7494_()).m_82400_(0.5), coil -> coil.isStartPoint() && !coil.isBeingPlaced());
            if (!this.isZiplining && hasBlockAbove && canHoldKnot && !coils.isEmpty() && this.m_20270_((Entity)player) <= 12.0f && !this.isAnchored()) {
                this.startZiplining(coils);
            }
            if (player.m_6117_() && player.m_21211_().m_150930_((Item)SpeciesItems.HARPOON.get())) {
                if (this.handleZiplining(player)) {
                    return;
                }
                if (this.handleAnchoring(player, hasBlockAbove)) {
                    return;
                }
                this.handleSwingMovement(player, hasBlockAbove);
            } else {
                this.handleRelease(player);
            }
            player.f_19864_ = true;
        }
    }

    private void updateOwnerPosition() {
        this.ownerPositionO = this.ownerPosition;
        this.ownerPosition = this.m_19749_().m_20182_();
    }

    private boolean checkBlockAbove() {
        BlockPos[] positions;
        boolean result = false;
        for (BlockPos pos : positions = new BlockPos[]{BlockPos.m_274446_((Position)this.m_20191_().m_82399_().m_82520_((double)(this.m_20205_() / 2.0f), (double)this.m_20206_() + 0.2, 0.0)), BlockPos.m_274446_((Position)this.m_20191_().m_82399_().m_82520_(0.0, (double)this.m_20206_() + 0.2, (double)(this.m_20205_() / 2.0f))), BlockPos.m_274446_((Position)this.m_20191_().m_82399_().m_82520_((double)(-this.m_20205_() / 2.0f), (double)this.m_20206_() + 0.2, 0.0)), BlockPos.m_274446_((Position)this.m_20191_().m_82399_().m_82520_(0.0, (double)this.m_20206_() + 0.2, (double)(-this.m_20205_() / 2.0f)))}) {
            if (this.m_9236_().m_8055_(pos).m_60812_((BlockGetter)this.m_9236_(), pos).m_83281_()) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean checkCanHoldKnot() {
        BlockState state = this.m_9236_().m_8055_(this.m_20183_().m_7494_());
        Block block = state.m_60734_();
        return block instanceof FenceBlock || block instanceof LightningRodBlock && ((Direction)state.m_61143_((Property)LightningRodBlock.f_52588_)).m_122434_().m_122478_() || block instanceof EndRodBlock && ((Direction)state.m_61143_((Property)EndRodBlock.f_52588_)).m_122434_().m_122478_() || block instanceof ChainBlock && ((Direction.Axis)state.m_61143_((Property)ChainBlock.f_55923_)).m_122478_();
    }

    private boolean handleZiplining(Player player) {
        if (this.isZiplining && this.currentCoil != null) {
            player.m_183634_();
            Coil endPoint = this.currentCoil.getEndPoint();
            if (endPoint == null) {
                this.stopZiplining();
                return true;
            }
            if (this.m_20270_((Entity)player) > 15.0f) {
                this.removeHook(player, 100);
            }
            double slopeBonus = this.ziplineDirection.f_82480_ * -0.5;
            double ziplineSpeed = 0.5;
            double distance = this.currentCoil.m_20182_().m_82554_(endPoint.m_20182_());
            double sag = distance * 0.1 * (double)this.currentCoil.getLooseness();
            Vec3 start = this.currentCoil.m_20182_();
            Vec3 end = endPoint.m_20182_();
            Vec3 middle = start.m_82549_(end).m_82490_(0.5).m_82520_(0.0, -sag, 0.0);
            this.progressAlongCoil += (ziplineSpeed + slopeBonus) / distance;
            this.progressAlongCoil = Mth.m_14008_((double)this.progressAlongCoil, (double)0.0, (double)1.0);
            Vec3 nextPos = this.quadraticBezier(start, middle, end, this.progressAlongCoil);
            if (this.lastPullSoundTick >= 20 + this.f_19796_.m_188503_(10)) {
                this.lastPullSoundTick = 0;
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SpeciesSoundEvents.HARPOON_ZIPLINING.get(), player.m_5720_(), 1.0f, 0.5f + (float)this.progressAlongCoil);
            }
            if (this.progressAlongCoil >= 1.0) {
                List nearbyCoils = this.m_9236_().m_6443_(Coil.class, new AABB(BlockPos.m_274446_((Position)end)).m_82400_(0.5), Coil::isStartPoint);
                if (!nearbyCoils.isEmpty()) {
                    this.currentCoil = (Coil)((Object)nearbyCoils.get(0));
                    this.ziplineDirection = endPoint.m_20182_().m_82546_(this.currentCoil.m_20182_()).m_82541_();
                    this.progressAlongCoil = 0.0;
                    this.m_146884_(this.currentCoil.m_20182_());
                } else {
                    this.stopZiplining();
                }
            } else {
                this.m_146884_(nextPos.m_82520_(0.0, 0.15, 0.0));
                Vec3 desiredPos = this.m_20182_().m_82520_(0.0, -this.targetLength, 0.0);
                Vec3 correction = desiredPos.m_82546_(player.m_20182_()).m_82490_(0.1);
                Vec3 dampedVel = player.m_20184_().m_82490_(0.7);
                player.m_20256_(dampedVel.m_82549_(correction));
            }
            return true;
        }
        return false;
    }

    private Vec3 quadraticBezier(Vec3 p0, Vec3 p1, Vec3 p2, double t) {
        double it = 1.0 - t;
        return p0.m_82490_(it * it).m_82549_(p1.m_82490_(2.0 * it * t)).m_82549_(p2.m_82490_(t * t));
    }

    private boolean handleAnchoring(Player player, boolean hasBlockAbove) {
        if (!this.isAnchored() && !this.isZiplining) {
            if (hasBlockAbove) {
                this.setAnchorPos(this.m_20183_().m_7494_());
                this.setAnchored(true);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SpeciesSoundEvents.HARPOON_ANCHOR.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_9236_().m_8055_(this.getAnchorPos()).m_60827_().m_56775_(), SoundSource.BLOCKS, 2.25f, 1.0f);
            }
            if (this.m_20096_()) {
                if (player instanceof PlayerAccess) {
                    PlayerAccess playerAccess = (PlayerAccess)player;
                    playerAccess.setHarpoonId(-1);
                }
                this.removeHook(player, 20);
            }
            Vec3 motion = this.m_20184_().m_82520_(0.0, -0.05, 0.0);
            this.m_20256_(motion);
            this.m_6478_(MoverType.SELF, motion);
            return true;
        }
        return false;
    }

    private void handleSwingMovement(Player player, boolean hasBlockAbove) {
        if (!hasBlockAbove) {
            this.setAnchored(false);
        }
        Vec3 anchor = Vec3.m_82512_((Vec3i)this.getAnchorPos());
        Vec3 playerPos = player.m_20182_();
        Vec3 toPlayer = playerPos.m_82546_(anchor);
        double currentLength = toPlayer.m_82553_();
        Vec3 radial = toPlayer.m_82541_();
        double reelSpeed = 0.1;
        if (this.swingInputY > 0.0f) {
            this.targetLength -= reelSpeed;
        } else if (this.swingInputY < 0.0f) {
            this.targetLength += reelSpeed;
        }
        this.targetLength = Mth.m_14008_((double)this.targetLength, (double)2.0, (double)15.0);
        double distanceError = currentLength - this.targetLength;
        double dampingFactor = 0.05 + Math.abs(distanceError) * 0.05;
        double descendingFactor = -0.3;
        if (this.swingInputY == -1.0f) {
            descendingFactor = -0.5;
            this.releaseFactor = Math.max(1.0, this.releaseFactor - 0.1);
            player.m_183634_();
            Vec3 toAnchorXZ = new Vec3(anchor.f_82479_ - playerPos.f_82479_, 0.0, anchor.f_82481_ - playerPos.f_82481_);
            Vec3 xzPull = toAnchorXZ.m_82541_().m_82490_(0.05);
            Vec3 currentVel = player.m_20184_();
            player.m_20256_(currentVel.m_82549_(xzPull));
        }
        if (this.swingInputY == 1.0f) {
            this.releaseFactor = Math.min(3.0, this.releaseFactor + 0.2);
        }
        if (player.m_20096_()) {
            this.releaseFactor = 1.0;
        }
        double yMovement = (double)this.swingInputY * descendingFactor - player.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get()) - 0.025;
        double pullStrength = Mth.m_14008_((double)(-distanceError * dampingFactor), (double)yMovement, (double)0.2);
        this.playSwingingSounds(player, pullStrength);
        Vec3 radialCorrection = radial.m_82490_(pullStrength);
        Vec3 playerVel = player.m_20184_();
        Vec3 tangentVel = playerVel.m_82546_(radial.m_82490_(playerVel.m_82526_(radial)));
        Vec3 forward = player.m_20154_().m_82541_();
        Vec3 right = forward.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        Vec3 swingVec = right.m_82490_((double)this.swingInputX).m_82549_(forward.m_82490_((double)this.swingInputZ)).m_82541_();
        Vec3 swingTangent = swingVec.m_82546_(radial.m_82490_(swingVec.m_82526_(radial))).m_82541_();
        Vec3 swingForce = swingTangent.m_82490_(0.05);
        Vec3 finalVelocity = tangentVel.m_82549_(radialCorrection).m_82549_(swingForce);
        player.m_20256_(finalVelocity);
    }

    private void playSwingingSounds(Player player, double pullStrength) {
        double speed = player.m_20184_().m_82553_();
        double minInterval = 8.0;
        double maxInterval = 25.0;
        double speedFactor = Mth.m_14008_((double)(speed * 3.0), (double)0.0, (double)1.0);
        boolean isPulling = this.swingInputY >= 0.0f;
        int interval = (int)Mth.m_14139_((double)speedFactor, (double)maxInterval, (double)minInterval) + (isPulling ? 0 : 3);
        if (Math.abs(pullStrength) > 0.01 && this.lastPullSoundTick >= interval && !player.m_20096_() && (double)player.m_20270_((Entity)this) > 2.5) {
            this.lastPullSoundTick = 0;
            float pitch = this.getSwingingPitch(player, isPulling);
            this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SpeciesSoundEvents.HARPOON_PULL.get(), player.m_5720_(), 0.5f, pitch);
        }
    }

    private float getSwingingPitch(Player player, boolean isPulling) {
        double dx = player.m_20185_() - this.m_20185_();
        double dz = player.m_20189_() - this.m_20189_();
        double distance = Math.sqrt(dx * dx + dz * dz);
        double minDistance = 0.0;
        double maxDistance = 14.0;
        double clamped = Mth.m_14008_((double)distance, (double)minDistance, (double)maxDistance);
        float stretchFactor = (float)((clamped - minDistance) / (maxDistance - minDistance));
        float pitchBase = isPulling ? 0.9f : 0.7f;
        float pitchRange = isPulling ? 0.6f : 0.5f;
        float pitch = pitchBase + stretchFactor * pitchRange;
        return pitch;
    }

    private void handleRelease(Player player) {
        if (!this.isZiplining && this.isAnchored()) {
            player.m_20256_(player.m_20184_().m_82542_(this.releaseFactor, 1.0, this.releaseFactor).m_82520_(0.0, 0.1 * this.releaseFactor, 0.0));
        }
        this.stopZiplining();
        if (player instanceof PlayerAccess) {
            PlayerAccess playerAccess = (PlayerAccess)player;
            playerAccess.setHarpoonId(-1);
        }
        this.removeHook(player, 5);
    }

    private void startZiplining(List<Coil> coils) {
        this.isZiplining = true;
        this.progressAlongCoil = 0.0;
        this.currentCoil = coils.get(0);
        Vec3 start = this.currentCoil.m_20182_();
        Vec3 end = this.currentCoil.getEndPoint().m_20182_();
        this.ziplineDirection = end.m_82546_(start).m_82541_();
        this.m_20256_(Vec3.f_82478_);
        this.setAnchored(false);
        this.setAnchorPos(null);
        this.releaseFactor = 1.0;
        this.m_146884_(start);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SpeciesSoundEvents.HARPOON_START_ZIPLINING.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
    }

    private void removeHook(Player player, int cooldown) {
        this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SpeciesSoundEvents.HARPOON_RETRIEVED.get(), player.m_5720_(), 1.0f, 1.0f);
        this.m_146870_();
        player.m_5810_();
        player.m_36335_().m_41524_((Item)SpeciesItems.HARPOON.get(), cooldown);
    }

    private void stopZiplining() {
        this.isZiplining = false;
        this.currentCoil = null;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ANCHOR_POS, Optional.empty());
        this.f_19804_.m_135372_(ANCHORED, (Object)false);
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setAnchored(tag.m_128471_("IsAnchored"));
        if (tag.m_128441_("AnchorPos")) {
            this.setAnchorPos(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("AnchorPos")));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("IsAnchored", this.isAnchored());
        if (this.getAnchorPos() != null) {
            tag.m_128365_("AnchorPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getAnchorPos()));
        }
    }

    public boolean isAnchored() {
        return (Boolean)this.f_19804_.m_135370_(ANCHORED);
    }

    public void setAnchored(boolean bl) {
        this.f_19804_.m_135381_(ANCHORED, (Object)bl);
    }

    @Nullable
    public BlockPos getAnchorPos() {
        return ((Optional)this.f_19804_.m_135370_(ANCHOR_POS)).orElse(null);
    }

    public void setAnchorPos(@Nullable BlockPos pos) {
        this.f_19804_.m_135381_(ANCHOR_POS, Optional.ofNullable(pos));
    }

    public void setSwingInput(float x, float y, float z) {
        this.swingInputX = x;
        this.swingInputY = y;
        this.swingInputZ = z;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeInt(this.m_19749_() == null ? -1 : this.m_19749_().m_19879_());
    }

    public void readSpawnData(FriendlyByteBuf friendlyByteBuf) {
        Entity owner;
        int ownerId = friendlyByteBuf.readInt();
        if (ownerId != -1 && (owner = this.m_9236_().m_6815_(ownerId)) != null) {
            this.m_5602_(owner);
        }
    }
}

