/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_3;

import com.ninni.species.registry.SpeciesDamageTypes;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesStatusEffects;
import com.ninni.species.registry.SpeciesTags;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.entity.mob.update_1.Birt;
import com.ninni.species.server.entity.util.SpeciesPose;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Ghoul
extends Monster
implements VibrationSystem {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState confusedAnimationState = new AnimationState();
    public final AnimationState searchAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public static final EntityDataAccessor<Integer> SEARCH_COOLDOWN = SynchedEntityData.m_135353_(Ghoul.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> IS_CRAWLING = SynchedEntityData.m_135353_(Ghoul.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int searchTimer = 0;
    private int waveDelay = 0;
    private int attackTimer = 0;
    private int confusedTimer = 0;
    private int crawlingCooldown = 0;
    private static final EntityDimensions CRAWLING_DIMENSIONS = EntityDimensions.m_20395_((float)0.8f, (float)0.8f);
    private final VibrationUser vibrationUser;
    private final DynamicGameEventListener<LoudVibrationListener> loudVibrationListener;
    private VibrationSystem.Data vibrationData;

    public Ghoul(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.f_21342_ = new GhoulMoveControl();
        this.m_6210_();
        this.m_274367_(1.0f);
        this.vibrationUser = new VibrationUser();
        this.vibrationData = new VibrationSystem.Data();
        this.loudVibrationListener = new DynamicGameEventListener((GameEventListener)new LoudVibrationListener(this.vibrationUser.m_280010_(), GameEvent.f_238690_.m_157827_()));
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new GhoulCrawlMeleeAttackGhoul());
        this.f_21345_.m_25352_(1, (Goal)new GhoulMeleeAttackGhoul());
        this.f_21345_.m_25352_(2, (Goal)new SetCrawling());
        this.f_21345_.m_25352_(3, new GhoulAvoidEntityGoal<Birt>(this, Birt.class, 24.0f, 1.0, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new SearchGoal());
        this.f_21345_.m_25352_(5, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(6, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, 0.15);
    }

    public void m_8119_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8119_();
        if (this.m_5448_() != null && this.m_5448_().m_6084_() && this.confusedTimer > 0) {
            this.m_6710_(null);
            this.m_6703_(null);
        }
        if (this.m_5448_() != null && this.m_5448_().m_6084_() && this.shouldCrawl() && !this.isCrawling()) {
            this.setCrawling(true);
            this.m_20124_(Pose.CROUCHING);
        }
        if (!(this.m_5448_() == null || !this.m_5448_().m_6084_() || this.f_19797_ % 50 != 0 || (livingEntity = this.m_5448_()) instanceof Player && (player = (Player)livingEntity).m_7500_() && player.m_5833_())) {
            this.m_5496_((SoundEvent)SpeciesSoundEvents.GHOUL_ANGRY.get(), 1.0f, this.m_6100_());
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.attackTimer == 0 && this.m_20089_() == SpeciesPose.ATTACK.get()) {
            this.m_20124_(this.shouldCrawl() ? Pose.CROUCHING : Pose.STANDING);
        }
        if (this.confusedTimer > 0) {
            --this.confusedTimer;
        }
        if (this.confusedTimer == 0 && (this.m_20089_() == SpeciesPose.STUN.get() || this.m_20089_() == SpeciesPose.CROUCHING_STUN.get())) {
            this.m_20124_(this.shouldCrawl() ? Pose.CROUCHING : Pose.STANDING);
        }
        if (this.waveDelay > 0) {
            --this.waveDelay;
        }
        if (this.waveDelay < 0 || this.getSearchCooldown() > 0 && this.waveDelay > 0) {
            this.waveDelay = 0;
        }
        if (this.crawlingCooldown > 0) {
            --this.crawlingCooldown;
        }
        if (this.searchTimer > 0) {
            --this.searchTimer;
        }
        if (this.searchTimer < 0 || this.getSearchCooldown() > 0 && this.searchTimer > 0) {
            this.searchTimer = 0;
        }
        if (this.getSearchCooldown() > 0) {
            this.setSearchCooldown(this.getSearchCooldown() - 1);
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    public boolean shouldCrawl() {
        boolean hasBlockAboveWhenCrawling = this.m_9236_().m_8055_(this.m_216999_().m_6630_(2)).m_280296_();
        boolean hasBlockAbove = this.m_9236_().m_8055_(this.m_216999_().m_6630_(3)).m_280296_();
        boolean isFacingWall = this.m_9236_().m_8055_(this.m_216999_().m_6630_(2).m_121945_(this.m_6350_())).m_280296_();
        boolean hasBlockAtFeet = this.m_9236_().m_8055_(this.m_216999_().m_6630_(1).m_121945_(this.m_6350_())).m_280296_();
        return this.m_20096_() && (hasBlockAboveWhenCrawling || isFacingWall && !hasBlockAtFeet || !isFacingWall && hasBlockAtFeet && hasBlockAbove);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return pose == Pose.CROUCHING ? CRAWLING_DIMENSIONS.m_20388_(this.m_6134_()) : super.m_6972_(pose);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout == 0) {
            this.idleAnimationTimeout = 180;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.attackTimer == 0 && this.attackAnimationState.m_216984_()) {
            this.attackAnimationState.m_216973_();
        }
        if (this.confusedTimer == 0 && this.confusedAnimationState.m_216984_()) {
            this.confusedAnimationState.m_216973_();
        }
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (f_19806_.equals(entityDataAccessor)) {
            if (this.m_20089_() == SpeciesPose.SEARCHING.get()) {
                this.searchAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == Pose.STANDING) {
                this.searchAnimationState.m_216973_();
                this.attackAnimationState.m_216973_();
                this.confusedAnimationState.m_216973_();
                this.m_6210_();
            } else if (this.m_20089_() == SpeciesPose.ATTACK.get()) {
                this.attackTimer = 10;
                this.attackAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == SpeciesPose.STUN.get()) {
                this.confusedTimer = 20;
                this.confusedAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == SpeciesPose.CROUCHING_STUN.get()) {
                this.confusedTimer = 20;
                this.confusedAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == Pose.CROUCHING) {
                this.searchAnimationState.m_216973_();
                this.m_6210_();
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public DamageSource torn(LivingEntity livingEntity) {
        return this.m_269291_().m_269298_(SpeciesDamageTypes.TORN, (Entity)livingEntity);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.searchTimer > 0) {
            this.searchTimer = 0;
        }
        if (this.waveDelay > 0) {
            this.waveDelay = 0;
        }
        return super.m_6469_(damageSource, amount);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SEARCH_COOLDOWN, (Object)100);
        this.f_19804_.m_135372_(IS_CRAWLING, (Object)false);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("SearchTimer", this.searchTimer);
        compoundTag.m_128405_("WaveDelay", this.waveDelay);
        compoundTag.m_128405_("SearchCooldown", this.getSearchCooldown());
        compoundTag.m_128379_("Crawling", this.isCrawling());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.searchTimer = compoundTag.m_128451_("SearchTimer");
        this.waveDelay = compoundTag.m_128451_("WaveDelay");
        this.setSearchCooldown(compoundTag.m_128451_("SearchCooldown"));
        this.setCrawling(compoundTag.m_128471_("Crawling"));
    }

    public int getSearchCooldown() {
        return (Integer)this.f_19804_.m_135370_(SEARCH_COOLDOWN);
    }

    public void setSearchCooldown(int cooldown) {
        this.f_19804_.m_135381_(SEARCH_COOLDOWN, (Object)cooldown);
    }

    public boolean isCrawling() {
        return (Boolean)this.f_19804_.m_135370_(IS_CRAWLING);
    }

    public void setCrawling(boolean isCrawling) {
        this.f_19804_.m_135381_(IS_CRAWLING, (Object)isCrawling);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.searchTimer > 0 || this.m_5448_() != null ? SoundEvents.f_271165_ : (SoundEvent)SpeciesSoundEvents.GHOUL_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpeciesSoundEvents.GHOUL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.GHOUL_DEATH.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState state) {
        this.m_5496_((SoundEvent)SpeciesSoundEvents.GHOUL_STEP.get(), 1.0f, this.m_6100_());
    }

    public boolean m_7327_(Entity entity) {
        boolean flag = entity.m_6469_(this.torn((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_20124_(SpeciesPose.ATTACK.get());
            this.m_19970_((LivingEntity)this, entity);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.m_21023_((MobEffect)SpeciesStatusEffects.BLOODLUST.get())) {
                    player.m_147207_(new MobEffectInstance((MobEffect)SpeciesStatusEffects.BLOODLUST.get(), -1, 0, false, true), (Entity)this);
                    this.m_5496_((SoundEvent)SpeciesSoundEvents.GHOUL_INFECT.get(), 1.0f, 1.0f);
                } else {
                    this.m_5496_((SoundEvent)SpeciesSoundEvents.GHOUL_ATTACK.get(), 1.0f, 1.0f);
                }
            } else {
                this.m_5496_((SoundEvent)SpeciesSoundEvents.GHOUL_ATTACK.get(), 1.0f, 1.0f);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.m_21133_(Attributes.f_22281_) > (double)livingEntity.m_21223_()) {
                    this.m_5496_((SoundEvent)SpeciesSoundEvents.BLOODLUST_FEED.get(), 1.0f, 1.0f);
                    this.m_5634_(10.0f);
                }
            }
        }
        return flag;
    }

    protected void m_7472_(DamageSource p_34697_, int p_34698_, boolean p_34699_) {
        Creeper creeper;
        super.m_7472_(p_34697_, p_34698_, p_34699_);
        Entity entity = p_34697_.m_7639_();
        if (entity instanceof Creeper && (creeper = (Creeper)entity).m_32313_()) {
            ItemStack itemstack = new ItemStack((ItemLike)SpeciesItems.GHOUL_HEAD.get());
            creeper.m_32314_();
            this.m_19983_(itemstack);
        }
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> biConsumer) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            biConsumer.accept(this.loudVibrationListener, serverLevel);
        }
    }

    public VibrationSystem.Data m_280002_() {
        return this.vibrationData;
    }

    public VibrationSystem.User m_280445_() {
        return this.vibrationUser;
    }

    public static boolean isLoudNoise(GameEvent gameEvent, ServerLevel serverLevel, BlockPos blockPos) {
        return gameEvent == GameEvent.f_157812_ || gameEvent == GameEvent.f_223696_ || gameEvent == GameEvent.f_238690_ || gameEvent == GameEvent.f_157792_ && serverLevel.m_8055_(blockPos).m_60713_(Blocks.f_50680_);
    }

    public static boolean m_219013_(EntityType<? extends Monster> p_219014_, ServerLevelAccessor p_219015_, MobSpawnType p_219016_, BlockPos p_219017_, RandomSource p_219018_) {
        return p_219017_.m_123342_() <= 0 && p_219015_.m_46791_() != Difficulty.PEACEFUL && Ghoul.m_219009_((ServerLevelAccessor)p_219015_, (BlockPos)p_219017_, (RandomSource)p_219018_) && Ghoul.m_217057_(p_219014_, (LevelAccessor)p_219015_, (MobSpawnType)p_219016_, (BlockPos)p_219017_, (RandomSource)p_219018_);
    }

    class GhoulMoveControl
    extends MoveControl {
        public GhoulMoveControl() {
            super((Mob)Ghoul.this);
        }

        public void m_8126_() {
            if (Ghoul.this.searchTimer == 0) {
                super.m_8126_();
            }
        }
    }

    public class VibrationUser
    implements VibrationSystem.User {
        private final PositionSource positionSource;

        VibrationUser() {
            this.positionSource = new EntityPositionSource((Entity)Ghoul.this, Ghoul.this.m_20192_());
        }

        public int m_280351_() {
            return 16;
        }

        public PositionSource m_280010_() {
            return this.positionSource;
        }

        public boolean m_280080_(ServerLevel serverLevel, BlockPos blockPos, GameEvent gameEvent, GameEvent.Context context) {
            if (Ghoul.this.m_21525_()) {
                return false;
            }
            return Ghoul.this.m_5448_() != null;
        }

        public void m_280271_(ServerLevel serverLevel, BlockPos blockPos, GameEvent gameEvent, @Nullable Entity entity, @Nullable Entity entity2, float f) {
        }

        public TagKey<GameEvent> m_280028_() {
            return GameEventTags.f_215855_;
        }
    }

    public class LoudVibrationListener
    implements GameEventListener {
        private final PositionSource listenerSource;
        private final int listenerRadius;

        public LoudVibrationListener(PositionSource positionSource, int i) {
            this.listenerSource = positionSource;
            this.listenerRadius = i;
        }

        public PositionSource m_142460_() {
            return this.listenerSource;
        }

        public int m_142078_() {
            return this.listenerRadius;
        }

        public boolean m_214068_(ServerLevel serverLevel, GameEvent gameEvent, GameEvent.Context context, Vec3 vec3) {
            BlockPos blockPos = BlockPos.m_274446_((Position)vec3);
            if (Ghoul.isLoudNoise(gameEvent, serverLevel, blockPos) && Ghoul.this.searchTimer == 0 && Ghoul.this.confusedTimer == 0) {
                Ghoul.this.m_20124_(Ghoul.this.shouldCrawl() ? SpeciesPose.CROUCHING_STUN.get() : SpeciesPose.STUN.get());
                Ghoul.this.m_5496_((SoundEvent)SpeciesSoundEvents.GHOUL_CONFUSED.get(), 1.0f, 1.0f);
                return true;
            }
            return false;
        }
    }

    public class GhoulCrawlMeleeAttackGhoul
    extends MeleeAttackGoal {
        public GhoulCrawlMeleeAttackGhoul() {
            super((PathfinderMob)Ghoul.this, 1.5, false);
        }

        public boolean m_8036_() {
            return super.m_8036_() && Ghoul.this.isCrawling() && Ghoul.this.confusedTimer == 0;
        }

        public boolean m_8045_() {
            return super.m_8045_() && Ghoul.this.isCrawling() && Ghoul.this.confusedTimer == 0;
        }
    }

    public class GhoulMeleeAttackGhoul
    extends MeleeAttackGoal {
        public GhoulMeleeAttackGhoul() {
            super((PathfinderMob)Ghoul.this, 3.25, false);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !Ghoul.this.isCrawling() && Ghoul.this.confusedTimer == 0;
        }

        public boolean m_8045_() {
            return super.m_8045_() && !Ghoul.this.isCrawling() && Ghoul.this.confusedTimer == 0;
        }
    }

    public class SetCrawling
    extends Goal {
        public Ghoul mob;

        SetCrawling() {
            this.mob = Ghoul.this;
        }

        public boolean m_8036_() {
            return !this.mob.shouldCrawl() && this.mob.isCrawling();
        }

        public boolean m_8045_() {
            return Ghoul.this.crawlingCooldown > 0;
        }

        public void m_8056_() {
            Ghoul.this.crawlingCooldown = 10;
        }

        public void m_8041_() {
            Ghoul.this.setCrawling(false);
            this.mob.m_20124_(Pose.STANDING);
        }
    }

    class GhoulAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        public GhoulAvoidEntityGoal(Ghoul ghoul, Class<T> tClass, float maxDistance, double walkSpeed, double sprintSpeed) {
            super((PathfinderMob)ghoul, tClass, maxDistance, walkSpeed, sprintSpeed);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !Ghoul.this.isCrawling();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !Ghoul.this.isCrawling();
        }
    }

    public class SearchGoal
    extends Goal {
        private double preyXOld;
        private double preyZOld;
        private double SecondPreyXOld;
        private double SecondPreyZOld;
        private double ThirdPreyXOld;
        private double ThirdPreyZOld;
        public static final Predicate<LivingEntity> PREY = entity -> {
            Player player;
            return !entity.m_6095_().m_204039_(SpeciesTags.CANT_BE_TARGETED_BY_GHOUL) && (!(entity instanceof Player) || !(player = (Player)entity).m_5833_() && !player.m_7500_());
        };
        private boolean endedEarly;

        public boolean m_8036_() {
            return Ghoul.this.m_5448_() == null && !Ghoul.this.isCrawling() && Ghoul.this.m_217043_().m_188501_() < 0.02f && Ghoul.this.m_21573_().m_26571_() && Ghoul.this.getSearchCooldown() == 0;
        }

        public boolean m_8045_() {
            return Ghoul.this.m_5448_() == null && Ghoul.this.searchTimer > 0 && !Ghoul.this.isCrawling();
        }

        public void m_8056_() {
            Ghoul.this.searchTimer = 200;
            Ghoul.this.m_20124_(SpeciesPose.SEARCHING.get());
            Ghoul.this.m_5496_((SoundEvent)SpeciesSoundEvents.GHOUL_SEARCHING.get(), 3.0f, 1.0f);
        }

        public void m_8037_() {
            Level level = Ghoul.this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                List list = Ghoul.this.m_9236_().m_6443_(LivingEntity.class, Ghoul.this.m_20191_().m_82400_(5.0), PREY);
                if (Ghoul.this.searchTimer % 50 == 0) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.GHOUL_SEARCHING.get()), Ghoul.this.m_20182_().f_82479_, Ghoul.this.m_20182_().f_82480_ + 0.01, Ghoul.this.m_20182_().f_82481_, 1, 0.0, 0.0, 0.0, 0.5);
                    Ghoul.this.waveDelay = 50;
                }
                if (Ghoul.this.waveDelay == 26) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.GHOUL_SEARCHING2.get()), Ghoul.this.m_20182_().f_82479_, Ghoul.this.m_20182_().f_82480_ + 0.01, Ghoul.this.m_20182_().f_82481_, 1, 0.0, 0.0, 0.0, 0.5);
                }
                if (!list.isEmpty() && Ghoul.this.searchTimer % 3 == 0) {
                    if (list.get(0) != null) {
                        this.preyXOld = ((LivingEntity)list.get(0)).m_20185_();
                        this.preyZOld = ((LivingEntity)list.get(0)).m_20189_();
                    }
                    if (list.size() > 1 && list.get(1) != null) {
                        this.SecondPreyXOld = ((LivingEntity)list.get(1)).m_20185_();
                        this.SecondPreyZOld = ((LivingEntity)list.get(1)).m_20189_();
                    }
                    if (list.size() > 2 && list.get(2) != null) {
                        this.ThirdPreyXOld = ((LivingEntity)list.get(2)).m_20185_();
                        this.ThirdPreyZOld = ((LivingEntity)list.get(2)).m_20189_();
                    }
                }
                if (Ghoul.this.waveDelay <= 26 && Ghoul.this.waveDelay > 0 && !list.isEmpty()) {
                    this.aggro(list, 0, this.preyXOld, this.preyZOld);
                    this.aggro(list, 1, this.SecondPreyXOld, this.SecondPreyZOld);
                    this.aggro(list, 2, this.ThirdPreyXOld, this.ThirdPreyZOld);
                }
            }
        }

        private void aggro(List<LivingEntity> list, int index, double x, double z) {
            Vec3 movement3;
            if (list.size() > index && list.get(index) != null && (movement3 = new Vec3(list.get(index).m_20185_() - x, 0.0, list.get(index).m_20189_() - z)).m_165925_() > 0.01) {
                this.endedEarly = true;
                Ghoul.this.m_6710_(list.get(index));
                Ghoul.this.m_21563_().m_148051_((Entity)list.get(index));
                Ghoul.this.m_21566_().m_6849_(list.get(index).m_20185_(), list.get(index).m_20186_(), list.get(index).m_20189_(), 1.0);
                Ghoul.this.searchTimer = 0;
                Ghoul.this.m_216990_((SoundEvent)SpeciesSoundEvents.GHOUL_AGGRO.get());
                LivingEntity livingEntity = list.get(index);
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    SpeciesCriterion.AGGRO_GHOUL.trigger(serverPlayer);
                }
            }
        }

        public void m_8041_() {
            List list = Ghoul.this.m_9236_().m_6443_(ServerPlayer.class, Ghoul.this.m_20191_().m_82400_(5.0), PREY);
            if (!this.endedEarly) {
                for (ServerPlayer serverPlayer : list) {
                    SpeciesCriterion.SURVIVE_GHOUL.trigger(serverPlayer);
                }
            }
            Ghoul.this.m_20124_(Ghoul.this.shouldCrawl() ? Pose.CROUCHING : Pose.STANDING);
            Ghoul.this.setSearchCooldown(800);
        }
    }
}

