/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_3;

import com.ninni.species.registry.SpeciesBlocks;
import com.ninni.species.registry.SpeciesDamageTypes;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesTags;
import com.ninni.species.server.entity.util.SpeciesPose;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class DeflectorDummy
extends ArmorStand {
    public static final EntityDataAccessor<Float> STORED_DAMAGE = SynchedEntityData.m_135353_(DeflectorDummy.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> POWERED = SynchedEntityData.m_135353_(DeflectorDummy.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState redirectAnimationState = new AnimationState();
    public final AnimationState absorbAnimationState = new AnimationState();
    public final AnimationState releaseAnimationState = new AnimationState();
    private int redirectCooldown = 0;
    private int absorbCooldown = 0;
    private int releaseCooldown = 0;

    public DeflectorDummy(EntityType<DeflectorDummy> entityEntityType, Level level) {
        super(entityEntityType, level);
        this.m_274367_(0.0f);
    }

    public static AttributeSupplier.Builder m_21183_() {
        return AttributeSupplier.m_22244_().m_22266_(Attributes.f_22276_).m_22268_(Attributes.f_22278_, 1.0).m_22266_(Attributes.f_22279_).m_22266_(Attributes.f_22284_).m_22266_(Attributes.f_22285_).m_22266_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22266_((Attribute)ForgeMod.NAMETAG_DISTANCE.get()).m_22266_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22266_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        Player player;
        Entity entity = damageSource.m_7640_();
        if (entity instanceof Player && (player = (Player)entity).m_6144_() || damageSource.m_7639_() == null) {
            return this.breakDummy(damageSource);
        }
        if (this.isPowered()) {
            this.m_20124_(SpeciesPose.ABSORB_DAMAGE.get());
            this.addStoredDamage(amount);
            this.m_5496_((SoundEvent)SpeciesSoundEvents.DEFLECTOR_DUMMY_ABSORB.get(), 1.0f, this.getStoredDamage() * 0.025f);
        } else if (this.redirectCooldown == 0 && this.m_20089_() != SpeciesPose.REDIRECT_DAMAGE.get()) {
            this.m_20124_(SpeciesPose.REDIRECT_DAMAGE.get());
            this.m_5496_((SoundEvent)SpeciesSoundEvents.DEFLECTOR_DUMMY_DEFLECT.get(), 2.0f, 1.0f);
            this.damageTargets(amount, damageSource.m_7639_());
        }
        return true;
    }

    private void damageTargets(float amount, @Nullable Entity attacker) {
        List list = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(4.0), EntitySelector.f_20406_);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.SMALL_KINETIC_ENERGY.get()), this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.01, this.m_20182_().f_82481_, 1, 0.0, 0.0, 0.0, 0.5);
        }
        for (LivingEntity target : list) {
            Projectile projectile;
            Entity entity;
            if (target.m_6095_().m_204039_(SpeciesTags.CANT_BE_DAMAGED_BY_DUMMY)) continue;
            if (attacker instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)attacker;
                this.damage(target, livingAttacker, amount);
                continue;
            }
            if (attacker instanceof Projectile && (entity = (projectile = (Projectile)attacker).m_19749_()) instanceof LivingEntity) {
                LivingEntity projectileOwner = (LivingEntity)entity;
                this.damage(target, projectileOwner, amount);
                continue;
            }
            if (attacker != null) continue;
            this.damage(target, null, amount);
        }
    }

    private void damage(LivingEntity target, @Nullable LivingEntity attacker, float amount) {
        Vec3 enemyPos = target.m_20182_().m_82546_(this.m_20182_());
        Vec3 normalizedDirection = enemyPos.m_82541_();
        double knockbackXZ = 0.75 * (1.0 - target.m_21133_(Attributes.f_22278_));
        double knockbackY = 0.15 * (1.0 - target.m_21133_(Attributes.f_22278_));
        target.m_5997_(normalizedDirection.m_7096_() * knockbackXZ, normalizedDirection.m_7098_() * knockbackY, normalizedDirection.m_7094_() * knockbackXZ);
        double distanceFromEnemy = target.m_20182_().m_82554_(this.m_20182_());
        float scalingFactor = distanceFromEnemy <= 1.0 ? 1.0f : (distanceFromEnemy <= 2.0 ? 0.8f : (distanceFromEnemy <= 3.0 ? 0.65f : 0.5f));
        amount *= scalingFactor;
        if (attacker == null) {
            target.m_6469_(this.kinetic(target), amount);
        } else {
            target.m_6469_(this.kinetic(target, attacker), amount);
        }
        this.m_7327_((Entity)target);
    }

    public void m_8119_() {
        boolean power;
        super.m_8119_();
        if (this.redirectCooldown > 0) {
            --this.redirectCooldown;
        }
        if (this.redirectCooldown == 0 && this.m_20089_() == SpeciesPose.REDIRECT_DAMAGE.get()) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.absorbCooldown > 0) {
            --this.absorbCooldown;
        }
        if (this.absorbCooldown == 0 && this.m_20089_() == SpeciesPose.ABSORB_DAMAGE.get()) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.releaseCooldown > 0) {
            --this.releaseCooldown;
        }
        if (this.releaseCooldown == 0 && this.releaseAnimationState.m_216984_()) {
            this.releaseAnimationState.m_216973_();
        }
        if (this.isPowered() && this.f_19796_.m_188503_(10) == 0) {
            this.m_9236_().m_7106_((ParticleOptions)DustParticleOptions.f_123656_, this.m_20208_(0.8), this.m_20187_(), this.m_20262_(0.8), 0.0, 0.0, 0.0);
        }
        boolean bl = power = this.m_9236_().m_277185_(this.m_20097_(), Direction.UP) > 0 || this.m_9236_().m_277185_(this.m_20097_().m_7918_(0, 1, 1), Direction.NORTH) > 0 || this.m_9236_().m_277185_(this.m_20097_().m_7918_(0, 1, -1), Direction.SOUTH) > 0 || this.m_9236_().m_277185_(this.m_20097_().m_7918_(1, 1, 0), Direction.EAST) > 0 || this.m_9236_().m_277185_(this.m_20097_().m_7918_(-1, 1, 0), Direction.WEST) > 0;
        if (power && !this.isPowered()) {
            this.setPowered(true);
        }
        if (!power && this.isPowered()) {
            this.setPowered(false);
            if (this.getStoredDamage() > 0.0f) {
                this.m_5496_((SoundEvent)SpeciesSoundEvents.DEFLECTOR_DUMMY_ATTACK.get(), 3.0f, 1.0f);
                this.releaseCooldown = 10;
                this.releaseAnimationState.m_216977_(this.f_19797_);
            }
        }
        if (this.releaseCooldown == 5 && !this.isPowered()) {
            this.damageTargets(this.getStoredDamage(), null);
            this.setStoredDamage(0.0f);
        }
    }

    private boolean breakDummy(DamageSource damageSource) {
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            if (damageSource.m_269533_(DamageTypeTags.f_268738_)) {
                this.m_6074_();
                return false;
            }
            if (!this.m_6673_(damageSource) && !this.m_31677_()) {
                if (damageSource.m_269533_(DamageTypeTags.f_268415_)) {
                    this.m_31653_(damageSource);
                    this.m_6074_();
                    return false;
                }
                if (damageSource.m_19390_()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SpeciesSoundEvents.DEFLECTOR_DUMMY_BREAK.get(), this.m_5720_(), 1.0f, 1.0f);
                    this.m_31565_();
                    this.m_6074_();
                    return false;
                }
                long i = this.m_9236_().m_46467_();
                if (i - this.f_31528_ > 5L) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SpeciesSoundEvents.DEFLECTOR_DUMMY_HURT.get(), this.m_5720_(), 1.0f, 1.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)32);
                    this.m_146852_(GameEvent.f_223706_, damageSource.m_7639_());
                    this.f_31528_ = i;
                } else {
                    this.m_31646_(damageSource);
                    this.m_31565_();
                    this.m_6074_();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void m_31653_(DamageSource p_31654_) {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SpeciesSoundEvents.DEFLECTOR_DUMMY_BREAK.get(), this.m_5720_(), 1.0f, 1.0f);
        this.m_6668_(p_31654_);
    }

    private void m_31646_(DamageSource p_31647_) {
        ItemStack itemstack = new ItemStack((ItemLike)SpeciesItems.DEFLECTOR_DUMMY.get());
        if (this.m_8077_()) {
            itemstack.m_41714_(this.m_7770_());
        }
        Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)itemstack);
        this.m_31653_(p_31647_);
    }

    private void m_31565_() {
        if (this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)SpeciesBlocks.KINETIC_CORE.get()).m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    public DamageSource kinetic(LivingEntity livingEntity, LivingEntity livingEntity2) {
        return this.m_269291_().m_268998_(SpeciesDamageTypes.KINETIC, (Entity)livingEntity, (Entity)livingEntity2);
    }

    public DamageSource kinetic(LivingEntity livingEntity) {
        return this.m_269291_().m_269298_(SpeciesDamageTypes.KINETIC, (Entity)livingEntity);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (f_19806_.equals(entityDataAccessor)) {
            if (this.m_20089_() == Pose.STANDING) {
                this.redirectAnimationState.m_216973_();
                this.absorbAnimationState.m_216973_();
            } else if (this.m_20089_() == SpeciesPose.REDIRECT_DAMAGE.get()) {
                this.redirectCooldown = 5;
                this.redirectAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == SpeciesPose.ABSORB_DAMAGE.get()) {
                this.absorbCooldown = 10;
                this.absorbAnimationState.m_216977_(this.f_19797_);
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STORED_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(POWERED, (Object)false);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128350_("StoredDamage", this.getStoredDamage());
        compoundTag.m_128379_("Powered", this.isPowered());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setStoredDamage(compoundTag.m_128457_("StoredDamage"));
        this.setPowered(compoundTag.m_128471_("Powered"));
    }

    public float getStoredDamage() {
        return ((Float)this.f_19804_.m_135370_(STORED_DAMAGE)).floatValue();
    }

    public void setStoredDamage(float amount) {
        this.f_19804_.m_135381_(STORED_DAMAGE, (Object)Float.valueOf(Math.min(amount, 80.0f)));
    }

    public void addStoredDamage(float amount) {
        this.setStoredDamage(this.getStoredDamage() + amount);
    }

    public boolean isPowered() {
        return (Boolean)this.f_19804_.m_135370_(POWERED);
    }

    public void setPowered(boolean powered) {
        this.f_19804_.m_135381_(POWERED, (Object)powered);
    }

    public InteractionResult m_7111_(Player p_31594_, Vec3 p_31595_, InteractionHand p_31596_) {
        return InteractionResult.CONSUME;
    }

    public boolean m_6040_() {
        return true;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_31636_) {
        return (SoundEvent)SpeciesSoundEvents.DEFLECTOR_DUMMY_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.DEFLECTOR_DUMMY_BREAK.get();
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public boolean m_142066_() {
        return false;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)SpeciesItems.DEFLECTOR_DUMMY.get());
    }

    public InteractionResult m_6096_(Player p_19978_, InteractionHand p_19979_) {
        return InteractionResult.FAIL;
    }
}

