/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_3;

import com.ninni.species.registry.SpeciesEntities;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.entity.util.SpeciesPose;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Coil
extends Entity {
    public static final EntityDataAccessor<Boolean> START_POINT = SynchedEntityData.m_135353_(Coil.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Optional<UUID>> END_POINT_UUID = SynchedEntityData.m_135353_(Coil.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<Optional<BlockPos>> END_POINT_POS = SynchedEntityData.m_135353_(Coil.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    public static final EntityDataAccessor<Integer> LOOSENESS = SynchedEntityData.m_135353_(Coil.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> IS_KNOT = SynchedEntityData.m_135353_(Coil.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_WAXED = SynchedEntityData.m_135353_(Coil.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_BEING_PLACED = SynchedEntityData.m_135353_(Coil.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDimensions KNOT_DIMENSIONS = EntityDimensions.m_20395_((float)0.4f, (float)0.5f);
    private int lifeTime;
    private int checkTimer = 200;

    public Coil(EntityType<? extends Coil> type, Level world) {
        super(type, world);
    }

    public Coil(Level world, boolean isStartPoint, Vec3 pos, @Nullable UUID endPointUUID, @Nullable BlockPos endPointPos) {
        this((EntityType<? extends Coil>)((EntityType)SpeciesEntities.COIL.get()), world);
        this.setStartPoint(isStartPoint);
        this.m_146884_(pos);
        this.setEndPointUUID(endPointUUID);
        this.setEndPointPos(endPointPos);
        this.m_5496_(isStartPoint ? (SoundEvent)SpeciesSoundEvents.COIL_PLACE.get() : (SoundEvent)SpeciesSoundEvents.COIL_LINK.get(), 1.0f, 1.0f);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (!this.m_20148_().equals(this.getEndPointUUID())) {
            if (this.isWaxed()) {
                if (itemInHand.m_41720_() instanceof AxeItem) {
                    itemInHand.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    this.setWaxed(false);
                    this.m_9236_().m_5594_(player, this.getBlockPos(), SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.m_9236_().m_5898_(player, 3004, this.getBlockPos(), 0);
                    if (this.getEndPoint() != null) {
                        this.getEndPoint().setWaxed(false);
                        this.m_9236_().m_5898_(player, 3004, this.getEndPoint().getBlockPos(), 0);
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (itemInHand.m_150930_(Items.f_42784_)) {
                    this.setWaxed(true);
                    this.m_9236_().m_5898_(player, 3003, this.getBlockPos(), 0);
                    if (this.getEndPoint() != null) {
                        this.getEndPoint().setWaxed(true);
                        this.m_9236_().m_5898_(player, 3003, this.getEndPoint().getBlockPos(), 0);
                    }
                    itemInHand.m_41774_(1);
                } else {
                    this.cycleLooseness();
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6096_(player, hand);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isBeingPlaced()) {
            if (++this.lifeTime > 400) {
                this.destroy(null);
            }
            return;
        }
        if (--this.checkTimer <= 0) {
            this.checkTimer = 200;
            if (this.isKnot() && this.m_9236_().m_46859_(BlockPos.m_274446_((Position)this.m_20182_()))) {
                this.destroy(null);
            }
            if (!this.isKnot() && this.m_9236_().m_46859_(this.getBlockPos())) {
                this.destroy(null);
            }
        }
    }

    public boolean m_6469_(DamageSource damageSource, float v) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.destroy(player);
        }
        return super.m_6469_(damageSource, v);
    }

    @NotNull
    public BlockPos getBlockPos() {
        Direction direction2 = Math.abs(this.m_146909_()) > 45.0f ? (this.m_146909_() > 0.0f ? Direction.DOWN : Direction.UP) : Direction.m_122364_((double)this.m_146908_());
        Vec3 offset = Vec3.m_82528_((Vec3i)direction2.m_122436_()).m_82490_(-0.125).m_82549_(this.m_20182_());
        return BlockPos.m_274446_((Position)offset);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return pose == SpeciesPose.KNOT.get() ? KNOT_DIMENSIONS : super.m_6972_(pose);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(END_POINT_UUID, Optional.empty());
        this.f_19804_.m_135372_(END_POINT_POS, Optional.empty());
        this.f_19804_.m_135372_(START_POINT, (Object)true);
        this.f_19804_.m_135372_(IS_KNOT, (Object)false);
        this.f_19804_.m_135372_(IS_WAXED, (Object)false);
        this.f_19804_.m_135372_(IS_BEING_PLACED, (Object)false);
        this.f_19804_.m_135372_(LOOSENESS, (Object)0);
    }

    protected void m_7378_(CompoundTag tag) {
        this.setStartPoint(tag.m_128471_("StartPoint"));
        this.setLooseness(tag.m_128451_("Looseness"));
        this.setKnot(tag.m_128471_("IsKnot"));
        this.setWaxed(tag.m_128471_("IsWaxed"));
        this.setIsBeingPlaced(tag.m_128471_("IsBeingPlaced"));
        if (tag.m_128403_("EndPointUUID")) {
            this.setEndPointUUID(tag.m_128342_("EndPointUUID"));
        }
        if (tag.m_128441_("EndPointPos")) {
            this.setEndPointPos(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("EndPointPos")));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128379_("StartPoint", this.isStartPoint());
        tag.m_128405_("Looseness", this.getLooseness());
        tag.m_128379_("IsKnot", this.isKnot());
        tag.m_128379_("IsWaxed", this.isWaxed());
        tag.m_128379_("IsBeingPlaced", this.isBeingPlaced());
        if (this.getEndPointUUID() != null) {
            tag.m_128362_("EndPointUUID", this.getEndPointUUID());
        }
        if (this.getEndPointPos() != null) {
            tag.m_128365_("EndPointPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getEndPointPos()));
        }
    }

    @Nullable
    public UUID getEndPointUUID() {
        return ((Optional)this.f_19804_.m_135370_(END_POINT_UUID)).orElse(null);
    }

    public void setEndPointUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(END_POINT_UUID, Optional.ofNullable(uuid));
    }

    public boolean isStartPoint() {
        return (Boolean)this.f_19804_.m_135370_(START_POINT);
    }

    public void setStartPoint(boolean bl) {
        this.f_19804_.m_135381_(START_POINT, (Object)bl);
    }

    public boolean isKnot() {
        return (Boolean)this.f_19804_.m_135370_(IS_KNOT);
    }

    public void setKnot(boolean bl) {
        this.m_20124_(bl ? SpeciesPose.KNOT.get() : Pose.STANDING);
        this.m_6210_();
        this.f_19804_.m_135381_(IS_KNOT, (Object)bl);
    }

    public boolean isWaxed() {
        return (Boolean)this.f_19804_.m_135370_(IS_WAXED);
    }

    public void setWaxed(boolean bl) {
        this.f_19804_.m_135381_(IS_WAXED, (Object)bl);
    }

    public boolean isBeingPlaced() {
        return (Boolean)this.f_19804_.m_135370_(IS_BEING_PLACED);
    }

    public void setIsBeingPlaced(boolean bl) {
        this.f_19804_.m_135381_(IS_BEING_PLACED, (Object)bl);
    }

    public int getLooseness() {
        return (Integer)this.f_19804_.m_135370_(LOOSENESS);
    }

    public void setLooseness(int value) {
        this.f_19804_.m_135381_(LOOSENESS, (Object)value);
    }

    public void cycleLooseness() {
        this.setLooseness((this.getLooseness() + 1) % 4);
        this.m_5496_((SoundEvent)SpeciesSoundEvents.COIL_ADJUST.get(), 1.0f, 1.0f - (float)this.getLooseness() / 8.0f);
        if (this.getEndPoint() != null) {
            this.getEndPoint().setLooseness(this.getLooseness());
        }
    }

    @Nullable
    public BlockPos getEndPointPos() {
        return ((Optional)this.f_19804_.m_135370_(END_POINT_POS)).orElse(null);
    }

    public void setEndPointPos(@Nullable BlockPos pos) {
        this.f_19804_.m_135381_(END_POINT_POS, Optional.ofNullable(pos));
    }

    @Nullable
    public Coil getEndPoint() {
        ServerLevel serverLevel;
        Entity entity;
        Level level;
        List coils;
        UUID uuid = this.getEndPointUUID();
        if (uuid == null) {
            return null;
        }
        BlockPos pos = this.getEndPointPos();
        if (pos != null && !(coils = this.m_9236_().m_6443_(Coil.class, new AABB(pos), coil -> uuid.equals(coil.m_20148_()))).isEmpty()) {
            return (Coil)((Object)coils.get(0));
        }
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_(uuid)) instanceof Coil) {
            Coil coil2 = (Coil)entity;
            return coil2;
        }
        return null;
    }

    private void destroy(@Nullable Player player) {
        Level level;
        if (!(this.isStartPoint() || player != null && player.m_7500_())) {
            this.m_19983_(((Item)SpeciesItems.COIL.get()).m_7968_());
        }
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, ((Item)SpeciesItems.COIL.get()).m_7968_()), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 5, 0.2, 0.2, 0.2, 0.05);
        }
        this.m_216990_((SoundEvent)SpeciesSoundEvents.COIL_REMOVE.get());
        if (!this.isStartPoint() && this.getEndPoint() != null) {
            this.getEndPoint().destroy(player);
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    @Nullable
    public ItemStack m_142340_() {
        return ((Item)SpeciesItems.COIL.get()).m_7968_();
    }

    public boolean m_6087_() {
        return true;
    }
}

