/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_2;

import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.entity.ai.goal.TrooperSwellGoal;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class Trooper
extends TamableAnimal {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(Trooper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.m_135353_(Trooper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    private int explosionRadius = 0;

    public Trooper(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(1, (Goal)new TrooperSwellGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42499_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.2, 6.0f, 2.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.35);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_204117_(ItemTags.f_262757_)) {
            SoundEvent soundEvent = itemStack.m_150930_(Items.f_42613_) ? SoundEvents.f_11874_ : SoundEvents.f_11942_;
            this.m_9236_().m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundEvent, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.m_9236_().f_46443_) {
                this.ignite();
                if (!itemStack.m_41763_()) {
                    itemStack.m_41774_(1);
                } else {
                    itemStack.m_41622_(1, (LivingEntity)player, player2 -> player2.m_21190_(hand));
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemStack.m_150930_(Items.f_42499_) && !this.m_21824_()) {
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            for (int i = 0; i < 5; ++i) {
                double d = this.f_19796_.m_188583_() * 0.02;
                double e = this.f_19796_.m_188583_() * 0.02;
                double f = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, e, f);
                this.m_216990_(SoundEvents.f_144074_);
            }
            this.m_21828_(player);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SpeciesCriterion.TAME_TROOPER.trigger(serverPlayer);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_21824_() && this.m_269323_() == player) {
            if (this.m_5448_() != null) {
                this.m_6710_(null);
            }
            if (this.isIgnited()) {
                this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)false);
            }
            this.setSwellDir(0);
            this.swell = 0;
            if (this.m_21827_()) {
                this.m_5496_((SoundEvent)SpeciesSoundEvents.TROOPER_UPROOT.get(), 1.0f, 1.5f);
            } else {
                this.m_5496_((SoundEvent)SpeciesSoundEvents.TROOPER_PLANT.get(), 1.0f, 1.5f);
            }
            for (int i = 0; i < 10; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_20075_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08);
            }
            if (!this.m_9236_().f_46443_) {
                this.m_21839_(!this.m_21827_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(DATA_IS_IGNITED, (Object)false);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128376_("Fuse", (short)this.maxSwell);
        compoundTag.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        compoundTag.m_128379_("ignited", this.isIgnited());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_("Fuse", 99)) {
            this.maxSwell = compoundTag.m_128448_("Fuse");
        }
        if (compoundTag.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = compoundTag.m_128445_("ExplosionRadius");
        }
        if (compoundTag.m_128471_("ignited")) {
            this.ignite();
        }
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            this.oldSwell = this.swell;
            if (this.isIgnited()) {
                this.setSwellDir(1);
            }
            if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            } else if (this.swell > 28) {
                this.m_5496_((SoundEvent)SpeciesSoundEvents.TROOPER_LEAVES.get(), 1.0f, 1.0f);
                for (int a = 0; a < 20; ++a) {
                    this.m_9236_().m_7106_((ParticleOptions)SpeciesParticles.TREEPER_LEAF.get(), this.m_20208_(2.0), this.m_20186_() + (double)this.m_20192_() - 0.5 + (double)(this.m_217043_().m_188501_() * 2.0f), this.m_20262_(2.0), (double)this.m_217043_().m_188501_() - 0.5, (double)this.m_217043_().m_188501_() - 0.5, (double)this.m_217043_().m_188501_() - 0.5);
                }
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        super.m_8119_();
    }

    public boolean m_7327_(Entity entity) {
        return true;
    }

    public float getSwelling(float f) {
        return Mth.m_14179_((float)f, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int i) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)i);
    }

    private void explodeCreeper() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.f_20890_ = true;
            serverLevel.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius, Level.ExplosionInteraction.MOB);
            serverLevel.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(3.0), this::isValidTarget).forEach(livingEntity -> livingEntity.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), 30.0f));
            this.m_146870_();
            this.spawnLingeringCloud();
        }
    }

    private boolean isValidTarget(LivingEntity mob) {
        return mob.m_6084_() && !(mob instanceof Trooper);
    }

    private void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaEffectCloud.m_19712_(1.5f);
            areaEffectCloud.m_19732_(-0.5f);
            areaEffectCloud.m_19740_(10);
            areaEffectCloud.m_19734_(areaEffectCloud.m_19748_() / 2);
            areaEffectCloud.m_19738_(-areaEffectCloud.m_19743_() / (float)areaEffectCloud.m_19748_());
            for (MobEffectInstance mobEffectInstance : collection) {
                areaEffectCloud.m_19716_(new MobEffectInstance(mobEffectInstance));
            }
            this.m_9236_().m_7967_((Entity)areaEffectCloud);
        }
    }

    protected void m_6475_(DamageSource damageSource, float f) {
        if (this.m_21827_()) {
            this.m_5496_((SoundEvent)SpeciesSoundEvents.TROOPER_UPROOT.get(), 1.0f, 1.5f);
            for (int i = 0; i < 10; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_20075_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08);
            }
            if (!this.m_9236_().f_46443_) {
                this.m_21839_(!this.m_21827_());
            }
        }
        super.m_6475_(damageSource, f);
    }

    public boolean isIgnited() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)true);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpeciesSoundEvents.TROOPER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.TROOPER_DEATH.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_((SoundEvent)SpeciesSoundEvents.TROOPER_STEP.get(), 0.4f, 1.0f);
    }

    public static boolean canSpawn(EntityType<Trooper> entity, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return false;
    }
}

