/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_2;

import com.google.common.annotations.VisibleForTesting;
import com.ninni.species.Species;
import com.ninni.species.client.screen.ScreenShakeEvent;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesTags;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.entity.ai.goal.TreeperPlantGoal;
import com.ninni.species.server.entity.ai.goal.TreeperUprootGoal;
import com.ninni.species.server.entity.mob.update_2.TreeperCanopy;
import com.ninni.species.server.entity.mob.update_3.Quake;
import com.ninni.species.server.entity.util.SpeciesPose;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;

public class Treeper
extends AgeableMob {
    private static final EntityDataAccessor<Integer> SAPLING_COOLDOWN = SynchedEntityData.m_135353_(Treeper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Long> LAST_POSE_CHANGE_TICK = SynchedEntityData.m_135353_(Treeper.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private static final EntityDataAccessor<Boolean> PLANTED = SynchedEntityData.m_135353_(Treeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BURNED = SynchedEntityData.m_135353_(Treeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_MOB = SynchedEntityData.m_135353_(Treeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState shakingSuccessAnimationState = new AnimationState();
    public final AnimationState shakingFailAnimationState = new AnimationState();
    public final AnimationState plantingAnimationState = new AnimationState();
    public final AnimationState uprootingAnimationState = new AnimationState();
    private final TreeperCanopy[] subEntities;
    public final TreeperCanopy trunk1;
    public final TreeperCanopy trunk2;
    public final TreeperCanopy canopyBase;
    public final TreeperCanopy canopyBase2;
    public final TreeperCanopy canopyBase3;
    public final TreeperCanopy canopyBase4;
    public final TreeperCanopy canopy8x8;
    public final TreeperCanopy canopy8x82;
    public final TreeperCanopy canopy8x83;
    public final TreeperCanopy canopy8x84;
    public final TreeperCanopy canopy8x85;
    public final TreeperCanopy canopy6x6;
    public final TreeperCanopy canopy6x62;
    public final TreeperCanopy canopy6x63;
    public final TreeperCanopy canopy6x64;
    public final TreeperCanopy canopy4x4;
    public final TreeperCanopy canopy4x42;
    public final TreeperCanopy canopy4x43;
    public final TreeperCanopy canopy4x44;
    public final TreeperCanopy canopy2x2;

    public Treeper(EntityType<? extends AgeableMob> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
        this.f_21365_ = new TreeperLookControl(this);
        this.trunk1 = new TreeperCanopy(this, "trunk1", 2.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.trunk2 = new TreeperCanopy(this, "trunk2", 2.0f, 3.0f, 0.0f, 4.0f, 0.0f);
        this.canopyBase = new TreeperCanopy(this, "canopyBase", 6.0f, 1.0f, 1.0f, 7.0f, 0.0f);
        this.canopyBase2 = new TreeperCanopy(this, "canopyBase2", 6.0f, 1.0f, -1.0f, 7.0f, 0.0f);
        this.canopyBase3 = new TreeperCanopy(this, "canopyBase3", 6.0f, 1.0f, 0.0f, 7.0f, 1.0f);
        this.canopyBase4 = new TreeperCanopy(this, "canopyBase4", 6.0f, 1.0f, 0.0f, 7.0f, -1.0f);
        this.canopy8x8 = new TreeperCanopy(this, "canopy8x8", 4.0f, 2.0f, 2.0f, 8.0f, 0.0f);
        this.canopy8x82 = new TreeperCanopy(this, "canopy8x82", 4.0f, 2.0f, -2.0f, 8.0f, 0.0f);
        this.canopy8x83 = new TreeperCanopy(this, "canopy8x83", 4.0f, 2.0f, 0.0f, 8.0f, 2.0f);
        this.canopy8x84 = new TreeperCanopy(this, "canopy8x84", 4.0f, 2.0f, 0.0f, 8.0f, -2.0f);
        this.canopy8x85 = new TreeperCanopy(this, "canopy8x85", 6.0f, 2.0f, 0.0f, 8.0f, 0.0f);
        this.canopy6x6 = new TreeperCanopy(this, "canopy6x6", 4.0f, 1.0f, 1.0f, 10.0f, 0.0f);
        this.canopy6x62 = new TreeperCanopy(this, "canopy6x62", 4.0f, 1.0f, -1.0f, 10.0f, 0.0f);
        this.canopy6x63 = new TreeperCanopy(this, "canopy6x63", 4.0f, 1.0f, 0.0f, 10.0f, 1.0f);
        this.canopy6x64 = new TreeperCanopy(this, "canopy6x64", 4.0f, 1.0f, 0.0f, 10.0f, -1.0f);
        this.canopy4x4 = new TreeperCanopy(this, "canopy4x4", 2.0f, 1.0f, 1.0f, 11.0f, 0.0f);
        this.canopy4x42 = new TreeperCanopy(this, "canopy4x42", 2.0f, 1.0f, -1.0f, 11.0f, 0.0f);
        this.canopy4x43 = new TreeperCanopy(this, "canopy4x43", 2.0f, 1.0f, 0.0f, 11.0f, 1.0f);
        this.canopy4x44 = new TreeperCanopy(this, "canopy4x44", 2.0f, 1.0f, 0.0f, 11.0f, -1.0f);
        this.canopy2x2 = new TreeperCanopy(this, "canopy2x2", 2.0f, 1.0f, 0.0f, 12.0f, 0.0f);
        this.subEntities = new TreeperCanopy[]{this.trunk1, this.trunk2, this.canopyBase, this.canopyBase2, this.canopyBase3, this.canopyBase4, this.canopy8x8, this.canopy8x82, this.canopy8x83, this.canopy8x84, this.canopy8x85, this.canopy6x6, this.canopy6x62, this.canopy6x63, this.canopy6x64, this.canopy4x4, this.canopy4x42, this.canopy4x43, this.canopy4x44, this.canopy2x2};
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
    }

    public void m_20234_(int i1) {
        super.m_20234_(i1);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(i1 + i + 1);
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.setHasMob(this.f_19796_.m_188503_(10) == 0);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TreeperPlantGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new TreeperUprootGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new TreeperLookGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 0.15);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_204117_(SpeciesTags.BURNS_TREEPER) && !this.isBurned()) {
            SoundEvent soundEvent = itemStack.m_150930_(Items.f_42613_) ? SoundEvents.f_11874_ : SoundEvents.f_11942_;
            this.m_9236_().m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundEvent, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            this.m_9236_().m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SpeciesSoundEvents.TREEPER_BURN.get(), this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            for (int l = 0; l < 30; ++l) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(2.0), this.m_20186_() + Math.random(), this.m_20262_(2.0), 0.0, 0.0, 0.0);
            }
            this.setBurned(true);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SpeciesCriterion.BURN_TREEPER_INTO_PLACE.trigger(serverPlayer);
            }
            if (!this.isPlanted()) {
                this.plant();
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemStack.m_204117_(SpeciesTags.EXTINGUISHES_TREEPER) && this.isBurned()) {
            this.m_9236_().m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11937_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            this.setBurned(false);
            if (itemStack.m_150930_(Items.f_42447_)) {
                ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)Items.f_42446_.m_7968_());
                if (!player.m_150110_().f_35937_) {
                    player.m_21008_(hand, itemstack1);
                }
            }
            for (int l = 0; l < 30; ++l) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(2.0), this.m_20186_() + Math.random(), this.m_20262_(2.0), 0.0, 0.0, 0.0);
            }
            if (this.isPlanted() && this.m_9236_().m_46462_() && this.m_20096_() && !this.m_20069_()) {
                this.uproot();
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.isPlanted() || this.isInPoseTransition() || this.f_19797_ < 20) {
            Arrays.stream(this.subEntities).forEach(this::tickParts);
        }
        if (this.getSaplingCooldown() > 0) {
            this.setSaplingCooldown(this.getSaplingCooldown() - 1);
        }
        if (this.m_9236_().f_46443_) {
            if (this.getPoseTime() < 0L != this.isPlanted()) {
                this.uprootingAnimationState.m_216973_();
                if (this.isPlanted() && this.getPoseTime() < 80L && this.getPoseTime() >= 0L) {
                    this.plantingAnimationState.m_216982_(this.f_19797_);
                }
            } else {
                this.plantingAnimationState.m_216973_();
                this.uprootingAnimationState.m_246184_(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.f_19797_);
            }
        }
        if (this.isPlanted()) {
            this.m_146922_(Math.round((double)this.m_146908_() / 90.0) * 90L);
            this.m_5618_(Math.round((double)this.f_20883_ / 90.0) * 90L);
            this.m_5616_(Math.round((double)this.f_20885_ / 90.0) * 90L);
            this.m_6034_(Math.floor(this.m_20182_().f_82479_) + (double)0.99f, this.m_20186_(), Math.floor(this.m_20182_().f_82481_) + (double)0.99f);
        }
    }

    private void tickParts(TreeperCanopy canopy) {
        canopy.m_6027_(this.m_20185_() + (double)canopy.getxOffset(), this.m_20186_() + (double)canopy.getyOffset() + (double)(this.isPlanted() ? 0.0f : 0.95f), this.m_20189_() + (double)canopy.getzOffset());
    }

    public boolean isInPoseTransition() {
        long l = this.getPoseTime();
        return l < (long)(this.isPlanted() ? 80 : 152);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (f_19806_.equals(entityDataAccessor) && this.m_20089_() == SpeciesPose.PLANTING.get()) {
            this.plantingAnimationState.m_216977_(this.f_19797_);
        }
        super.m_7350_(entityDataAccessor);
    }

    public void plant() {
        if (this.isPlanted()) {
            return;
        }
        this.m_5496_((SoundEvent)SpeciesSoundEvents.TREEPER_PLANT.get(), 2.0f, 1.0f);
        this.m_20124_(SpeciesPose.PLANTING.get());
        this.setPlanted(true);
        this.resetLastPoseChangeTick(-this.m_9236_().m_46467_());
    }

    public void uproot() {
        if (!this.isPlanted()) {
            return;
        }
        this.m_5496_((SoundEvent)SpeciesSoundEvents.TREEPER_UPROOT.get(), 1.0f, 1.0f);
        this.m_20124_(Pose.STANDING);
        this.setPlanted(false);
        this.resetLastPoseChangeTick(this.m_9236_().m_46467_());
        Species.PROXY.screenShake(new ScreenShakeEvent(this.m_20182_(), 80, 0.75f, 10.0f, true));
    }

    public long getPoseTime() {
        return this.m_9236_().m_46467_() - Math.abs((Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SAPLING_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(LAST_POSE_CHANGE_TICK, (Object)0L);
        this.f_19804_.m_135372_(PLANTED, (Object)false);
        this.f_19804_.m_135372_(BURNED, (Object)false);
        this.f_19804_.m_135372_(HAS_MOB, (Object)false);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128356_("LastPoseTick", ((Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK)).longValue());
        compoundTag.m_128405_("SaplingCooldown", this.getSaplingCooldown());
        compoundTag.m_128379_("Planted", this.isPlanted());
        compoundTag.m_128379_("Burned", this.isBurned());
        compoundTag.m_128379_("HasMob", this.hasMob());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setSaplingCooldown(compoundTag.m_128451_("SaplingCooldown"));
        this.setPlanted(compoundTag.m_128471_("Planted"));
        this.setBurned(compoundTag.m_128471_("Burned"));
        this.setHasMob(compoundTag.m_128471_("HasMob"));
        long l = compoundTag.m_128454_("LastPoseTick");
        if (l < 0L) {
            this.m_20124_(SpeciesPose.PLANTING.get());
        }
        this.resetLastPoseChangeTick(l);
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long l) {
        this.f_19804_.m_135381_(LAST_POSE_CHANGE_TICK, (Object)l);
    }

    public Optional<ItemStack> getStackInHand(Player player) {
        return Arrays.stream(InteractionHand.values()).filter(hand -> player.m_21120_(hand).m_41720_() instanceof AxeItem).map(arg_0 -> ((Player)player).m_21120_(arg_0)).findFirst();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Level serverLevel;
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.m_5496_((SoundEvent)SpeciesSoundEvents.TREEPER_HURT.get(), 1.0f, 1.0f);
            if (this.getStackInHand(player).isPresent() && this.getStackInHand(player).get().m_41720_() instanceof AxeItem && !this.isPlanted()) {
                Level level;
                if (this.getSaplingCooldown() == 0) {
                    this.m_20000_((ItemLike)SpeciesItems.ANCIENT_PINECONE.get(), 7);
                    if (this.f_19796_.m_188503_(3) == 0) {
                        this.m_20000_((ItemLike)SpeciesItems.ANCIENT_PINECONE.get(), 7);
                    }
                    if (this.f_19796_.m_188503_(3) == 0) {
                        this.m_20000_((ItemLike)SpeciesItems.ANCIENT_PINECONE.get(), 7);
                    }
                    if (this.f_19796_.m_188503_(3) == 0) {
                        this.m_20000_((ItemLike)SpeciesItems.ANCIENT_PINECONE.get(), 7);
                    }
                    this.setSaplingCooldown(this.f_19796_.m_216332_(2400, 8400));
                    this.shakingSuccessAnimationState.m_216977_(this.f_19797_);
                    this.m_5496_((SoundEvent)SpeciesSoundEvents.TREEPER_SHAKE_SUCCESS.get(), 1.0f, 1.0f);
                } else {
                    this.m_5496_((SoundEvent)SpeciesSoundEvents.TREEPER_SHAKE_FAIL.get(), 0.5f, 1.0f);
                }
                if (this.hasMob() && (level = this.m_9236_()) instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    this.setHasMob(false);
                    BlockPos pos = new BlockPos(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() + 7, this.m_20183_().m_123343_());
                    if (this.f_19796_.m_188499_()) {
                        EntityType.f_20452_.m_262496_((ServerLevel)serverLevel, pos, MobSpawnType.NATURAL);
                    } else {
                        EntityType.f_20555_.m_262496_((ServerLevel)serverLevel, pos, MobSpawnType.NATURAL);
                    }
                }
            }
        }
        this.shakingFailAnimationState.m_216977_(this.f_19797_);
        serverLevel = this.m_9236_();
        if (serverLevel instanceof ServerLevel) {
            ServerLevel serverLevel2 = (ServerLevel)serverLevel;
            if (source.m_7639_() instanceof Player) {
                for (int i = 0; i < this.f_19796_.m_188503_(15) + 5; ++i) {
                    serverLevel2.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.TREEPER_LEAF.get()), this.m_20208_(1.8), this.m_20186_() + 7.0, this.m_20262_(1.8), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        return (source.m_269533_(DamageTypeTags.f_268745_) || source.m_269533_(DamageTypeTags.f_268725_) || source.m_269533_(DamageTypeTags.f_268738_) || source.m_7639_() instanceof Quake) && super.m_6469_(source, amount);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return pose == SpeciesPose.PLANTING.get() ? entityDimensions.f_20378_ * 0.5f : entityDimensions.f_20378_ * 0.65f;
    }

    public void m_7023_(Vec3 movementInput) {
        if (this.isPlanted()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            movementInput = movementInput.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(movementInput);
    }

    public int m_8100_() {
        return this.isPlanted() ? 320 : 160;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpeciesSoundEvents.TREEPER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.isPlanted() && !this.isBurned() ? (SoundEvent)SpeciesSoundEvents.TREEPER_IDLE_PLANTED.get() : (SoundEvent)SpeciesSoundEvents.TREEPER_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.TREEPER_DEATH.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_((SoundEvent)SpeciesSoundEvents.TREEPER_STEP.get(), 1.0f, 1.0f);
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public int getSaplingCooldown() {
        return (Integer)this.f_19804_.m_135370_(SAPLING_COOLDOWN);
    }

    public void setSaplingCooldown(int saplingCooldown) {
        this.f_19804_.m_135381_(SAPLING_COOLDOWN, (Object)saplingCooldown);
    }

    public boolean isPlanted() {
        return (Boolean)this.f_19804_.m_135370_(PLANTED);
    }

    public void setPlanted(boolean planted) {
        this.f_19804_.m_135381_(PLANTED, (Object)planted);
    }

    public boolean isBurned() {
        return (Boolean)this.f_19804_.m_135370_(BURNED);
    }

    public void setBurned(boolean burned) {
        this.f_19804_.m_135381_(BURNED, (Object)burned);
    }

    public boolean hasMob() {
        return (Boolean)this.f_19804_.m_135370_(HAS_MOB);
    }

    public void setHasMob(boolean bl) {
        this.f_19804_.m_135381_(HAS_MOB, (Object)bl);
    }

    public static boolean canSpawn(EntityType<Treeper> entity, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(SpeciesTags.TREEPER_SPAWNABLE_ON);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    static class TreeperLookControl
    extends LookControl {
        protected final Treeper mob;

        TreeperLookControl(Treeper mob) {
            super((Mob)mob);
            this.mob = mob;
        }

        public void m_8128_() {
            if (!this.mob.isPlanted()) {
                super.m_8128_();
            }
        }
    }

    public static class TreeperLookGoal
    extends LookAtPlayerGoal {
        protected final Treeper mob;

        public TreeperLookGoal(Treeper mob, Class<? extends LivingEntity> class_, float f) {
            super((Mob)mob, class_, f);
            this.mob = mob;
        }

        public boolean m_8036_() {
            if (this.mob.isPlanted()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.mob.isPlanted()) {
                return false;
            }
            return super.m_8045_();
        }
    }
}

