/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_1;

import com.google.common.collect.Lists;
import com.ninni.species.registry.SpeciesBlockEntities;
import com.ninni.species.registry.SpeciesBlocks;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesTags;
import com.ninni.species.server.block.entity.BirtDwellingBlockEntity;
import com.ninni.species.server.entity.ai.goal.BirtCommunicatingGoal;
import com.ninni.species.server.entity.ai.goal.SendMessageTicksGoal;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Birt
extends Animal
implements NeutralMob,
FlyingAnimal,
VibrationSystem {
    public final AnimationState flyingAnimationState = new AnimationState();
    public float flapProgress;
    public float maxWingDeviation;
    public float prevMaxWingDeviation;
    public float prevFlapProgress;
    public float flap = 1.0f;
    public int antennaTicks;
    private float flapSpeed = 1.0f;
    public int groundTicks;
    public int messageTicks = 0;
    private static final EntityDataAccessor<Byte> BIRT_FLAGS = SynchedEntityData.m_135353_(Birt.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ANGER = SynchedEntityData.m_135353_(Birt.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    @Nullable
    private UUID angryAt;
    private int cannotEnterDwellingTicks;
    int ticksLeftToFindDwelling;
    @Nullable
    BlockPos dwellingPos;
    MoveToDwellingGoal moveToDwellingGoal;
    private final VibrationUser vibrationUser;
    private final DynamicGameEventListener<LoudVibrationListener> loudVibrationListener;
    private VibrationSystem.Data vibrationData;

    public Birt(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, false);
        this.vibrationUser = new VibrationUser();
        this.vibrationData = new VibrationSystem.Data();
        this.loudVibrationListener = new DynamicGameEventListener((GameEventListener)new LoudVibrationListener(this.vibrationUser.m_280010_(), GameEvent.f_238690_.m_157827_()));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(0, (Goal)new FindDwellingGoal());
        this.f_21345_.m_25352_(1, (Goal)new EnterDwellingGoal());
        this.moveToDwellingGoal = new MoveToDwellingGoal();
        this.f_21345_.m_25352_(2, (Goal)this.moveToDwellingGoal);
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_((TagKey)ItemTags.f_13149_), false));
        this.f_21345_.m_25352_(4, (Goal)new SendMessageTicksGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new BirtCommunicatingGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new BirtWanderAroundGoal());
        this.f_21345_.m_25352_(9, (Goal)new BirtLookAroundGoal());
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> biConsumer) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            biConsumer.accept(this.loudVibrationListener, serverLevel);
        }
    }

    public static AttributeSupplier.Builder createBirtAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BIRT_FLAGS, (Object)0);
        this.f_19804_.m_135372_(ANGER, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (f_19806_.equals(entityDataAccessor)) {
            Pose entityPose = this.m_20089_();
            if (entityPose == Pose.FALL_FLYING) {
                this.flyingAnimationState.m_216977_(this.f_146733_);
            } else {
                this.flyingAnimationState.m_216973_();
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("canMessage", this.messageTicks);
        compoundTag.m_128405_("CannotEnterDwellingTicks", this.cannotEnterDwellingTicks);
        if (this.hasDwelling()) {
            assert (this.getDwellingPos() != null);
            compoundTag.m_128365_("DwellingPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getDwellingPos()));
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.messageTicks = compoundTag.m_128451_("canMessage");
        this.cannotEnterDwellingTicks = compoundTag.m_128451_("CannotEnterDwellingTicks");
        if (compoundTag.m_128441_("DwellingPos")) {
            this.dwellingPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("DwellingPos"));
        }
    }

    public void m_8107_() {
        super.m_8107_();
        Vec3 vec3d = this.m_20184_();
        if (this.antennaTicks > 0) {
            --this.antennaTicks;
        }
        if (!this.m_20096_() && vec3d.f_82480_ < 0.0 && this.m_5448_() == null) {
            this.m_20256_(vec3d.m_82542_(1.0, 0.6, 1.0));
        }
        if (this.m_29443_()) {
            this.groundTicks = this.f_19796_.m_188503_(300) + 20;
            this.m_20124_(Pose.FALL_FLYING);
        } else {
            --this.groundTicks;
            this.m_20124_(Pose.STANDING);
        }
        if (this.cannotEnterDwellingTicks > 0) {
            --this.cannotEnterDwellingTicks;
        }
        if (this.ticksLeftToFindDwelling > 0) {
            --this.ticksLeftToFindDwelling;
        }
        boolean bl = this.m_21660_() && this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) < 4.0;
        this.setNearTarget(bl);
        if (this.f_146733_ % 20 == 0 && !this.isDwellingValid()) {
            this.dwellingPos = null;
        }
        if (this.messageTicks > 0) {
            --this.messageTicks;
        }
        this.flapWings();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            VibrationSystem.Ticker.m_280259_((Level)this.m_9236_(), (VibrationSystem.Data)this.vibrationData, (VibrationSystem.User)this.vibrationUser);
        }
    }

    void startMovingTo(BlockPos pos) {
        Vec3 vec3d2;
        Vec3 vec3d = Vec3.m_82539_((Vec3i)pos);
        int i = 0;
        BlockPos blockPos = this.m_20183_();
        int j = (int)vec3d.f_82480_ - blockPos.m_123342_();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int m = blockPos.m_123333_((Vec3i)pos);
        if (m < 15) {
            k = m / 2;
            l = m / 2;
        }
        if ((vec3d2 = AirRandomPos.m_148387_((PathfinderMob)this, (int)k, (int)l, (int)i, (Vec3)vec3d, (double)0.3141592741012573)) != null) {
            this.f_21344_.m_26529_(0.5f);
            this.f_21344_.m_26519_(vec3d2.f_82479_, vec3d2.f_82480_, vec3d2.f_82481_, 1.0);
        }
    }

    @Nullable
    public Birt findReciever() {
        List list = this.m_9236_().m_45971_(Birt.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82400_(8.0));
        double d = Double.MAX_VALUE;
        Birt birt = null;
        for (Birt birt2 : list) {
            if (!(this.m_20280_((Entity)birt2) < d)) continue;
            birt = birt2;
            d = this.m_20280_((Entity)birt2);
        }
        return birt;
    }

    public boolean canSendMessage() {
        return this.messageTicks > 0 && this.m_5448_() == null;
    }

    public void setMessageTicks(int messageTicks) {
        this.messageTicks = messageTicks;
    }

    public void resetMessageTicks() {
        this.messageTicks = 0;
    }

    public void m_7822_(byte status) {
        if (status == 10) {
            this.antennaTicks = 60;
        } else {
            super.m_7822_(status);
        }
    }

    public void sendMessage(ServerLevel world, Birt other) {
        this.resetMessageTicks();
        other.resetMessageTicks();
        EntityPositionSource positionSource = new EntityPositionSource((Entity)this, 0.75f);
        world.m_5594_(null, other.m_20183_(), (SoundEvent)SpeciesSoundEvents.BIRT_MESSAGE.get(), SoundSource.NEUTRAL, 1.0f, 0.6f / (world.m_213780_().m_188501_() * 0.4f + 0.8f));
        world.m_8767_((ParticleOptions)new VibrationParticleOption((PositionSource)positionSource, 20), other.m_20185_(), other.m_20186_() + 0.75, other.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
    }

    private void flapWings() {
        this.prevFlapProgress = this.flapProgress;
        this.prevMaxWingDeviation = this.maxWingDeviation;
        this.maxWingDeviation += (float)(this.m_20096_() || this.m_20159_() ? -1 : 4) * 0.3f;
        this.maxWingDeviation = Mth.m_14036_((float)this.maxWingDeviation, (float)0.0f, (float)1.0f);
        if (!this.m_20096_() && this.flapSpeed < 1.0f) {
            this.flapSpeed = 1.0f;
        }
        this.flapSpeed *= 0.9f;
        Vec3 vec3d = this.m_20184_();
        if (!this.m_20096_() && vec3d.f_82480_ < 0.0) {
            this.m_20256_(vec3d.m_82542_(1.0, 0.6, 1.0));
        }
        this.flapProgress += this.flapSpeed * 2.0f;
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.flap;
    }

    protected void m_142043_() {
        this.m_5496_((SoundEvent)SpeciesSoundEvents.BIRT_FLY.get(), 0.15f, 1.0f);
        this.flap = this.f_146794_ + this.maxWingDeviation / 2.0f;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER);
    }

    public void m_7870_(int angerTime) {
        this.f_19804_.m_135381_(ANGER, (Object)angerTime);
    }

    @Nullable
    public UUID m_6120_() {
        return this.angryAt;
    }

    public void m_6925_(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }

    boolean canEnterDwelling() {
        if (this.cannotEnterDwellingTicks <= 0 && this.m_5448_() == null) {
            return this.m_9236_().m_46461_();
        }
        return false;
    }

    public void setCannotEnterDwellingTicks(int cannotEnterDwellingTicks) {
        this.cannotEnterDwellingTicks = cannotEnterDwellingTicks;
    }

    private boolean doesDwellingHaveSpace(BlockPos pos) {
        BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
        if (blockEntity instanceof BirtDwellingBlockEntity) {
            return !((BirtDwellingBlockEntity)blockEntity).isFullOfBirts();
        }
        return false;
    }

    boolean isDwellingValid() {
        if (!this.hasDwelling()) {
            return false;
        }
        BlockEntity blockEntity = this.m_9236_().m_7702_(this.dwellingPos);
        return blockEntity != null && blockEntity.m_58903_() == SpeciesBlockEntities.BIRT_DWELLING.get();
    }

    private void setNearTarget(boolean nearTarget) {
        this.setBirtFlag(2, nearTarget);
    }

    boolean isTooFar(BlockPos pos) {
        return !this.isWithinDistance(pos, 32);
    }

    private void setBirtFlag(int bit, boolean value) {
        if (value) {
            this.f_19804_.m_135381_(BIRT_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(BIRT_FLAGS) | bit)));
        } else {
            this.f_19804_.m_135381_(BIRT_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(BIRT_FLAGS) & ~bit)));
        }
    }

    @VisibleForDebug
    public boolean hasDwelling() {
        return this.dwellingPos != null;
    }

    @Nullable
    @VisibleForDebug
    public BlockPos getDwellingPos() {
        return this.dwellingPos;
    }

    boolean isWithinDistance(BlockPos pos, int distance) {
        return pos.m_123314_((Vec3i)this.m_20183_(), (double)distance);
    }

    public float m_5610_(BlockPos blockPos, LevelReader levelReader) {
        return levelReader.m_8055_(blockPos).m_60795_() ? 10.0f : 0.0f;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        return false;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
    }

    protected void m_7840_(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos blockPos) {
                return !Birt.this.m_9236_().m_8055_(blockPos.m_7495_()).m_60795_();
            }
        };
        flyingPathNavigation.m_26440_(false);
        flyingPathNavigation.m_7008_(false);
        flyingPathNavigation.m_26443_(true);
        return flyingPathNavigation;
    }

    public static boolean canSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return false;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SpeciesSoundEvents.BIRT_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SpeciesSoundEvents.BIRT_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.BIRT_DEATH.get();
    }

    public VibrationSystem.Data m_280002_() {
        return this.vibrationData;
    }

    public VibrationSystem.User m_280445_() {
        return this.vibrationUser;
    }

    public static boolean isLoudNoise(GameEvent gameEvent, ServerLevel serverLevel, BlockPos blockPos) {
        return gameEvent == GameEvent.f_157812_ || gameEvent == GameEvent.f_223696_ || gameEvent == GameEvent.f_238690_ || gameEvent == GameEvent.f_157792_ && serverLevel.m_8055_(blockPos).m_60713_(Blocks.f_50680_);
    }

    public class VibrationUser
    implements VibrationSystem.User {
        private static final int VIBRATION_EVENT_LISTENER_RANGE = 16;
        private final PositionSource positionSource;

        VibrationUser() {
            this.positionSource = new EntityPositionSource((Entity)Birt.this, Birt.this.m_20192_());
        }

        public int m_280351_() {
            return 16;
        }

        public PositionSource m_280010_() {
            return this.positionSource;
        }

        public boolean m_280080_(ServerLevel serverLevel, BlockPos blockPos, GameEvent gameEvent, GameEvent.Context context) {
            if (Birt.this.m_21525_()) {
                return false;
            }
            return Birt.this.m_5448_() != null;
        }

        public void m_280271_(ServerLevel serverLevel, BlockPos blockPos, GameEvent gameEvent, @Nullable Entity entity, @Nullable Entity entity2, float f) {
        }

        public TagKey<GameEvent> m_280028_() {
            return GameEventTags.f_215855_;
        }
    }

    public class LoudVibrationListener
    implements GameEventListener {
        private final PositionSource listenerSource;
        private final int listenerRadius;

        public LoudVibrationListener(PositionSource positionSource, int i) {
            this.listenerSource = positionSource;
            this.listenerRadius = i;
        }

        public PositionSource m_142460_() {
            return this.listenerSource;
        }

        public int m_142078_() {
            return this.listenerRadius;
        }

        public boolean m_214068_(ServerLevel serverLevel, GameEvent gameEvent, GameEvent.Context context, Vec3 vec3) {
            BlockPos blockPos = BlockPos.m_274446_((Position)vec3);
            if (Birt.isLoudNoise(gameEvent, serverLevel, blockPos)) {
                Birt.this.m_6710_(null);
                return true;
            }
            return false;
        }
    }

    private class FindDwellingGoal
    extends NotAngryGoal {
        FindDwellingGoal() {
        }

        @Override
        public boolean canBirtStart() {
            return Birt.this.ticksLeftToFindDwelling == 0 && !Birt.this.hasDwelling() && Birt.this.canEnterDwelling();
        }

        @Override
        public boolean canBirtContinue() {
            return false;
        }

        public void m_8056_() {
            Birt.this.ticksLeftToFindDwelling = 200;
            List<BlockPos> list = this.getNearbyFreeDwellings();
            if (!list.isEmpty()) {
                BlockPos blockPos;
                Iterator<BlockPos> var2 = list.iterator();
                do {
                    if (var2.hasNext()) continue;
                    Birt.this.moveToDwellingGoal.clearPossibleDwellings();
                    Birt.this.dwellingPos = list.get(0);
                    return;
                } while (Birt.this.moveToDwellingGoal.isPossibleDwelling(blockPos = var2.next()));
                Birt.this.dwellingPos = blockPos;
            }
        }

        private List<BlockPos> getNearbyFreeDwellings() {
            BlockPos blockPos = Birt.this.m_20183_();
            PoiManager pointOfInterestStorage = ((ServerLevel)Birt.this.m_9236_()).m_8904_();
            Stream stream = pointOfInterestStorage.m_27181_(poiType -> poiType.m_203656_(SpeciesTags.BIRT_HOME), blockPos, 20, PoiManager.Occupancy.ANY);
            return stream.map(PoiRecord::m_27257_).filter(Birt.this::doesDwellingHaveSpace).sorted(Comparator.comparingDouble(blockPos2 -> blockPos2.m_123331_((Vec3i)blockPos))).collect(Collectors.toList());
        }
    }

    class EnterDwellingGoal
    extends NotAngryGoal {
        EnterDwellingGoal() {
        }

        @Override
        public boolean canBirtStart() {
            if (Birt.this.hasDwelling() && Birt.this.canEnterDwelling()) {
                BlockEntity blockEntity;
                assert (Birt.this.dwellingPos != null);
                if (Birt.this.dwellingPos.m_203195_((Position)Birt.this.m_20182_(), 2.0) && (blockEntity = Birt.this.m_9236_().m_7702_(Birt.this.dwellingPos)) instanceof BirtDwellingBlockEntity) {
                    BirtDwellingBlockEntity blockEntity1 = (BirtDwellingBlockEntity)blockEntity;
                    if (!blockEntity1.isFullOfBirts()) {
                        return true;
                    }
                    Birt.this.dwellingPos = null;
                }
            }
            return false;
        }

        @Override
        public boolean canBirtContinue() {
            return false;
        }

        public void m_8056_() {
            BlockEntity blockEntity = Birt.this.m_9236_().m_7702_(Birt.this.dwellingPos);
            if (blockEntity instanceof BirtDwellingBlockEntity) {
                BirtDwellingBlockEntity birtDwellingBlockEntity = (BirtDwellingBlockEntity)blockEntity;
                birtDwellingBlockEntity.tryEnterDwelling((Entity)Birt.this);
            }
        }
    }

    @VisibleForDebug
    public class MoveToDwellingGoal
    extends NotAngryGoal {
        int ticks;
        final List<BlockPos> possibleDwellings;
        @Nullable
        private Path path;
        private int ticksUntilLost;

        MoveToDwellingGoal() {
            this.ticks = Birt.this.m_9236_().f_46441_.m_188503_(10);
            this.possibleDwellings = Lists.newArrayList();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canBirtStart() {
            return Birt.this.dwellingPos != null && !Birt.this.m_21536_() && Birt.this.canEnterDwelling() && !this.isCloseEnough(Birt.this.dwellingPos) && Birt.this.m_9236_().m_8055_(Birt.this.dwellingPos).m_60713_((Block)SpeciesBlocks.BIRT_DWELLING.get());
        }

        @Override
        public boolean canBirtContinue() {
            return this.canBirtStart();
        }

        public void m_8056_() {
            this.ticks = 0;
            this.ticksUntilLost = 0;
            super.m_8056_();
        }

        public void m_8041_() {
            this.ticks = 0;
            this.ticksUntilLost = 0;
            Birt.this.f_21344_.m_26573_();
            Birt.this.f_21344_.m_26566_();
        }

        public void m_8037_() {
            if (Birt.this.dwellingPos != null) {
                ++this.ticks;
                if (this.ticks > this.m_183277_(600)) {
                    this.makeChosenDwellingPossibleDwelling();
                } else if (!Birt.this.f_21344_.m_26572_()) {
                    if (!Birt.this.isWithinDistance(Birt.this.dwellingPos, 16)) {
                        if (Birt.this.isTooFar(Birt.this.dwellingPos)) {
                            this.setLost();
                        } else {
                            Birt.this.startMovingTo(Birt.this.dwellingPos);
                        }
                    } else {
                        boolean bl = this.startMovingToFar(Birt.this.dwellingPos);
                        if (!bl) {
                            this.makeChosenDwellingPossibleDwelling();
                        } else if (this.path != null && Objects.requireNonNull(Birt.this.f_21344_.m_26570_()).m_77385_(this.path)) {
                            ++this.ticksUntilLost;
                            if (this.ticksUntilLost > 60) {
                                this.setLost();
                                this.ticksUntilLost = 0;
                            }
                        } else {
                            this.path = Birt.this.f_21344_.m_26570_();
                        }
                    }
                }
            }
        }

        private boolean startMovingToFar(BlockPos pos) {
            Birt.this.f_21344_.m_26529_(10.0f);
            Birt.this.f_21344_.m_26519_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 1.0);
            return Birt.this.f_21344_.m_26570_() != null && Birt.this.f_21344_.m_26570_().m_77403_();
        }

        boolean isPossibleDwelling(BlockPos pos) {
            return this.possibleDwellings.contains(pos);
        }

        private void addPossibleDwelling(BlockPos pos) {
            this.possibleDwellings.add(pos);
            while (this.possibleDwellings.size() > 3) {
                this.possibleDwellings.remove(0);
            }
        }

        void clearPossibleDwellings() {
            this.possibleDwellings.clear();
        }

        private void makeChosenDwellingPossibleDwelling() {
            if (Birt.this.dwellingPos != null) {
                this.addPossibleDwelling(Birt.this.dwellingPos);
            }
            this.setLost();
        }

        private void setLost() {
            Birt.this.dwellingPos = null;
            Birt.this.ticksLeftToFindDwelling = 200;
        }

        private boolean isCloseEnough(BlockPos pos) {
            if (Birt.this.isWithinDistance(pos, 2)) {
                return true;
            }
            Path path = Birt.this.f_21344_.m_26570_();
            return path != null && path.m_77406_().equals((Object)pos) && path.m_77403_() && path.m_77392_();
        }
    }

    class BirtWanderAroundGoal
    extends Goal {
        BirtWanderAroundGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (Birt.this.groundTicks < 0) {
                return true;
            }
            if (Birt.this.m_29443_()) {
                return Birt.this.f_21344_.m_26571_() && Birt.this.f_19796_.m_188503_(10) == 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return Birt.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3d = this.getRandomLocation();
            if (vec3d != null) {
                Birt.this.f_21344_.m_26536_(Birt.this.f_21344_.m_7864_(BlockPos.m_274446_((Position)vec3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 getRandomLocation() {
            Vec3 vec3d2;
            assert (Birt.this.dwellingPos != null);
            if (Birt.this.isDwellingValid() && !Birt.this.isWithinDistance(Birt.this.dwellingPos, 22)) {
                Vec3 vec3d = Vec3.m_82512_((Vec3i)Birt.this.dwellingPos);
                vec3d2 = vec3d.m_82546_(Birt.this.m_20182_()).m_82541_();
            } else {
                vec3d2 = Birt.this.m_20252_(0.0f);
            }
            Vec3 vec3d3 = HoverRandomPos.m_148465_((PathfinderMob)Birt.this, (int)12, (int)5, (double)vec3d2.f_82479_, (double)vec3d2.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vec3d3 != null ? vec3d3 : AirAndWaterRandomPos.m_148357_((PathfinderMob)Birt.this, (int)12, (int)2, (int)-2, (double)vec3d2.f_82479_, (double)vec3d2.f_82481_, (double)1.5707963705062866);
        }
    }

    class BirtLookAroundGoal
    extends RandomLookAroundGoal {
        BirtLookAroundGoal() {
            super((Mob)Birt.this);
        }

        public boolean m_8036_() {
            return Birt.this.m_20096_() && super.m_8036_();
        }

        public boolean m_8045_() {
            return Birt.this.m_20096_() && super.m_8045_();
        }
    }

    private abstract class NotAngryGoal
    extends Goal {
        NotAngryGoal() {
        }

        public abstract boolean canBirtStart();

        public abstract boolean canBirtContinue();

        public boolean m_8036_() {
            return this.canBirtStart() && !Birt.this.m_21660_();
        }

        public boolean m_8045_() {
            return this.canBirtContinue() && !Birt.this.m_21660_();
        }
    }
}

