/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class StackatickFollowOwnerGoal
extends Goal {
    private final TamableAnimal tamable;
    private LivingEntity owner;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;
    private final boolean canFly;

    public StackatickFollowOwnerGoal(TamableAnimal tamableAnimal, double d, float f, float g, boolean bl) {
        this.tamable = tamableAnimal;
        this.level = tamableAnimal.m_9236_();
        this.speedModifier = d;
        this.navigation = tamableAnimal.m_21573_();
        this.startDistance = f;
        this.stopDistance = g;
        this.canFly = bl;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(tamableAnimal.m_21573_() instanceof GroundPathNavigation) && !(tamableAnimal.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        LivingEntity livingEntity = this.tamable.m_269323_();
        if (livingEntity == null) {
            return false;
        }
        if (livingEntity.m_5833_()) {
            return false;
        }
        if (this.tamable.m_21827_()) {
            return false;
        }
        if (this.tamable.m_20280_((Entity)livingEntity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingEntity;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        if (this.tamable.m_21827_()) {
            return false;
        }
        return !(this.tamable.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tamable.m_21439_(BlockPathTypes.WATER);
        this.tamable.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.tamable.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.tamable.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.tamable.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (!this.tamable.m_21523_() && !this.tamable.m_20159_()) {
                if (this.tamable.m_20280_((Entity)this.owner) >= 144.0) {
                    this.teleportToOwner();
                } else {
                    this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
                }
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockPos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean bl = this.maybeTeleportTo(blockPos.m_123341_() + j, blockPos.m_123342_() + k, blockPos.m_123343_() + l);
            if (!bl) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int i, int j, int k) {
        if (Math.abs((double)i - this.owner.m_20185_()) < 2.0 && Math.abs((double)k - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(i, j, k))) {
            return false;
        }
        this.tamable.m_7678_((double)i + 0.5, (double)j, (double)k + 0.5, this.tamable.m_146908_(), this.tamable.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        BlockPathTypes blockPathTypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
        BlockPos n = new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 1);
        BlockPos s = new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 1);
        BlockPos e = new BlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_());
        BlockPos w = new BlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_());
        BlockPos se = new BlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_() - 1);
        BlockPos sw = new BlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_() - 1);
        BlockPos ne = new BlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_() + 1);
        BlockPos nw = new BlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_() + 1);
        if (blockPathTypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockState = this.level.m_8055_(pos.m_7495_());
        if (!this.canFly && blockState.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos pos2 = pos.m_121996_((Vec3i)this.tamable.m_20183_());
        BlockPos pos3 = n.m_121996_((Vec3i)this.tamable.m_20183_());
        BlockPos pos4 = s.m_121996_((Vec3i)this.tamable.m_20183_());
        BlockPos pos5 = e.m_121996_((Vec3i)this.tamable.m_20183_());
        BlockPos pos6 = w.m_121996_((Vec3i)this.tamable.m_20183_());
        BlockPos pos7 = se.m_121996_((Vec3i)this.tamable.m_20183_());
        BlockPos pos8 = sw.m_121996_((Vec3i)this.tamable.m_20183_());
        BlockPos pos9 = ne.m_121996_((Vec3i)this.tamable.m_20183_());
        BlockPos pos10 = nw.m_121996_((Vec3i)this.tamable.m_20183_());
        return this.level.m_45756_((Entity)this.tamable, this.tamable.m_20191_().m_82338_(pos3)) && this.level.m_45756_((Entity)this.tamable, this.tamable.m_20191_().m_82338_(pos4)) && this.level.m_45756_((Entity)this.tamable, this.tamable.m_20191_().m_82338_(pos5)) && this.level.m_45756_((Entity)this.tamable, this.tamable.m_20191_().m_82338_(pos6)) && this.level.m_45756_((Entity)this.tamable, this.tamable.m_20191_().m_82338_(pos7)) && this.level.m_45756_((Entity)this.tamable, this.tamable.m_20191_().m_82338_(pos8)) && this.level.m_45756_((Entity)this.tamable, this.tamable.m_20191_().m_82338_(pos9)) && this.level.m_45756_((Entity)this.tamable, this.tamable.m_20191_().m_82338_(pos10)) && this.level.m_45756_((Entity)this.tamable, this.tamable.m_20191_().m_82338_(pos2));
    }

    private int randomIntInclusive(int i, int j) {
        return this.tamable.m_217043_().m_188503_(j - i + 1) + i;
    }
}

