/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.block;

import com.ninni.species.registry.SpeciesBlocks;
import com.ninni.species.server.block.property.BoneSpikeThickness;
import com.ninni.species.server.block.property.SpeciesProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BoneSpikeBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.f_155997_;
    public static final EnumProperty<BoneSpikeThickness> THICKNESS = SpeciesProperties.BONE_SPIKE_THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape TIP_SHAPE_UP = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public BoneSpikeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TIP_DIRECTION, (Comparable)Direction.UP)).m_61124_(THICKNESS, (Comparable)((Object)BoneSpikeThickness.TIP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return BoneSpikeBlock.isValidSpikePlacement(levelReader, blockPos, (Direction)blockState.m_61143_((Property)TIP_DIRECTION));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if (direction != Direction.UP && direction != Direction.DOWN) {
            return blockState;
        }
        Direction direction2 = (Direction)blockState.m_61143_((Property)TIP_DIRECTION);
        if (direction2 == Direction.DOWN && levelAccessor.m_183326_().m_183582_(blockPos, (Object)this)) {
            return blockState;
        }
        if (direction == direction2.m_122424_() && !this.m_7898_(blockState, (LevelReader)levelAccessor, blockPos)) {
            if (direction2 == Direction.DOWN) {
                levelAccessor.m_186460_(blockPos, (Block)this, 2);
            } else {
                levelAccessor.m_186460_(blockPos, (Block)this, 1);
            }
            return blockState;
        }
        BoneSpikeThickness BoneSpikeThickness2 = BoneSpikeBlock.calculateBoneSpikeThickness((LevelReader)levelAccessor, blockPos, direction2);
        return (BlockState)blockState.m_61124_(THICKNESS, (Comparable)((Object)BoneSpikeThickness2));
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!this.m_7898_(blockState, (LevelReader)serverLevel, blockPos)) {
            serverLevel.m_46961_(blockPos, true);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockPos blockPos;
        Level levelAccessor = blockPlaceContext.m_43725_();
        Direction direction2 = BoneSpikeBlock.calculateTipDirection((LevelReader)levelAccessor, blockPos = blockPlaceContext.m_8083_(), blockPlaceContext.m_151260_().m_122424_());
        if (direction2 == null) {
            return null;
        }
        BoneSpikeThickness BoneSpikeThickness2 = BoneSpikeBlock.calculateBoneSpikeThickness((LevelReader)levelAccessor, blockPos, direction2);
        if (BoneSpikeThickness2 == null) {
            return null;
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TIP_DIRECTION, (Comparable)direction2)).m_61124_(THICKNESS, (Comparable)((Object)BoneSpikeThickness2))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.m_6425_(blockPos).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(blockState);
    }

    public VoxelShape m_7952_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        BoneSpikeThickness thickness = (BoneSpikeThickness)((Object)blockState.m_61143_(THICKNESS));
        VoxelShape voxelShape = thickness == BoneSpikeThickness.TIP ? (blockState.m_61143_((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (thickness == BoneSpikeThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE);
        Vec3 vec3 = blockState.m_60824_(blockGetter, blockPos);
        return voxelShape.m_83216_(vec3.f_82479_, 0.0, vec3.f_82481_);
    }

    public boolean m_180643_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return false;
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader levelReader, BlockPos blockPos, Direction direction) {
        Direction direction2;
        if (BoneSpikeBlock.isValidSpikePlacement(levelReader, blockPos, direction)) {
            direction2 = direction;
        } else if (BoneSpikeBlock.isValidSpikePlacement(levelReader, blockPos, direction.m_122424_())) {
            direction2 = direction.m_122424_();
        } else {
            return null;
        }
        return direction2;
    }

    private static BoneSpikeThickness calculateBoneSpikeThickness(LevelReader levelReader, BlockPos blockPos, Direction direction) {
        Direction direction2 = direction.m_122424_();
        BlockState blockState = levelReader.m_8055_(blockPos.m_121945_(direction));
        if (BoneSpikeBlock.isBoneSpikeWithDirection(blockState, direction2)) {
            return BoneSpikeThickness.TIP;
        }
        if (!BoneSpikeBlock.isBoneSpikeWithDirection(blockState, direction)) {
            return BoneSpikeThickness.TIP;
        }
        BlockState blockState2 = levelReader.m_8055_(blockPos.m_121945_(direction2));
        if (!BoneSpikeBlock.isBoneSpikeWithDirection(blockState2, direction)) {
            return BoneSpikeThickness.BASE;
        }
        return BoneSpikeThickness.MIDDLE;
    }

    private static boolean isValidSpikePlacement(LevelReader levelReader, BlockPos blockPos, Direction direction) {
        BlockPos blockPos2 = blockPos.m_121945_(direction.m_122424_());
        BlockState blockState = levelReader.m_8055_(blockPos2);
        return blockState.m_60783_((BlockGetter)levelReader, blockPos2, direction) || BoneSpikeBlock.isBoneSpikeWithDirection(blockState, direction);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    private static boolean isBoneSpikeWithDirection(BlockState blockState, Direction direction) {
        return blockState.m_60713_((Block)SpeciesBlocks.BONE_SPIKE.get()) && blockState.m_61143_((Property)TIP_DIRECTION) == direction;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }
}

