/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.mixin;

import com.ninni.species.mixin_util.LivingEntityAccess;
import com.ninni.species.registry.SpeciesEntities;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesNetwork;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesStatusEffects;
import com.ninni.species.server.entity.util.CustomDeathParticles;
import com.ninni.species.server.packet.SnatchedPacket;
import com.ninni.species.server.packet.TankedPacket;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements LivingEntityAccess {
    @OnlyIn(value=Dist.CLIENT)
    @Unique
    private boolean snatched;
    @OnlyIn(value=Dist.CLIENT)
    @Unique
    private boolean tanked;
    @Unique
    private EntityType disguisedEntityType;
    @Unique
    private LivingEntity disguisedEntity;

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    @Shadow
    @Nullable
    public abstract MobEffectInstance m_21124_(MobEffect var1);

    @Shadow
    public abstract RandomSource m_217043_();

    @Shadow
    public abstract ItemStack m_6844_(EquipmentSlot var1);

    public LivingEntityMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Inject(method={"tickEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;updateGlowingStatus()V", ordinal=0)})
    private void onStatusEffectChange(CallbackInfo ci) {
        SpeciesNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new SnatchedPacket(this.m_19879_(), this.m_21023_((MobEffect)SpeciesStatusEffects.SNATCHED.get())));
        SpeciesNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new TankedPacket(this.m_19879_(), this.m_21023_((MobEffect)SpeciesStatusEffects.TANKED.get())));
    }

    @Inject(method={"tickEffects"}, at={@At(value="HEAD")})
    public void applySpeciesEffects(CallbackInfo ci) {
        Level level = this.m_9236_();
        if (this.m_21023_((MobEffect)SpeciesStatusEffects.GUT_FEELING.get())) {
            if (this.m_21124_((MobEffect)SpeciesStatusEffects.GUT_FEELING.get()).m_19557_() < 6000) {
                if (this.m_217043_().m_188503_(200) == 0) {
                    this.m_5496_((SoundEvent)SpeciesSoundEvents.GUT_FEELING_ROAR.get(), 0.2f, 0.0f);
                }
            } else if (this.m_217043_().m_188503_(800) == 0) {
                this.m_5496_((SoundEvent)SpeciesSoundEvents.GUT_FEELING_ROAR.get(), 0.2f, 0.0f);
            }
        }
        if (this.m_21023_((MobEffect)SpeciesStatusEffects.BIRTD.get()) && level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (this.f_19797_ % 10 == 1) {
                world.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.BIRTD.get()), this.m_20185_(), this.m_20188_() + 0.5, this.m_20189_() - 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        ItemStack headItem = this.m_6844_(EquipmentSlot.HEAD);
        CompoundTag tag = headItem.m_41783_();
        if (headItem.m_150930_((Item)SpeciesItems.WICKED_MASK.get())) {
            if (this.getDisguisedEntity() == null || this.getDisguisedEntityType() == null || tag == null || !tag.m_128441_("id") || !this.getDisguisedEntityType().m_147048_().equals(tag.m_128461_("id"))) {
                if (tag != null && tag.m_128441_("id")) {
                    Optional entityType = EntityType.m_20632_((String)tag.m_128461_("id"));
                    if (entityType.isPresent()) {
                        Entity rawEntity = ((EntityType)entityType.get()).m_20615_(this.m_9236_());
                        if (rawEntity instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)rawEntity;
                            living.m_20258_(tag);
                            if (living instanceof Mob) {
                                Mob mob = (Mob)living;
                                mob.m_7378_(tag);
                            }
                            this.setDisguisedEntity(living);
                            this.setDisguisedEntityType((EntityType)entityType.get());
                        } else {
                            this.setDisguisedEntity(null);
                            this.setDisguisedEntityType(null);
                        }
                    }
                } else {
                    this.setDisguisedEntity(null);
                    this.setDisguisedEntityType(null);
                }
            }
        } else if (this.getDisguisedEntity() != null || this.getDisguisedEntityType() != null) {
            this.setDisguisedEntity(null);
            this.setDisguisedEntityType(null);
        }
        if (this.getDisguisedEntity() != null && this.getDisguisedEntity().m_20089_() != this.m_20089_()) {
            this.getDisguisedEntity().m_20124_(this.m_20089_());
        }
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="HEAD")}, cancellable=true)
    public void applyBirtd(CallbackInfo ci) {
        if (this.m_21023_((MobEffect)SpeciesStatusEffects.BIRTD.get()) || this.m_21023_((MobEffect)SpeciesStatusEffects.STUCK.get())) {
            ci.cancel();
        }
    }

    @Inject(method={"makePoofParticles"}, at={@At(value="HEAD")}, cancellable=true)
    public void S$makePoofParticles(CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof CustomDeathParticles) {
            CustomDeathParticles customDeathParticles = (CustomDeathParticles)((Object)livingEntityMixin);
            ci.cancel();
            customDeathParticles.makeDeathParticles();
        }
    }

    @Inject(method={"isPushable"}, at={@At(value="HEAD")}, cancellable=true)
    public void S$isPushable(CallbackInfoReturnable<Boolean> cir) {
        if (this.m_21023_((MobEffect)SpeciesStatusEffects.BIRTD.get()) || this.m_21023_((MobEffect)SpeciesStatusEffects.STUCK.get())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getVisibilityPercent"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetVisibilityPercent(@Nullable Entity observer, CallbackInfoReturnable<Double> cir) {
        LivingEntity self = (LivingEntity)this;
        double visibility = (Double)cir.getReturnValue();
        if (observer == null) {
            return;
        }
        ItemStack headItem = self.m_6844_(EquipmentSlot.HEAD);
        EntityType observerType = observer.m_6095_();
        if (observerType == SpeciesEntities.GHOUL.get() && headItem.m_150930_((Item)SpeciesItems.GHOUL_HEAD.get()) || observerType == SpeciesEntities.WICKED.get() && headItem.m_150930_((Item)SpeciesItems.WICKED_CANDLE.get()) || observerType == SpeciesEntities.BEWEREAGER.get() && headItem.m_150930_((Item)SpeciesItems.BEWEREAGER_HEAD.get()) || observerType == SpeciesEntities.QUAKE.get() && headItem.m_150930_((Item)SpeciesItems.QUAKE_HEAD.get())) {
            cir.setReturnValue((Object)(visibility *= 0.5));
        }
    }

    @Override
    @Unique
    public boolean hasSnatched() {
        return this.snatched;
    }

    @Override
    @Unique
    public void setSnatched(boolean snatched) {
        this.snatched = snatched;
    }

    @Override
    @Unique
    public boolean hasTanked() {
        return this.tanked;
    }

    @Override
    @Unique
    public void setTanked(boolean tanked) {
        this.tanked = tanked;
    }

    @Override
    @Unique
    public EntityType getDisguisedEntityType() {
        return this.disguisedEntityType;
    }

    @Override
    @Unique
    public void setDisguisedEntityType(EntityType disguisedEntityType) {
        this.disguisedEntityType = disguisedEntityType;
    }

    @Override
    @Unique
    public LivingEntity getDisguisedEntity() {
        return this.disguisedEntity;
    }

    @Override
    @Unique
    public void setDisguisedEntity(LivingEntity disguisedEntity) {
        this.disguisedEntity = disguisedEntity;
    }
}

