/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.mixin;

import com.ninni.species.mixin_util.AbstractArrowAccess;
import com.ninni.species.server.item.CrankbowItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin
extends Projectile
implements AbstractArrowAccess {
    @Shadow
    public AbstractArrow.Pickup f_36705_;
    @Unique
    private boolean ignoresImmunityFrame;

    @Shadow
    protected abstract ItemStack m_7941_();

    protected AbstractArrowMixin(EntityType<? extends Projectile> p_37248_, Level p_37249_) {
        super(p_37248_, p_37249_);
    }

    @Inject(at={@At(value="HEAD")}, method={"tryPickup"}, cancellable=true)
    private void S$tryPickup(Player player, CallbackInfoReturnable<Boolean> cir) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof CrankbowItem && CrankbowItem.getContentWeight(stack) < CrankbowItem.getMaxWeight(stack)) {
            cir.cancel();
            switch (this.f_36705_) {
                case ALLOWED: {
                    CrankbowItem.add(stack, this.m_7941_());
                    cir.setReturnValue((Object)true);
                    break;
                }
                case CREATIVE_ONLY: {
                    cir.setReturnValue((Object)player.m_150110_().f_35937_);
                    break;
                }
                default: {
                    cir.setReturnValue((Object)false);
                }
            }
        }
    }

    @Inject(method={"onHitEntity"}, at={@At(value="TAIL")})
    private void S$onHitEntity(EntityHitResult result, CallbackInfo ci) {
        Entity entity;
        if (this.ignoresImmunityFrame && (entity = result.m_82443_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.f_19864_ = true;
            living.f_19802_ = 0;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    private void S$readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        this.ignoresImmunityFrame = tag.m_128471_("IgnoresImmunityFrame");
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    private void S$addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_("IgnoresImmunityFrame", this.ignoresImmunityFrame);
    }

    @Override
    public boolean ignoresImmunityFrame() {
        return this.ignoresImmunityFrame;
    }

    @Override
    public void setTgnoreImmunityFrame(boolean ignore) {
        this.ignoresImmunityFrame = ignore;
    }
}

