/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.ninni.species.registry.SpeciesStatusEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class BloodLustOverlay {
    private static final ResourceLocation SPECIES_ICONS = new ResourceLocation("species", "textures/gui/icons.png");
    private static final ResourceLocation ICONS = new ResourceLocation("textures/gui/icons.png");

    @SubscribeEvent
    public void preGuiRender(RenderGuiOverlayEvent.Pre event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (BloodLustOverlay.shouldRenderBloodLust(player, event.getOverlay())) {
            event.setCanceled(true);
            PoseStack poseStack = event.getGuiGraphics().m_280168_();
            poseStack.m_85836_();
            RenderSystem.enableBlend();
            BloodLustOverlay.renderFood(event.getGuiGraphics(), (Player)player);
            RenderSystem.disableBlend();
            poseStack.m_85849_();
        }
    }

    private static boolean shouldRenderBloodLust(LocalPlayer player, NamedGuiOverlay overlay) {
        return player != null && player.m_21023_((MobEffect)SpeciesStatusEffects.BLOODLUST.get()) && overlay == VanillaGuiOverlay.FOOD_LEVEL.type() && !player.m_7500_() && !player.m_5833_();
    }

    private static void renderFood(GuiGraphics guiGraphics, Player player) {
        Minecraft minecraft = Minecraft.m_91087_();
        Gui gui = minecraft.f_91065_;
        if (!(gui instanceof ForgeGui)) {
            return;
        }
        ForgeGui forgeGui = (ForgeGui)gui;
        minecraft.m_91307_().m_6180_("food");
        RenderSystem.enableBlend();
        int left = guiGraphics.m_280182_() / 2 + 91;
        int top = guiGraphics.m_280206_() - forgeGui.rightHeight;
        forgeGui.rightHeight += 10;
        FoodData stats = minecraft.f_91074_.m_36324_();
        int level = stats.m_38702_();
        for (int i = 0; i < 10; ++i) {
            int idx = i * 2 + 1;
            int x = left - i * 8 - 9;
            int y = top;
            if (player.m_36324_().m_38722_() <= 0.0f && gui.f_92989_ % (level * 3 + 1) == 0) {
                y = top + (gui.f_92985_.m_188503_(3) - 1);
            }
            guiGraphics.m_280218_(ICONS, x, y, 16, 27, 9, 9);
            if (idx < level) {
                guiGraphics.m_280218_(SPECIES_ICONS, x, y, 0, 0, 9, 9);
            }
            if (idx != level) continue;
            guiGraphics.m_280218_(SPECIES_ICONS, x, y, 9, 0, 9, 9);
        }
        RenderSystem.disableBlend();
        minecraft.m_91307_().m_7238_();
    }
}

