/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.renderer.entity.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ninni.species.client.model.mob.update_2.TreeperModel;
import com.ninni.species.server.entity.mob.update_2.Treeper;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;

public class TreeperCanopyLayer
extends RenderLayer<Treeper, TreeperModel<Treeper>> {
    String[][] canopyLayers = new String[][]{{"00000000", "00000000", "00000000", "000LL000", "000LL000", "00000000", "00000000", "00000000"}, {"00000000", "00000000", "000LL000", "00LLLL00", "00LLLL00", "000LL000", "00000000", "00000000"}, {"00000000", "00LLLL00", "0LLLLLL0", "0LLLLLL0", "0LLLLLL0", "0LLLLLL0", "00LLLL00", "00000000"}, {"00LLLL00", "0LLLLLL0", "LLLLLLLL", "LLLLLLLL", "LLLLLLLL", "LLLLLLLL", "0LLLLLL0", "00LLLL00"}, {"00000000", "00LLLL00", "0LLLLLL0", "0LLLLLL0", "0LLLLLL0", "0LLLLLL0", "00LLLL00", "00000000"}, {"0LLLLLL0", "LLLLLLLL", "LLLLLLLL", "LLLLLLLL", "LLLLLLLL", "LLLLLLLL", "LLLLLLLL", "0LLLLLL0"}};

    public TreeperCanopyLayer(RenderLayerParent<Treeper, TreeperModel<Treeper>> parent) {
        super(parent);
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int packedLight, Treeper entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        stack.m_85836_();
        ((TreeperModel)this.m_117386_()).m_142109_().m_104299_(stack);
        ((TreeperModel)this.m_117386_()).getTrunk().m_104299_(stack);
        ((TreeperModel)this.m_117386_()).getCanopy().m_104299_(stack);
        stack.m_85837_(0.0, -5.5, 0.0);
        BlockState state = Blocks.f_50051_.m_49966_();
        this.renderCanopy(entity, stack, buffer, state, partialTick);
        stack.m_85849_();
    }

    private void renderCanopy(Treeper entity, PoseStack poseStack, MultiBufferSource buffer, BlockState state, float partialTick) {
        for (int y = 0; y < this.canopyLayers.length; ++y) {
            String[] layer = this.canopyLayers[y];
            for (int z = 0; z < layer.length; ++z) {
                char[] row = layer[z].toCharArray();
                for (int x = 0; x < row.length; ++x) {
                    if (row[x] != 'L') continue;
                    poseStack.m_85836_();
                    int dx = x - 4;
                    int dz = z - 4;
                    poseStack.m_252880_((float)dx, (float)y, (float)dz);
                    poseStack.m_85841_(-1.0f, -1.01f, 1.0f);
                    poseStack.m_252880_(-1.0f, -0.999f, 0.0f);
                    float bodyRotLerp = Mth.m_14189_((float)partialTick, (float)entity.f_20884_, (float)entity.f_20883_);
                    float yawRad = bodyRotLerp * ((float)Math.PI / 180);
                    Vec3 rotatedOffset = new Vec3((double)dx, 0.0, (double)dz).m_82524_(yawRad);
                    double worldX = entity.m_20185_() + rotatedOffset.f_82479_ + 0.5;
                    double worldY = entity.m_20186_() + (double)(this.canopyLayers.length - 1 - y) + 7.5 + (double)(entity.isPlanted() ? 0.0f : 0.95f);
                    double worldZ = entity.m_20189_() - rotatedOffset.f_82481_ - 0.5;
                    BlockPos lightPos = BlockPos.m_274561_((double)worldX, (double)worldY, (double)worldZ);
                    int light = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_9236_(), (BlockPos)lightPos);
                    RenderType renderType = Minecraft.m_91087_().f_91066_.m_232060_().m_231551_() == GraphicsStatus.FAST ? RenderType.m_110451_() : RenderType.m_110457_();
                    BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
                    ModelBlockRenderer renderer = Minecraft.m_91087_().m_91289_().m_110937_();
                    renderer.tesselateBlock((BlockAndTintGetter)entity.m_9236_(), model, state, lightPos, poseStack, buffer.m_6299_(renderType), false, RandomSource.m_216327_(), 42L, light, ModelData.EMPTY, renderType);
                    poseStack.m_85849_();
                }
            }
        }
    }
}

