/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ninni.species.client.model.mob.update_2.TrooperModel;
import com.ninni.species.registry.SpeciesEntityModelLayers;
import com.ninni.species.server.entity.mob.update_2.Trooper;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TrooperRenderer<T extends LivingEntity>
extends MobRenderer<Trooper, TrooperModel<Trooper>> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("species", "textures/entity/treeper/trooper.png");
    public static final ResourceLocation TAMED_TEXTURE = new ResourceLocation("species", "textures/entity/treeper/trooper_tame.png");

    public TrooperRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new TrooperModel(ctx.m_174023_(SpeciesEntityModelLayers.TROOPER)), 0.3f);
    }

    public void scale(Trooper creeper, PoseStack poseStack, float f) {
        float g = creeper.getSwelling(f);
        float h = 1.0f + Mth.m_14031_((float)(g * 100.0f)) * g * 0.01f;
        g = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
        g *= g;
        g *= g;
        float i = (1.0f + g * 0.4f) * h;
        float j = (1.0f + g * 0.1f) / h;
        poseStack.m_85841_(i, j, i);
    }

    public float getWhiteOverlayProgress(Trooper creeper, float f) {
        float g = creeper.getSwelling(f);
        if ((int)(g * 10.0f) % 2 == 0) {
            return 0.0f;
        }
        return Mth.m_14036_((float)g, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(Trooper entity) {
        return entity.m_21824_() ? TAMED_TEXTURE : TEXTURE;
    }
}

