/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.species.registry.SpeciesEntityModelLayers;
import com.ninni.species.server.entity.mob.update_3.Coil;
import java.util.ArrayList;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;

public class CoilRenderer
extends EntityRenderer<Coil> {
    private final ModelPart coilKnot;
    private final ModelPart coil;
    public static final ResourceLocation TEXTURE_KNOT = new ResourceLocation("species", "textures/entity/hanger/coil/coil_knot.png");
    public static final ResourceLocation TEXTURE = new ResourceLocation("species", "textures/entity/hanger/coil/coil.png");
    public static final ResourceLocation TEXTURE_ROPE = new ResourceLocation("species", "textures/entity/hanger/coil/coil_rope.png");

    public CoilRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart modelPart = context.m_174023_(SpeciesEntityModelLayers.COIL);
        this.coil = modelPart.m_171324_("knot");
        ModelPart modelPartKnot = context.m_174023_(SpeciesEntityModelLayers.COIL_KNOT);
        this.coilKnot = modelPartKnot.m_171324_("knot");
    }

    public ResourceLocation getTextureLocation(Coil coil) {
        return coil.isKnot() ? TEXTURE_KNOT : TEXTURE;
    }

    public void render(Coil entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, buffer, packedLight);
        Direction direction2 = Math.abs(entity.m_146909_()) > 45.0f ? (entity.m_146909_() > 0.0f ? Direction.DOWN : Direction.UP) : Direction.m_122364_((double)entity.m_146908_());
        Vec3 offset = Vec3.m_82528_((Vec3i)direction2.m_122436_()).m_82490_(0.125);
        BlockPos lightSamplePos = BlockPos.m_274446_((Position)entity.m_20182_().m_82549_(offset));
        int startLight = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_9236_(), (BlockPos)lightSamplePos);
        if (entity.isKnot()) {
            poseStack.m_85836_();
            knotBuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
            poseStack.m_85841_(1.01f, 1.01f, 1.01f);
            poseStack.m_252880_(0.0f, -1.0f, 0.0f);
            this.coilKnot.m_104306_(poseStack, knotBuilder, startLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, entity.isBeingPlaced() ? 0.5f : 1.0f);
            poseStack.m_85849_();
        } else {
            poseStack.m_85836_();
            knotBuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
            poseStack.m_85841_(1.01f, 1.01f, 1.01f);
            poseStack.m_85837_(0.0, -1.375, 0.0);
            this.coil.m_104306_(poseStack, knotBuilder, startLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, entity.isBeingPlaced() ? 0.5f : 1.0f);
            poseStack.m_85849_();
        }
        Coil endPoint = entity.getEndPoint();
        if (!entity.isStartPoint() && endPoint != null) {
            Direction direction3 = Math.abs(endPoint.m_146909_()) > 45.0f ? (endPoint.m_146909_() > 0.0f ? Direction.DOWN : Direction.UP) : Direction.m_122364_((double)endPoint.m_146908_());
            Vec3 offset2 = Vec3.m_82528_((Vec3i)direction3.m_122436_()).m_82490_(0.125);
            BlockPos lightSamplePos2 = BlockPos.m_274446_((Position)endPoint.m_20182_().m_82549_(offset2));
            int endLight = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_9236_(), (BlockPos)lightSamplePos2);
            int avgPackedLight = CoilRenderer.averagePackedLight(startLight, endLight);
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE_ROPE));
            Vec3 start = entity.m_20191_().m_82399_().m_82546_(entity.m_20182_());
            Vec3 end = endPoint.m_20191_().m_82399_().m_82546_(entity.m_20182_());
            int looseness = entity.getLooseness();
            float distance = (float)start.m_82554_(end);
            float sag = distance * 0.1f * (float)looseness;
            Vec3 middle = start.m_82549_(end).m_82490_(0.5).m_82520_(0.0, (double)(-sag), 0.0);
            Vec3 direction = end.m_82546_(start).m_82541_();
            Vec3 up = Math.abs(direction.f_82480_) < 0.9 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
            Vec3 right = direction.m_82537_(up).m_82541_().m_82490_(0.2);
            Vec3 forward = direction.m_82537_(right).m_82541_().m_82490_(0.2);
            poseStack.m_85836_();
            int segments = Math.min(24, (int)(distance * 2.0f));
            ArrayList<Vec3> curve = new ArrayList<Vec3>();
            for (int i = 0; i <= segments; ++i) {
                float t = (float)i / (float)segments;
                curve.add(this.quadraticBezier(start, middle, end, t));
            }
            float accumulatedV = 0.0f;
            for (int i = 0; i < curve.size() - 1; ++i) {
                Vec3 p0 = (Vec3)curve.get(i);
                Vec3 p1 = (Vec3)curve.get(i + 1);
                float nextV = accumulatedV + (float)p0.m_82554_(p1);
                this.drawCoilQuad(poseStack, builder, p0, p1, right, accumulatedV, nextV, avgPackedLight);
                this.drawCoilQuad(poseStack, builder, p0, p1, forward, accumulatedV, nextV, avgPackedLight);
                accumulatedV = nextV;
            }
            poseStack.m_85849_();
        }
    }

    private static int averagePackedLight(int a, int b) {
        int blockA = a & 0xFFFF;
        int skyA = a >> 20 & 0xFFFF;
        int blockB = b & 0xFFFF;
        int skyB = b >> 20 & 0xFFFF;
        int block = (blockA + blockB) / 2;
        int sky = (skyA + skyB) / 2;
        return sky << 20 | block;
    }

    private Vec3 quadraticBezier(Vec3 p0, Vec3 p1, Vec3 p2, float t) {
        double it = 1.0f - t;
        return p0.m_82490_(it * it).m_82549_(p1.m_82490_(2.0 * it * (double)t)).m_82549_(p2.m_82490_((double)(t * t)));
    }

    private void drawCoilQuad(PoseStack poseStack, VertexConsumer builder, Vec3 base, Vec3 tip, Vec3 side, float vStart, float vEnd, int packedLight) {
        PoseStack.Pose pose = poseStack.m_85850_();
        builder.m_252986_(pose.m_252922_(), (float)(base.f_82479_ + side.f_82479_), (float)(base.f_82480_ + side.f_82480_), (float)(base.f_82481_ + side.f_82481_)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, vStart).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), (float)(base.f_82479_ - side.f_82479_), (float)(base.f_82480_ - side.f_82480_), (float)(base.f_82481_ - side.f_82481_)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, vStart).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), (float)(tip.f_82479_ - side.f_82479_), (float)(tip.f_82480_ - side.f_82480_), (float)(tip.f_82481_ - side.f_82481_)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, vEnd).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), (float)(tip.f_82479_ + side.f_82479_), (float)(tip.f_82480_ + side.f_82480_), (float)(tip.f_82481_ + side.f_82481_)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, vEnd).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public boolean shouldRender(Coil entity, Frustum frustum, double v, double v1, double v2) {
        if (!entity.isStartPoint() && entity.getEndPoint() != null) {
            return true;
        }
        return super.m_5523_((Entity)entity, frustum, v, v1, v2);
    }

    public static LayerDefinition createKnotBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("knot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -4.0f, -3.0f, 6.0f, 8.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("knot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)16, (int)16);
    }
}

