/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.particles;

import com.ninni.species.registry.SpeciesParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class DripParticle
extends TextureSheetParticle {
    private final SpriteSet spriteProvider;
    private final boolean glowing;

    public DripParticle(ClientLevel clientLevel, double d, double e, double f, SpriteSet spriteProvider, boolean glowing) {
        super(clientLevel, d, e, f);
        this.m_107250_(0.01f, 0.01f);
        this.f_107226_ = 0.06f;
        this.glowing = glowing;
        this.spriteProvider = spriteProvider;
        this.m_108339_(spriteProvider);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    protected int m_6355_(float f) {
        if (this.glowing) {
            return 240;
        }
        BlockPos blockPos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        if (this.f_107208_.m_46805_(blockPos)) {
            return LevelRenderer.m_109541_((BlockAndTintGetter)this.f_107208_, (BlockPos)blockPos);
        }
        return super.m_6355_(f);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.preMoveUpdate();
        if (this.f_107220_) {
            return;
        }
        this.f_107216_ -= (double)this.f_107226_;
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        this.postMoveUpdate();
        if (this.f_107220_) {
            return;
        }
        this.f_107215_ *= (double)0.98f;
        this.f_107216_ *= (double)0.98f;
        this.f_107217_ *= (double)0.98f;
    }

    protected void preMoveUpdate() {
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
    }

    protected void postMoveUpdate() {
    }

    public record HangerSalivaLandProvider(SpriteSet spriteSet) implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double d, double e, double f, double v3, double v4, double v5) {
            DripLandParticle dripParticle = new DripLandParticle(clientLevel, d, e, f, this.spriteSet, false);
            ((DripParticle)dripParticle).f_107225_ = (int)(28.0 / (Math.random() * 0.8 + 0.2));
            dripParticle.m_107253_(0.282f, 0.204f, 0.153f);
            return dripParticle;
        }
    }

    public record HangerSalivaFallProvider(SpriteSet spriteSet) implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double d, double e, double f, double v3, double v4, double v5) {
            FallAndLandParticle dripParticle = new FallAndLandParticle(clientLevel, d, e, f, (ParticleOptions)SpeciesParticles.LANDING_HANGER_SALIVA.get(), this.spriteSet, false);
            ((DripParticle)dripParticle).f_107226_ = 0.01f;
            dripParticle.m_107253_(0.282f, 0.204f, 0.153f);
            return dripParticle;
        }
    }

    public record HangerSalivaHangProvider(SpriteSet spriteSet) implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double d, double e, double f, double v3, double v4, double v5) {
            DripHangParticle dripHangParticle = new DripHangParticle(clientLevel, d, e, f, (ParticleOptions)SpeciesParticles.FALLING_HANGER_SALIVA.get(), this.spriteSet, false);
            ((DripParticle)dripHangParticle).f_107226_ *= 0.01f;
            ((DripParticle)dripHangParticle).f_107225_ = 100;
            dripHangParticle.m_107253_(0.282f, 0.204f, 0.153f);
            return dripHangParticle;
        }
    }

    public record PelletDripLandProvider(SpriteSet spriteSet) implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double d, double e, double f, double v3, double v4, double v5) {
            DripLandParticle dripParticle = new DripLandParticle(clientLevel, d, e, f, this.spriteSet, true);
            ((DripParticle)dripParticle).f_107225_ = (int)(28.0 / (Math.random() * 0.8 + 0.2));
            dripParticle.m_107253_(0.0784f, 0.86f, 0.98f);
            return dripParticle;
        }
    }

    public record PelletDripFallProvider(SpriteSet spriteSet) implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double d, double e, double f, double v3, double v4, double v5) {
            FallAndLandParticle dripParticle = new FallAndLandParticle(clientLevel, d, e, f, (ParticleOptions)SpeciesParticles.LANDING_PELLET_DRIP.get(), this.spriteSet, true);
            ((DripParticle)dripParticle).f_107226_ = 0.01f;
            dripParticle.m_107253_(0.0784f, 0.86f, 0.98f);
            return dripParticle;
        }
    }

    public record PelletDripHangProvider(SpriteSet spriteSet) implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double d, double e, double f, double v3, double v4, double v5) {
            DripHangParticle dripHangParticle = new DripHangParticle(clientLevel, d, e, f, (ParticleOptions)SpeciesParticles.FALLING_PELLET_DRIP.get(), this.spriteSet, true);
            ((DripParticle)dripHangParticle).f_107226_ *= 0.01f;
            ((DripParticle)dripHangParticle).f_107225_ = 100;
            dripHangParticle.m_107253_(0.0784f, 0.86f, 0.98f);
            return dripHangParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FallingParticle
    extends DripParticle {
        FallingParticle(ClientLevel clientLevel, double d, double e, double f, SpriteSet spriteSet, boolean glowing) {
            this(clientLevel, d, e, f, (int)(64.0 / (Math.random() * 0.8 + 0.2)), spriteSet, glowing);
        }

        FallingParticle(ClientLevel clientLevel, double d, double e, double f, int i, SpriteSet spriteSet, boolean glowing) {
            super(clientLevel, d, e, f, spriteSet, glowing);
            this.f_107225_ = i;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DripLandParticle
    extends DripParticle {
        DripLandParticle(ClientLevel clientLevel, double d, double e, double f, SpriteSet spriteSet, boolean glowing) {
            super(clientLevel, d, e, f, spriteSet, glowing);
            this.f_107225_ = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FallAndLandParticle
    extends FallingParticle {
        protected final ParticleOptions landParticle;
        private final boolean glowing;

        FallAndLandParticle(ClientLevel clientLevel, double d, double e, double f, ParticleOptions particleOptions, SpriteSet spriteSet, boolean glowing) {
            super(clientLevel, d, e, f, spriteSet, false);
            this.landParticle = particleOptions;
            this.glowing = glowing;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.landParticle, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DripHangParticle
    extends DripParticle {
        private final ParticleOptions fallingParticle;
        private final boolean glowing;

        DripHangParticle(ClientLevel clientLevel, double d, double e, double f, ParticleOptions particleOptions, SpriteSet spriteSet, boolean glowing) {
            super(clientLevel, d, e, f, spriteSet, glowing);
            this.fallingParticle = particleOptions;
            this.f_107226_ *= 0.02f;
            this.f_107225_ = 40;
            this.glowing = glowing;
        }

        @Override
        protected void preMoveUpdate() {
            if (this.f_107225_-- <= 0) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.fallingParticle, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_, this.f_107216_, this.f_107217_);
            }
        }

        @Override
        protected void postMoveUpdate() {
            this.f_107215_ *= 0.02;
            this.f_107216_ *= 0.02;
            this.f_107217_ *= 0.02;
        }
    }
}

