/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.model.mob.update_2;

import com.google.common.collect.ImmutableList;
import com.ninni.species.client.animation.CruncherAnimations;
import com.ninni.species.server.entity.mob.update_2.Cruncher;
import java.util.List;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CruncherModel<T extends Cruncher>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart rightFrontLeg;
    private final ModelPart rightBackLeg;
    private final ModelPart leftBackLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart tail;
    private final ModelPart head;
    private final ModelPart jaw;

    public CruncherModel(ModelPart root) {
        this.root = root;
        this.all = root.m_171324_("all");
        this.body = this.all.m_171324_("body");
        this.rightFrontLeg = this.all.m_171324_("rightFrontLeg");
        this.rightBackLeg = this.all.m_171324_("rightBackLeg");
        this.leftBackLeg = this.all.m_171324_("leftBackLeg");
        this.leftFrontLeg = this.all.m_171324_("leftFrontLeg");
        this.tail = this.body.m_171324_("tail");
        this.head = this.body.m_171324_("head");
        this.leftArm = this.body.m_171324_("leftArm");
        this.rightArm = this.body.m_171324_("rightArm");
        this.jaw = this.head.m_171324_("jaw");
    }

    public void setupAnim(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_267799_(CruncherAnimations.WALK, limbAngle, limbDistance, 2.0f, 2.0f);
        this.m_233381_(((Cruncher)((Object)entity)).stunAnimationState, CruncherAnimations.STUN, animationProgress);
        this.m_233381_(((Cruncher)((Object)entity)).idleAnimationState, CruncherAnimations.IDLE, animationProgress);
        this.m_233381_(((Cruncher)((Object)entity)).spitAnimationState, CruncherAnimations.SPIT, animationProgress);
        this.m_233381_(((Cruncher)((Object)entity)).roarAnimationState, CruncherAnimations.ROAR, animationProgress);
        this.m_233381_(((Cruncher)((Object)entity)).attackAnimationState, CruncherAnimations.STOMP, animationProgress);
        this.head.f_104203_ += headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ += headYaw * ((float)Math.PI / 180);
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.5f, (float)0.5f));
        PartDefinition body = all.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-13.5f, -15.5f, -16.0f, 27.0f, 31.0f, 32.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-30.0f, (float)-0.5f));
        PartDefinition rightFrontLeg = all.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(3, 143).m_171480_().m_171488_(-6.5f, -1.0f, -7.0f, 12.0f, 19.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(58, 71).m_171480_().m_171488_(-6.5f, 15.0f, -10.0f, 12.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(119, 56).m_171480_().m_171488_(-6.4375f, 14.9375f, -10.25f, 12.0f, 3.0f, 3.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171419_((float)-11.0f, (float)-18.5f, (float)-13.5f));
        PartDefinition rightBackLeg = all.m_171599_("rightBackLeg", CubeListBuilder.m_171558_().m_171514_(3, 143).m_171480_().m_171488_(-6.5f, -1.0f, -7.0f, 12.0f, 19.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(58, 71).m_171480_().m_171488_(-6.5f, 15.0f, -10.0f, 12.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(119, 56).m_171480_().m_171488_(-6.4375f, 14.9375f, -10.25f, 12.0f, 3.0f, 3.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171419_((float)-11.0f, (float)-18.5f, (float)15.5f));
        PartDefinition leftBackLeg = all.m_171599_("leftBackLeg", CubeListBuilder.m_171558_().m_171514_(3, 143).m_171488_(-5.5f, -1.0f, -7.0f, 12.0f, 19.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(58, 71).m_171488_(-5.5f, 15.0f, -10.0f, 12.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(119, 56).m_171488_(-5.5625f, 14.9375f, -10.25f, 12.0f, 3.0f, 3.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)11.0f, (float)-18.5f, (float)15.5f));
        PartDefinition leftFrontLeg = all.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(3, 143).m_171488_(-5.5f, -1.0f, -7.0f, 12.0f, 19.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(58, 71).m_171488_(-5.5f, 15.0f, -10.0f, 12.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(119, 56).m_171488_(-5.5625f, 14.9375f, -10.25f, 12.0f, 3.0f, 3.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)11.0f, (float)-18.5f, (float)-13.5f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(88, 63).m_171488_(-7.75f, -24.0f, -10.25f, 16.0f, 30.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(156, 163).m_171488_(-5.75f, -24.0f, -22.25f, 12.0f, 10.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(120, 175).m_171488_(-5.75f, -14.0f, -22.25f, 12.0f, 5.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-2.75f, -33.0f, -22.25f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(152, 74).m_171488_(-16.25f, -41.0f, -0.25f, 33.0f, 21.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(114, 157).m_171488_(-12.25f, -36.0f, -0.25f, 25.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.25f, (float)-3.5f, (float)-11.75f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(136, 50).m_171488_(-9.25f, -8.5f, -18.5f, 19.0f, 10.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(138, 95).m_171488_(-9.25f, 1.5f, -18.5f, 19.0f, 11.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(58, 148).m_171488_(-9.25f, -1.5f, -4.5f, 19.0f, 14.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-15.5f, (float)-6.5f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(160, 120).m_171488_(0.0f, 0.0f, -10.0f, 12.0f, 4.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)13.5f, (float)-4.5f, (float)-13.0f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(160, 120).m_171480_().m_171488_(-12.0f, 0.0f, -10.0f, 12.0f, 4.0f, 14.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-13.5f, (float)-3.75f, (float)-13.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 63).m_171488_(-6.5f, -7.5f, -4.0f, 13.0f, 15.0f, 30.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)17.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public List<ModelPart> getAllParts() {
        return ImmutableList.of((Object)this.all);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

