/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.events;

import com.mojang.blaze3d.platform.InputConstants;
import com.ninni.species.Species;
import com.ninni.species.client.events.ClientEventsHandler;
import com.ninni.species.client.model.mob.update_1.BirtModel;
import com.ninni.species.client.model.mob.update_1.DeepfishModel;
import com.ninni.species.client.model.mob.update_1.LimpetModel;
import com.ninni.species.client.model.mob.update_1.StackatickModel;
import com.ninni.species.client.model.mob.update_1.WraptorModel;
import com.ninni.species.client.model.mob.update_2.CruncherModel;
import com.ninni.species.client.model.mob.update_2.GooberGooModel;
import com.ninni.species.client.model.mob.update_2.GooberModel;
import com.ninni.species.client.model.mob.update_2.MammutilationModel;
import com.ninni.species.client.model.mob.update_2.SpringlingModel;
import com.ninni.species.client.model.mob.update_2.TreeperModel;
import com.ninni.species.client.model.mob.update_2.TrooperModel;
import com.ninni.species.client.model.mob.update_3.BewereagerModel;
import com.ninni.species.client.model.mob.update_3.DeflectorDummyModel;
import com.ninni.species.client.model.mob.update_3.GhoulModel;
import com.ninni.species.client.model.mob.update_3.HangerModel;
import com.ninni.species.client.model.mob.update_3.QuakeModel;
import com.ninni.species.client.model.mob.update_3.SpectreModel;
import com.ninni.species.client.model.mob.update_3.WickedModel;
import com.ninni.species.client.model.mob_heads.BewereagerHeadModel;
import com.ninni.species.client.model.mob_heads.GhoulHeadModel;
import com.ninni.species.client.model.mob_heads.QuakeHeadModel;
import com.ninni.species.client.model.mob_heads.WickedHeadModel;
import com.ninni.species.client.particles.AscendingDustParticle;
import com.ninni.species.client.particles.AscendingSpectreParticle;
import com.ninni.species.client.particles.BewereagerHowlParticle;
import com.ninni.species.client.particles.BewereagerParticle;
import com.ninni.species.client.particles.BrokenLinkParticle;
import com.ninni.species.client.particles.DripParticle;
import com.ninni.species.client.particles.GhoulSearchParticle;
import com.ninni.species.client.particles.HangerCritParticle;
import com.ninni.species.client.particles.IchorBottleParticle;
import com.ninni.species.client.particles.IchorParticle;
import com.ninni.species.client.particles.KineticEnergyParticle;
import com.ninni.species.client.particles.PoofParticle;
import com.ninni.species.client.particles.RotatingParticle;
import com.ninni.species.client.particles.SnoringParticle;
import com.ninni.species.client.particles.SpectraliburParticle;
import com.ninni.species.client.particles.SpectraliburReleasedParticle;
import com.ninni.species.client.particles.SpectrePopParticle;
import com.ninni.species.client.particles.SpectreSmokeParticle;
import com.ninni.species.client.particles.TreeperLeafParticle;
import com.ninni.species.client.particles.WickedEmberParticle;
import com.ninni.species.client.renderer.block.BirtdayCakeBlockEntityRenderer;
import com.ninni.species.client.renderer.block.ChaindelierBlockEntityRenderer;
import com.ninni.species.client.renderer.block.HopelightBlockEntityRenderer;
import com.ninni.species.client.renderer.block.MobHeadBlockEntityRenderer;
import com.ninni.species.client.renderer.block.SpeclightBlockEntityRenderer;
import com.ninni.species.client.renderer.block.SpectraliburPedestalBlockEntityRenderer;
import com.ninni.species.client.renderer.entity.BewereagerRenderer;
import com.ninni.species.client.renderer.entity.BirtRenderer;
import com.ninni.species.client.renderer.entity.CliffHangerRenderer;
import com.ninni.species.client.renderer.entity.CoilRenderer;
import com.ninni.species.client.renderer.entity.CruncherRenderer;
import com.ninni.species.client.renderer.entity.DeepfishRenderer;
import com.ninni.species.client.renderer.entity.DeflectorDummyRenderer;
import com.ninni.species.client.renderer.entity.GhoulRenderer;
import com.ninni.species.client.renderer.entity.GooberGooRenderer;
import com.ninni.species.client.renderer.entity.GooberRenderer;
import com.ninni.species.client.renderer.entity.LeafHangerRenderer;
import com.ninni.species.client.renderer.entity.LimpetRenderer;
import com.ninni.species.client.renderer.entity.MammutilationRenderer;
import com.ninni.species.client.renderer.entity.QuakeRenderer;
import com.ninni.species.client.renderer.entity.SpectreRenderer;
import com.ninni.species.client.renderer.entity.SpringlingRenderer;
import com.ninni.species.client.renderer.entity.StackatickRenderer;
import com.ninni.species.client.renderer.entity.TreeperRenderer;
import com.ninni.species.client.renderer.entity.TrooperRenderer;
import com.ninni.species.client.renderer.entity.WickedRenderer;
import com.ninni.species.client.renderer.entity.WraptorRenderer;
import com.ninni.species.client.renderer.item.HarpoonRenderer;
import com.ninni.species.client.renderer.item.WickedFireballRenderer;
import com.ninni.species.client.renderer.item.WickedSwapperProjectileRenderer;
import com.ninni.species.client.screen.BloodLustOverlay;
import com.ninni.species.client.screen.ScreenShakeEvent;
import com.ninni.species.mixin_util.PlayerAccess;
import com.ninni.species.registry.SpeciesBlockEntities;
import com.ninni.species.registry.SpeciesBlocks;
import com.ninni.species.registry.SpeciesCreativeModeTabs;
import com.ninni.species.registry.SpeciesEnchantments;
import com.ninni.species.registry.SpeciesEntities;
import com.ninni.species.registry.SpeciesEntityModelLayers;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesKeyMappings;
import com.ninni.species.registry.SpeciesNetwork;
import com.ninni.species.registry.SpeciesPaintingVariants;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesPotions;
import com.ninni.species.server.entity.mob.update_2.Springling;
import com.ninni.species.server.entity.mob.update_3.Harpoon;
import com.ninni.species.server.item.SpectreLightBlockItem;
import com.ninni.species.server.packet.HarpoonInputPacket;
import com.ninni.species.server.packet.UpdateSpringlingDataPacket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.FallingBlockRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterEntitySpectatorShadersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="species", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    private static final ResourceLocation SPECIES_ICONS = new ResourceLocation("species", "textures/gui/icons.png");
    public static final List<ScreenShakeEvent> SCREEN_SHAKE_EVENTS = new ArrayList<ScreenShakeEvent>();
    private static float shakeAmount;
    private static float prevShakeAmount;
    static float smoothPitch;
    static float smoothRoll;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(clientTickEvent -> {
            Springling springling;
            Entity patt3712$temp;
            Minecraft client = Minecraft.m_91087_();
            LocalPlayer player = client.f_91074_;
            if (player != null && (patt3712$temp = player.m_20202_()) instanceof Springling && !(springling = (Springling)patt3712$temp).isRetracting()) {
                float extendedAmount = springling.getExtendedAmount();
                if (!SpeciesKeyMappings.RETRACT_KEY.m_90857_() && !springling.m_9236_().m_8055_(player.m_20183_().m_7494_()).m_280296_() && !springling.m_9236_().m_8055_(player.m_20183_().m_6630_(2)).m_280296_() && SpeciesKeyMappings.EXTEND_KEY.m_90857_()) {
                    SpeciesNetwork.INSTANCE.sendToServer((Object)new UpdateSpringlingDataPacket(0.1f, extendedAmount < (float)springling.getMaxExtendedAmount()));
                }
                if (SpeciesKeyMappings.RETRACT_KEY.m_90857_() && !SpeciesKeyMappings.EXTEND_KEY.m_90857_()) {
                    SpeciesNetwork.INSTANCE.sendToServer((Object)new UpdateSpringlingDataPacket(-0.25f, extendedAmount > 0.0f));
                }
            }
        });
        Species.CALLBACKS.forEach(Runnable::run);
        Species.CALLBACKS.clear();
        eventBus.register((Object)new BloodLustOverlay());
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.END) {
            Entity cameraEntity = mc.m_91288_();
            prevShakeAmount = shakeAmount;
            float shake = 0.0f;
            Iterator<ScreenShakeEvent> groundShakeMomentIterator = SCREEN_SHAKE_EVENTS.iterator();
            while (groundShakeMomentIterator.hasNext()) {
                ScreenShakeEvent groundShakeMoment = groundShakeMomentIterator.next();
                groundShakeMoment.tick();
                if (groundShakeMoment.isDone()) {
                    groundShakeMomentIterator.remove();
                    continue;
                }
                shake = Math.max(shake, groundShakeMoment.getDegree(cameraEntity, 1.0f));
            }
            shakeAmount = shake * ((Double)mc.f_91066_.m_231924_().m_231551_()).floatValue();
        }
        if (mc.f_91074_ != null && mc.f_91073_ != null && event.phase == TickEvent.Phase.END) {
            LocalPlayer localPlayer;
            InputConstants.Key keyForward = mc.f_91066_.f_92085_.getKey();
            InputConstants.Key keyBack = mc.f_91066_.f_92087_.getKey();
            InputConstants.Key keyLeft = mc.f_91066_.f_92086_.getKey();
            InputConstants.Key keyRight = mc.f_91066_.f_92088_.getKey();
            InputConstants.Key jump = mc.f_91066_.f_92089_.getKey();
            InputConstants.Key sneak = mc.f_91066_.f_92090_.getKey();
            long window = mc.m_91268_().m_85439_();
            boolean forward = ClientEventsHandler.isValidKey(keyForward) && InputConstants.m_84830_((long)window, (int)keyForward.m_84873_());
            boolean back = ClientEventsHandler.isValidKey(keyBack) && InputConstants.m_84830_((long)window, (int)keyBack.m_84873_());
            boolean left = ClientEventsHandler.isValidKey(keyLeft) && InputConstants.m_84830_((long)window, (int)keyLeft.m_84873_());
            boolean right = ClientEventsHandler.isValidKey(keyRight) && InputConstants.m_84830_((long)window, (int)keyRight.m_84873_());
            boolean jumpKeyDown = ClientEventsHandler.isValidKey(jump) && InputConstants.m_84830_((long)window, (int)jump.m_84873_());
            boolean sneakKeyDown = ClientEventsHandler.isValidKey(sneak) && InputConstants.m_84830_((long)window, (int)sneak.m_84873_());
            float x = (right ? 1 : 0) - (left ? 1 : 0);
            float z = (forward ? 1 : 0) - (back ? 1 : 0);
            float y = (jumpKeyDown ? 1 : 0) - (sneakKeyDown ? 1 : 0);
            if (mc.f_91074_.m_6117_() && mc.f_91074_.m_21211_().m_150930_((Item)SpeciesItems.HARPOON.get()) && (localPlayer = mc.f_91074_) instanceof PlayerAccess) {
                PlayerAccess playerAccess = (PlayerAccess)localPlayer;
                SpeciesNetwork.INSTANCE.sendToServer((Object)new HarpoonInputPacket(playerAccess.getHarpoonId(), x, y, z));
            }
        }
    }

    @SubscribeEvent
    public void computeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        Harpoon harpoon;
        PlayerAccess access;
        Entity harpoonEntity;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        float partialTicks = (float)event.getPartialTick();
        float lerpedShakeAmount = Mth.m_14036_((float)(prevShakeAmount + (shakeAmount - prevShakeAmount) * partialTicks), (float)0.0f, (float)4.0f);
        if (lerpedShakeAmount > 0.0f) {
            float time = mc.f_91075_ == null ? 0.0f : (float)mc.f_91075_.f_19797_ + mc.getPartialTick();
            event.setRoll((float)((double)lerpedShakeAmount * Math.sin(2.0f * time)));
        }
        float targetPitch = 0.0f;
        float targetRoll = 0.0f;
        if (player instanceof PlayerAccess && (harpoonEntity = mc.f_91073_.m_6815_((access = (PlayerAccess)player).getHarpoonId())) instanceof Harpoon && (harpoon = (Harpoon)harpoonEntity).isAnchored() && harpoon.getAnchorPos() != null) {
            Vec3 anchor = Vec3.m_82512_((Vec3i)harpoon.getAnchorPos());
            double px = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_());
            double py = Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_());
            double pz = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_());
            Vec3 playerPos = new Vec3(px, py + (double)player.m_20192_(), pz);
            Vec3 toAnchor = anchor.m_82546_(playerPos).m_82541_();
            float yawRad = -player.m_146908_() * ((float)Math.PI / 180);
            float pitchRad = -player.m_146909_() * ((float)Math.PI / 180);
            double forwardsInfluence = new Vec3(Math.sin(yawRad), 0.0, -Math.cos(yawRad)).m_82526_(toAnchor);
            double lateralInfluence = -new Vec3(Math.sin(pitchRad) + Math.cos(yawRad), 0.0, Math.cos(pitchRad) - Math.cos(yawRad)).m_82526_(toAnchor);
            float forwardsMaxTilt = (float)(5.0 * (Double)mc.f_91066_.m_231925_().m_231551_());
            float lateralMaxTilt = (float)(5.0 * (Double)mc.f_91066_.m_231925_().m_231551_());
            targetPitch = (float)Mth.m_14008_((double)(forwardsInfluence * (double)forwardsMaxTilt), (double)(-forwardsMaxTilt), (double)forwardsMaxTilt);
            targetRoll = (float)Mth.m_14008_((double)(lateralInfluence * (double)lateralMaxTilt), (double)(-lateralMaxTilt), (double)lateralMaxTilt);
        }
        smoothPitch = Mth.m_14179_((float)0.15f, (float)smoothPitch, (float)targetPitch);
        smoothRoll = Mth.m_14179_((float)0.15f, (float)smoothRoll, (float)targetRoll);
        event.setPitch(event.getPitch() + smoothPitch);
        event.setRoll(event.getRoll() + smoothRoll);
    }

    @SubscribeEvent
    public void preRenderGuiOverlay(RenderGuiOverlayEvent.Pre event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.EXPERIENCE_BAR.id()) && player.m_20202_() instanceof Springling) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void postRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Entity entity = player.m_20202_();
        if (entity instanceof Springling) {
            Springling springling = (Springling)entity;
            int screenWidth = event.getWindow().m_85445_();
            int screenHeight = event.getWindow().m_85446_();
            int j = screenWidth / 2 - 91;
            int k = screenHeight - 32 + 3;
            float progress = ((float)springling.getMaxExtendedAmount() - springling.getExtendedAmount()) / (float)springling.getMaxExtendedAmount();
            int progressScaled = 182 - Mth.m_14167_((float)(progress * 182.0f));
            event.getGuiGraphics().m_280168_().m_85836_();
            event.getGuiGraphics().m_280398_(SPECIES_ICONS, j, k, 50, 0.0f, 64.0f, 182, 5, 256, 256);
            event.getGuiGraphics().m_280398_(SPECIES_ICONS, j, k, 50, 0.0f, 69.0f, progressScaled, 5, 256, 256);
            event.getGuiGraphics().m_280168_().m_85849_();
        }
    }

    @SubscribeEvent
    public static void registerCreativeModeTab(BuildCreativeModeTabContentsEvent event) {
        ResourceKey key = event.getTabKey();
        MutableHashedLinkedMap entries = event.getEntries();
        if (key == SpeciesCreativeModeTabs.SPECIES.getKey()) {
            entries.putAfter((Object)new ItemStack((ItemLike)SpeciesItems.GHOUL_TONGUE.get()), (Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)((Potion)SpeciesPotions.BLOODLUST.get())), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)((Potion)SpeciesPotions.BLOODLUST.get())), (Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)((Potion)SpeciesPotions.BLOODLUST.get())), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)((Potion)SpeciesPotions.BLOODLUST.get())), (Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)((Potion)SpeciesPotions.BLOODLUST.get())), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)((Potion)SpeciesPotions.BLOODLUST.get())), (Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)((Potion)SpeciesPotions.BLOODLUST.get())), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SpeciesItems.WEREFANG.get()), (Object)ClientEventsHandler.getHopefulBannerInstance(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SpeciesItems.CRANKBOW.get()), (Object)EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)SpeciesEnchantments.SPARING.get(), ((Enchantment)SpeciesEnchantments.SPARING.get()).m_6586_())), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SpeciesItems.CRANKBOW.get()), (Object)EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)SpeciesEnchantments.CAPACITY.get(), ((Enchantment)SpeciesEnchantments.CAPACITY.get()).m_6586_())), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SpeciesItems.CRANKBOW.get()), (Object)EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)SpeciesEnchantments.QUICK_CRANK.get(), ((Enchantment)SpeciesEnchantments.QUICK_CRANK.get()).m_6586_())), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SpeciesItems.CRANKBOW.get()), (Object)EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)SpeciesEnchantments.SCATTERSHOT.get(), ((Enchantment)SpeciesEnchantments.SCATTERSHOT.get()).m_6586_())), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SpeciesItems.HARPOON.get()), (Object)ClientEventsHandler.getSpeciesPainting((PaintingVariant)SpeciesPaintingVariants.THE_COMPOSITION.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (key == CreativeModeTabs.f_256776_) {
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42129_), (Object)new ItemStack((ItemLike)SpeciesItems.BIRT_DWELLING.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_276468_), (Object)new ItemStack((ItemLike)SpeciesItems.WRAPTOR_EGG.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (key == CreativeModeTabs.f_256869_) {
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_283830_), (Object)new ItemStack((ItemLike)SpeciesItems.MUSIC_DISC_DIAL.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SpeciesItems.MUSIC_DISC_DIAL.get()), (Object)new ItemStack((ItemLike)SpeciesItems.MUSIC_DISC_LAPIDARIAN.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SpeciesItems.MUSIC_DISC_LAPIDARIAN.get()), (Object)new ItemStack((ItemLike)SpeciesItems.MUSIC_DISK_SPAWNER.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42456_), (Object)new ItemStack((ItemLike)SpeciesItems.DEEPFISH_BUCKET.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putBefore((Object)new ItemStack((ItemLike)Items.f_42584_), (Object)new ItemStack((ItemLike)SpeciesItems.WICKED_MASK.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42584_), (Object)new ItemStack((ItemLike)SpeciesItems.WICKED_SWAPPER.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (key == CreativeModeTabs.f_256797_) {
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42521_), (Object)new ItemStack((ItemLike)SpeciesItems.BIRT_EGG.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42653_), (Object)new ItemStack((ItemLike)SpeciesItems.DEFLECTOR_DUMMY.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42740_), (Object)new ItemStack((ItemLike)SpeciesItems.RICOSHIELD.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42717_), (Object)new ItemStack((ItemLike)SpeciesItems.CRANKBOW.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putBefore((Object)new ItemStack((ItemLike)Items.f_42452_), (Object)new ItemStack((ItemLike)SpeciesItems.SMOKE_BOMB.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putBefore((Object)new ItemStack((ItemLike)Items.f_42423_), (Object)new ItemStack((ItemLike)SpeciesItems.SPECTRALIBUR.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (key == CreativeModeTabs.f_256968_) {
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42521_), (Object)new ItemStack((ItemLike)SpeciesItems.BIRT_EGG.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42591_), (Object)new ItemStack((ItemLike)SpeciesItems.GHOUL_TONGUE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putBefore((Object)new ItemStack((ItemLike)Items.f_42686_), (Object)new ItemStack((ItemLike)SpeciesItems.KINETIC_CORE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42401_), (Object)new ItemStack((ItemLike)SpeciesItems.WICKED_WAX.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42401_), (Object)new ItemStack((ItemLike)SpeciesItems.WEREFANG.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42401_), (Object)new ItemStack((ItemLike)SpeciesItems.BROKEN_LINKS.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42584_), (Object)new ItemStack((ItemLike)SpeciesItems.WICKED_SWAPPER.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (key == CreativeModeTabs.f_257028_) {
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42650_), (Object)new ItemStack((ItemLike)SpeciesItems.DEFLECTOR_DUMMY.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (key == CreativeModeTabs.f_256839_) {
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42591_), (Object)new ItemStack((ItemLike)SpeciesItems.GHOUL_TONGUE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42583_), (Object)new ItemStack((ItemLike)SpeciesItems.MONSTER_MEAL.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42437_), (Object)new ItemStack((ItemLike)SpeciesItems.WICKED_DOPE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SpeciesItems.WICKED_DOPE.get()), (Object)new ItemStack((ItemLike)SpeciesItems.CRACKED_WRAPTOR_EGG.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42591_), (Object)new ItemStack((ItemLike)SpeciesItems.WICKED_TREAT.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (key == CreativeModeTabs.f_256791_) {
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42681_), (Object)new ItemStack((ItemLike)SpeciesItems.WICKED_CANDLE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42682_), (Object)new ItemStack((ItemLike)SpeciesItems.BEWEREAGER_HEAD.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SpeciesItems.BEWEREAGER_HEAD.get()), (Object)new ItemStack((ItemLike)SpeciesItems.QUAKE_HEAD.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putBefore((Object)new ItemStack((ItemLike)Items.f_42678_), (Object)ClientEventsHandler.getHopefulBannerInstance(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)SpeciesItems.QUAKE_HEAD.get()), (Object)new ItemStack((ItemLike)SpeciesItems.GHOUL_HEAD.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42790_), (Object)new ItemStack((ItemLike)SpeciesItems.SPECTRALIBUR_PEDESTAL.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_220222_), (Object)new ItemStack((ItemLike)SpeciesItems.CHAINDELIER.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_220222_), (Object)new ItemStack((ItemLike)SpeciesItems.SPECLIGHT.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_220222_), (Object)new ItemStack((ItemLike)SpeciesItems.HOPELIGHT.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (key == CreativeModeTabs.f_256731_) {
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42605_), (Object)new ItemStack((ItemLike)SpeciesItems.WRAPTOR_SPAWN_EGG.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42622_), (Object)new ItemStack((ItemLike)SpeciesItems.LIMPET_SPAWN_EGG.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42558_), (Object)new ItemStack((ItemLike)SpeciesItems.DEEPFISH_SPAWN_EGG.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42548_), (Object)new ItemStack((ItemLike)SpeciesItems.BIRT_SPAWN_EGG.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42636_), (Object)new ItemStack((ItemLike)SpeciesItems.STACKATICK_SPAWN_EGG.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42564_), (Object)new ItemStack((ItemLike)SpeciesItems.GHOUL_SPAWN_EGG.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42635_), (Object)new ItemStack((ItemLike)SpeciesItems.QUAKE_SPAWN_EGG.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putBefore((Object)new ItemStack((ItemLike)Items.f_42645_), (Object)new ItemStack((ItemLike)SpeciesItems.SPECTRE_SPAWN_EGG.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putBefore((Object)new ItemStack((ItemLike)Items.f_42604_), (Object)new ItemStack((ItemLike)SpeciesItems.WICKED_SPAWN_EGG.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42548_), (Object)new ItemStack((ItemLike)SpeciesItems.BEWEREAGER_SPAWN_EGG.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    @SubscribeEvent
    public static void registerParticleTypes(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)SpeciesParticles.SNORING.get(), SnoringParticle.Factory::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.BIRTD.get(), RotatingParticle.BirtdFactory::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.FOOD.get(), RotatingParticle.FoodFactory::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.ASCENDING_DUST.get(), AscendingDustParticle.Factory::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.TREEPER_LEAF.get(), TreeperLeafParticle.Factory::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.YOUTH_POTION.get(), IchorBottleParticle.Factory::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.ICHOR.get(), IchorParticle.Factory::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.DRIPPING_PELLET_DRIP.get(), DripParticle.PelletDripHangProvider::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.FALLING_PELLET_DRIP.get(), DripParticle.PelletDripFallProvider::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.LANDING_PELLET_DRIP.get(), DripParticle.PelletDripLandProvider::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.GHOUL_SEARCHING.get(), GhoulSearchParticle.Provider::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.GHOUL_SEARCHING2.get(), GhoulSearchParticle.Provider::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.KINETIC_ENERGY.get(), KineticEnergyParticle.BigProvider::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.SMALL_KINETIC_ENERGY.get(), KineticEnergyParticle.SmallProvider::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.WICKED_FLAME.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.WICKED_EMBER.get(), WickedEmberParticle.Factory::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.POOF.get(), PoofParticle.Provider::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.SPECTRALIBUR.get(), SpectraliburParticle.Provider::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.SPECTRALIBUR_INVERTED.get(), SpectraliburParticle.ProviderInverted::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.SPECTRALIBUR_RELEASED.get(), SpectraliburReleasedParticle.Provider::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.SPECTRE_SMOKE.get(), SpectreSmokeParticle.Factory::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.ASCENDING_SPECTRE_SMOKE.get(), AscendingSpectreParticle.SmokeFactory::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.SPECTRE_POP.get(), SpectrePopParticle.Factory::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.BROKEN_LINK.get(), BrokenLinkParticle.Factory::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.COLLECTED_SOUL.get(), AscendingSpectreParticle.SoulFactory::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.BEWEREAGER_HOWL.get(), BewereagerHowlParticle.Provider::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.BEWEREAGER_SPEED.get(), BewereagerParticle.Provider::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.BEWEREAGER_SLOW.get(), BewereagerParticle.ProviderInverted::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.DRIPPING_HANGER_SALIVA.get(), DripParticle.HangerSalivaHangProvider::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.FALLING_HANGER_SALIVA.get(), DripParticle.HangerSalivaFallProvider::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.LANDING_HANGER_SALIVA.get(), DripParticle.HangerSalivaLandProvider::new);
        event.registerSpriteSet((ParticleType)SpeciesParticles.HANGER_CRIT.get(), HangerCritParticle.Provider::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SpeciesEntities.WRAPTOR.get(), WraptorRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.STACKATICK.get(), StackatickRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.DEEPFISH.get(), DeepfishRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.BIRT.get(), BirtRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.BIRT_EGG.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.LIMPET.get(), LimpetRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.TREEPER.get(), TreeperRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.TROOPER.get(), TrooperRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.GOOBER.get(), GooberRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.GOOBER_GOO.get(), GooberGooRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.CRUNCHER.get(), CruncherRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.MAMMUTILATION.get(), MammutilationRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.SPRINGLING.get(), SpringlingRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.CRUNCHER_PELLET.get(), FallingBlockRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.GHOUL.get(), GhoulRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.QUAKE.get(), QuakeRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.DEFLECTOR_DUMMY.get(), DeflectorDummyRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.SPECTRE.get(), SpectreRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.WICKED.get(), WickedRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.WICKED_FIREBALL.get(), WickedFireballRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.WICKED_SWAPPER.get(), WickedSwapperProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.BEWEREAGER.get(), BewereagerRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.LEAF_HANGER.get(), LeafHangerRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.CLIFF_HANGER.get(), CliffHangerRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.COIL.get(), CoilRenderer::new);
        event.registerEntityRenderer((EntityType)SpeciesEntities.HARPOON.get(), HarpoonRenderer::new);
    }

    @SubscribeEvent
    public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SpeciesEntityModelLayers.LIMPET, LimpetModel::getLayerDefinition);
        event.registerLayerDefinition(SpeciesEntityModelLayers.DEEPFISH, DeepfishModel::getLayerDefinition);
        event.registerLayerDefinition(SpeciesEntityModelLayers.STACKATICK, StackatickModel::getLayerDefinition);
        event.registerLayerDefinition(SpeciesEntityModelLayers.BIRT, BirtModel::getLayerDefinition);
        event.registerLayerDefinition(SpeciesEntityModelLayers.WRAPTOR, WraptorModel::createBodyLayer);
        event.registerLayerDefinition(SpeciesEntityModelLayers.TREEPER, TreeperModel::getLayerDefinition);
        event.registerLayerDefinition(SpeciesEntityModelLayers.TROOPER, TrooperModel::getLayerDefinition);
        event.registerLayerDefinition(SpeciesEntityModelLayers.GOOBER, GooberModel::getLayerDefinition);
        event.registerLayerDefinition(SpeciesEntityModelLayers.GOOBER_GOO, GooberGooModel::createLayer);
        event.registerLayerDefinition(SpeciesEntityModelLayers.CRUNCHER, CruncherModel::getLayerDefinition);
        event.registerLayerDefinition(SpeciesEntityModelLayers.MAMMUTILATION, MammutilationModel::getLayerDefinition);
        event.registerLayerDefinition(SpeciesEntityModelLayers.SPRINGLING, SpringlingModel::getLayerDefinition);
        event.registerLayerDefinition(SpeciesEntityModelLayers.GHOUL, GhoulModel::getLayerDefinition);
        event.registerLayerDefinition(SpeciesEntityModelLayers.GHOUL_HEAD, GhoulHeadModel::createBodyLayer);
        event.registerLayerDefinition(SpeciesEntityModelLayers.QUAKE, QuakeModel::getLayerDefinition);
        event.registerLayerDefinition(SpeciesEntityModelLayers.QUAKE_HEAD, QuakeHeadModel::createBodyLayer);
        event.registerLayerDefinition(SpeciesEntityModelLayers.DEFLECTOR_DUMMY, DeflectorDummyModel::getLayerDefinition);
        event.registerLayerDefinition(SpeciesEntityModelLayers.BEWEREAGER, BewereagerModel::getLayerDefinition);
        event.registerLayerDefinition(SpeciesEntityModelLayers.BEWEREAGER_HEAD, BewereagerHeadModel::createBodyLayer);
        event.registerLayerDefinition(SpeciesEntityModelLayers.SPECTRE, SpectreModel::createBodyLayer);
        event.registerLayerDefinition(SpeciesEntityModelLayers.SABLE_SPECTRE, SpectreModel::createSableBodyLayer);
        event.registerLayerDefinition(SpeciesEntityModelLayers.JOUSTING_SPECTRE, SpectreModel::createJoustingBodyLayer);
        event.registerLayerDefinition(SpeciesEntityModelLayers.WICKED, WickedModel::getLayerDefinition);
        event.registerLayerDefinition(SpeciesEntityModelLayers.WICKED_FIREBALL, WickedFireballRenderer::createLayer);
        event.registerLayerDefinition(SpeciesEntityModelLayers.WICKED_CANDLE, WickedHeadModel::createBodyLayer);
        event.registerLayerDefinition(SpeciesEntityModelLayers.LEAF_HANGER, HangerModel::createBodyLayer);
        event.registerLayerDefinition(SpeciesEntityModelLayers.CLIFF_HANGER, HangerModel::createBodyLayer);
        event.registerLayerDefinition(SpeciesEntityModelLayers.COIL, CoilRenderer::createBodyLayer);
        event.registerLayerDefinition(SpeciesEntityModelLayers.COIL_KNOT, CoilRenderer::createKnotBodyLayer);
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                Item patt32433$temp = stack.m_41720_();
                if (patt32433$temp instanceof SpectreLightBlockItem) {
                    SpectreLightBlockItem spectreLightBlockItem = (SpectreLightBlockItem)patt32433$temp;
                    return spectreLightBlockItem.m_41121_(stack);
                }
                return 8188661;
            }
            return 0xFFFFFF;
        }, new ItemLike[]{(ItemLike)SpeciesBlocks.SPECLIGHT.get(), (ItemLike)SpeciesBlocks.HOPELIGHT.get()});
    }

    @SubscribeEvent
    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)SpeciesBlockEntities.SPECTRALIBUR.get(), SpectraliburPedestalBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SpeciesBlockEntities.SPECLIGHT.get(), SpeclightBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SpeciesBlockEntities.HOPELIGHT.get(), HopelightBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SpeciesBlockEntities.CHAINDELIER.get(), ChaindelierBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SpeciesBlockEntities.MOB_HEAD.get(), MobHeadBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SpeciesBlockEntities.BIRTDAY_CAKE.get(), BirtdayCakeBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(SpeciesKeyMappings.EXTEND_KEY);
        event.register(SpeciesKeyMappings.RETRACT_KEY);
    }

    @SubscribeEvent
    public static void onRegisterSpectatorShaders(RegisterEntitySpectatorShadersEvent event) {
        event.register((EntityType)SpeciesEntities.GHOUL.get(), new ResourceLocation("species", "shaders/post/blind.json"));
        event.register((EntityType)SpeciesEntities.BEWEREAGER.get(), new ResourceLocation("species", "shaders/post/dog_vision.json"));
        event.register((EntityType)SpeciesEntities.WICKED.get(), new ResourceLocation("species", "shaders/post/shadow.json"));
        event.register((EntityType)SpeciesEntities.QUAKE.get(), new ResourceLocation("species", "shaders/post/clank.json"));
    }
}

