/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.network.forge;

import io.github.mortuusars.horseman.network.PacketDirection;
import io.github.mortuusars.horseman.network.packet.IPacket;
import io.github.mortuusars.horseman.network.packet.client.SyncHorseDataS2CP;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketsImpl {
    private static final String PROTOCOL_VERSION = "1";
    private static int id = 0;
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("horseman:packets"), () -> "1", "1"::equals, "1"::equals);

    public static void register() {
        CHANNEL.messageBuilder(SyncHorseDataS2CP.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncHorseDataS2CP::toBuffer).decoder(SyncHorseDataS2CP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
    }

    public static void sendToServer(IPacket packet) {
        CHANNEL.sendToServer((Object)packet);
    }

    public static void sendToClient(IPacket packet, ServerPlayer player) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static void sendToAllClients(IPacket packet) {
        CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public static void sendToPlayersTrackingEntity(Entity entity, IPacket packet) {
        CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)packet);
    }

    private static <T extends IPacket> void handlePacket(T packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        packet.handle(PacketsImpl.direction(context.getDirection()), (Player)context.getSender());
    }

    private static PacketDirection direction(NetworkDirection direction) {
        if (direction == NetworkDirection.PLAY_TO_SERVER) {
            return PacketDirection.TO_SERVER;
        }
        if (direction == NetworkDirection.PLAY_TO_CLIENT) {
            return PacketDirection.TO_CLIENT;
        }
        throw new IllegalStateException("Can only convert direction for Client/Server, not others.");
    }
}

