/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.utils;

import me.pandamods.joml.Matrix3dc;
import me.pandamods.joml.Matrix3fc;
import me.pandamods.joml.Matrix4dc;
import me.pandamods.joml.Matrix4fc;
import me.pandamods.joml.Quaterniond;
import me.pandamods.joml.Quaterniondc;
import me.pandamods.joml.Quaternionf;
import me.pandamods.joml.Quaternionfc;
import me.pandamods.joml.Vector2dc;
import me.pandamods.joml.Vector2fc;
import me.pandamods.joml.Vector2ic;
import me.pandamods.joml.Vector3d;
import me.pandamods.joml.Vector3dc;
import me.pandamods.joml.Vector3f;
import me.pandamods.joml.Vector3fc;
import me.pandamods.joml.Vector3ic;
import me.pandamods.joml.Vector4dc;
import me.pandamods.joml.Vector4fc;
import me.pandamods.joml.Vector4ic;

public class PrintUtils {
    public static String getVector2String(Vector2fc vector) {
        return PrintUtils.getVector2String(vector.x(), vector.y());
    }

    public static String getVector2String(Vector2dc vector) {
        return PrintUtils.getVector2String(vector.x(), vector.y());
    }

    public static String getVector2String(Vector2ic vector) {
        return PrintUtils.getVector2String(vector.x(), vector.y());
    }

    public static String getVector2String(double x, double y) {
        return "Vector2[" + x + ", " + y + "]";
    }

    public static String getVector3String(Vector3fc vector) {
        return PrintUtils.getVector3String(vector.x(), vector.y(), vector.z());
    }

    public static String getVector3String(Vector3dc vector) {
        return PrintUtils.getVector3String(vector.x(), vector.y(), vector.z());
    }

    public static String getVector3String(Vector3ic vector) {
        return PrintUtils.getVector3String(vector.x(), vector.y(), vector.z());
    }

    public static String getVector3String(double x, double y, double z) {
        return "Vector3[" + x + ", " + y + ", " + z + "]";
    }

    public static String getVector4String(Vector4fc vector) {
        return PrintUtils.getVector4String(vector.x(), vector.y(), vector.z(), vector.w());
    }

    public static String getVector4String(Vector4dc vector) {
        return PrintUtils.getVector4String(vector.x(), vector.y(), vector.z(), vector.w());
    }

    public static String getVector4String(Vector4ic vector) {
        return PrintUtils.getVector4String(vector.x(), vector.y(), vector.z(), vector.w());
    }

    public static String getVector4String(double x, double y, double z, double w) {
        return "Vector4[" + x + ", " + y + ", " + z + ", " + w + "]";
    }

    public static String getQuaternionString(Quaternionfc quaternion) {
        return PrintUtils.getQuaternionString(quaternion.x(), quaternion.y(), quaternion.z(), quaternion.w());
    }

    public static String getQuaternionString(Quaterniondc quaternion) {
        return PrintUtils.getQuaternionString(quaternion.x(), quaternion.y(), quaternion.z(), quaternion.w());
    }

    private static String getQuaternionString(double x, double y, double z, double w) {
        return "Quaternion[" + x + ", " + y + ", " + z + ", " + w + "]";
    }

    public static String getMatrix3String(Matrix3fc matrix) {
        return "Matrix3[\n| Rotation (Euler): " + PrintUtils.getVector3String(matrix.getEulerAnglesXYZ(new Vector3f())) + "\n| Rotation (Quaternion): " + PrintUtils.getQuaternionString(matrix.getNormalizedRotation(new Quaternionf())) + "\n\\ Scale: " + PrintUtils.getVector3String(matrix.getScale(new Vector3f())) + "\n]";
    }

    public static String getMatrix3String(Matrix3dc matrix) {
        return "Matrix3[\n| Rotation (Euler): " + PrintUtils.getVector3String(matrix.getEulerAnglesXYZ(new Vector3d())) + "\n| Rotation (Quaternion): " + PrintUtils.getQuaternionString(matrix.getNormalizedRotation(new Quaterniond())) + "\n\\ Scale: " + PrintUtils.getVector3String(matrix.getScale(new Vector3d())) + "\n]";
    }

    public static String getMatrix4String(Matrix4fc matrix) {
        return "Matrix4[\n| Translation: " + PrintUtils.getVector3String(matrix.getTranslation(new Vector3f())) + "\n| Rotation (Euler): " + PrintUtils.getVector3String(matrix.getEulerAnglesXYZ(new Vector3f())) + "\n| Rotation (Quaternion): " + PrintUtils.getQuaternionString(matrix.getNormalizedRotation(new Quaternionf())) + "\n\\ Scale: " + PrintUtils.getVector3String(matrix.getScale(new Vector3f())) + "\n]";
    }

    public static String getMatrix4String(Matrix4dc matrix) {
        return "Matrix4[\n| Translation: " + PrintUtils.getVector3String(matrix.getTranslation(new Vector3d())) + "\n| Rotation (Euler): " + PrintUtils.getVector3String(matrix.getEulerAnglesXYZ(new Vector3d())) + "\n| Rotation (Quaternion): " + PrintUtils.getQuaternionString(matrix.getNormalizedRotation(new Quaterniond())) + "\n\\ Scale: " + PrintUtils.getVector3String(matrix.getScale(new Vector3d())) + "\n]";
    }
}

