/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import me.pandamods.pandalib.platform.Services;
import me.pandamods.pandalib.registry.DeferredObject;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class DeferredRegister<T> {
    private final String namespace;
    private final ResourceKey<? extends Registry<T>> registryKey;
    private final Map<DeferredObject<? extends T>, Supplier<? extends T>> entries = new HashMap<DeferredObject<? extends T>, Supplier<? extends T>>();

    public static <T> DeferredRegister<T> create(String namespace, ResourceLocation registryLocation) {
        return DeferredRegister.create(namespace, ResourceKey.m_135788_((ResourceLocation)registryLocation));
    }

    public static <T> DeferredRegister<T> create(String namespace, Registry<T> registry) {
        return DeferredRegister.create(namespace, registry.m_123023_());
    }

    public static <T> DeferredRegister<T> create(String namespace, ResourceKey<? extends Registry<T>> registryKey) {
        return new DeferredRegister<T>(namespace, registryKey);
    }

    private DeferredRegister(String namespace, ResourceKey<? extends Registry<T>> registryKey) {
        this.namespace = namespace;
        this.registryKey = registryKey;
    }

    public <R extends T> DeferredObject<R> register(String name, Function<ResourceKey<T>, R> registryFunc) {
        return this.register(new ResourceLocation(this.namespace, name), registryFunc);
    }

    public <R extends T> DeferredObject<R> register(String name, Supplier<R> registrySup) {
        return this.register(new ResourceLocation(this.namespace, name), registrySup);
    }

    public <R extends T> DeferredObject<R> register(ResourceLocation name, Function<ResourceKey<T>, R> registryFunc) {
        ResourceKey key = ResourceKey.m_135785_(this.registryKey, (ResourceLocation)name);
        return this.register(key, () -> registryFunc.apply(key));
    }

    public <R extends T> DeferredObject<R> register(ResourceLocation name, Supplier<R> registrySup) {
        return this.register(ResourceKey.m_135785_(this.registryKey, (ResourceLocation)name), registrySup);
    }

    private <R extends T> DeferredObject<R> register(ResourceKey<T> resourceKey, Supplier<R> registrySup) {
        DeferredObject deferredObject = new DeferredObject(resourceKey);
        this.entries.put(deferredObject, registrySup);
        return deferredObject;
    }

    public void register() {
        this.entries.forEach(Services.REGISTRATION::register);
    }
}

