/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.forge.platform;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.pandamods.pandalib.platform.services.ModLoaderHelper;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class ModLoaderHelperImpl
implements ModLoaderHelper {
    private final Map<String, ModLoaderHelper.Mod> mods = new HashMap<String, ModLoaderHelper.Mod>();

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public ModLoaderHelper.Mod getMod(String modId) {
        return this.mods.computeIfAbsent(modId, ModImpl::new);
    }

    @Override
    public List<ModLoaderHelper.Mod> getMods() {
        for (IModInfo mod : ModList.get().getMods()) {
            this.getMod(mod.getModId());
        }
        return List.copyOf(this.mods.values());
    }

    @Override
    public List<String> getModIds() {
        return ModList.get().getMods().stream().map(IModInfo::getModId).toList();
    }

    private static class ModImpl
    implements ModLoaderHelper.Mod {
        private final ModContainer container;
        private final IModInfo info;

        public ModImpl(String modId) {
            this.container = (ModContainer)ModList.get().getModContainerById(modId).orElseThrow();
            this.info = ModList.get().getMods().stream().filter(modInfo -> Objects.equals(modInfo.getModId(), modId)).findAny().orElseThrow();
        }

        @Override
        public String getId() {
            return this.info.getModId();
        }

        @Override
        public String getDisplayName() {
            return this.info.getDisplayName();
        }

        @Override
        public String getDescription() {
            return this.info.getDescription();
        }

        @Override
        public List<String> getAuthors() {
            Optional<String> optional = this.info.getConfig().getConfigElement(new String[]{"authors"}).map(String::valueOf);
            return optional.map(List::of).orElse(Collections.emptyList());
        }

        @Override
        public String getVersion() {
            return this.info.getVersion().toString();
        }
    }
}

