/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.core.network;

import com.google.gson.JsonElement;
import io.netty.buffer.Unpooled;
import me.pandamods.pandalib.config.ConfigData;
import me.pandamods.pandalib.config.PandaLibConfig;
import me.pandamods.pandalib.config.holders.ClientConfigHolder;
import me.pandamods.pandalib.config.holders.CommonConfigHolder;
import me.pandamods.pandalib.networking.NetworkContext;
import me.pandamods.pandalib.networking.NetworkRegistry;
import me.pandamods.pandalib.networking.PacketDistributor;
import me.pandamods.pandalib.utils.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ConfigNetworking {
    public static final ResourceLocation PACKET_ID = new ResourceLocation("pandalib", "config_sync");

    public static void registerPackets(NetworkRegistry registry) {
        registry.registerBiDirectionalReceiver(PACKET_ID, ConfigNetworking::CommonConfigReceiver, ConfigNetworking::ClientConfigReceiver);
    }

    public static void SyncCommonConfigs(ServerPlayer serverPlayer) {
        PandaLibConfig.getConfigs().values().stream().filter(configHolder -> configHolder instanceof CommonConfigHolder && configHolder.shouldSynchronize()).forEach(configHolder -> ConfigNetworking.SyncCommonConfig(serverPlayer, (CommonConfigHolder)configHolder));
    }

    public static void SyncCommonConfig(ServerPlayer serverPlayer, CommonConfigHolder<?> holder) {
        holder.logger.info("Sending common config '{}' to {}", (Object)holder.resourceLocation().toString(), (Object)serverPlayer.m_5446_().getString());
        FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.buffer());
        byteBuf.m_130085_(holder.resourceLocation());
        byteBuf.m_130079_((CompoundTag)NBTUtils.convertJsonToTag(holder.getGson().toJsonTree(holder.get())));
        PacketDistributor.sendToPlayer(serverPlayer, PACKET_ID, byteBuf);
    }

    public static void SyncClientConfigs() {
        PandaLibConfig.getConfigs().values().stream().filter(configHolder -> configHolder instanceof ClientConfigHolder && configHolder.shouldSynchronize()).forEach(configHolder -> ConfigNetworking.SyncClientConfig((ClientConfigHolder)configHolder));
    }

    public static void SyncClientConfig(ClientConfigHolder<?> holder) {
        holder.logger.info("Sending client config '{}' to server", (Object)holder.resourceLocation().toString());
        FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.buffer());
        byteBuf.m_130085_(holder.resourceLocation());
        byteBuf.m_130079_((CompoundTag)NBTUtils.convertJsonToTag(holder.getGson().toJsonTree(holder.get())));
        PacketDistributor.sendToServer(PACKET_ID, byteBuf);
    }

    private static void ClientConfigReceiver(NetworkContext ctx, FriendlyByteBuf byteBuf) {
        ResourceLocation resourceLocation = byteBuf.m_130281_();
        PandaLibConfig.getConfig(resourceLocation).ifPresent(configHolder -> {
            if (configHolder instanceof ClientConfigHolder) {
                ClientConfigHolder clientConfigHolder = (ClientConfigHolder)configHolder;
                configHolder.logger.info("Received client config '{}' from {}", (Object)configHolder.resourceLocation().toString(), (Object)ctx.getPlayer().m_5446_().getString());
                JsonElement configJson = NBTUtils.convertTagToJson((Tag)byteBuf.m_130260_());
                clientConfigHolder.putConfig(ctx.getPlayer(), (ConfigData)configHolder.getGson().fromJson(configJson, configHolder.getConfigClass()));
            }
        });
    }

    private static void CommonConfigReceiver(NetworkContext ctx, FriendlyByteBuf byteBuf) {
        ResourceLocation resourceLocation = byteBuf.m_130281_();
        PandaLibConfig.getConfig(resourceLocation).ifPresent(configHolder -> {
            if (configHolder instanceof CommonConfigHolder) {
                CommonConfigHolder commonConfigHolder = (CommonConfigHolder)configHolder;
                configHolder.logger.info("Received common config '{}' from server", (Object)configHolder.resourceLocation().toString());
                JsonElement configJson = NBTUtils.convertTagToJson((Tag)byteBuf.m_130260_());
                commonConfigHolder.setCommonConfig((ConfigData)configHolder.getGson().fromJson(configJson, configHolder.getConfigClass()));
            }
        });
    }
}

